/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.CpuBuffer;
import javax.annotation.Nullable;

public class CpuBufferPool {
    private final CpuBuffer[] mBuffers;

    public CpuBufferPool(int maxCount) {
        this.mBuffers = new CpuBuffer[maxCount];
    }

    @Nullable
    @SharedPtr
    public CpuBuffer makeBuffer(long size) {
        assert (size > 0L);
        CpuBuffer result = null;
        if (size <= 131072L) {
            int i;
            for (i = 0; i < this.mBuffers.length && this.mBuffers[i] != null; ++i) {
                assert (this.mBuffers[i].size() == 131072L);
                if (!this.mBuffers[i].unique()) continue;
                result = this.mBuffers[i];
            }
            if (result == null && i < this.mBuffers.length) {
                this.mBuffers[i] = result = CpuBuffer.make(131072L);
            }
        }
        if (result == null) {
            return CpuBuffer.make(size);
        }
        return RefCnt.create(result);
    }

    public void releaseAll() {
        for (int i = 0; i < this.mBuffers.length && this.mBuffers[i] != null; ++i) {
            this.mBuffers[i].unref();
            this.mBuffers[i] = null;
        }
    }
}

