/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Buffer;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.GraphicsPipeline;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.PipelineDesc;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.RenderPassDesc;
import icyllis.arc3d.engine.Resource;
import icyllis.arc3d.engine.ResourceProvider;
import icyllis.arc3d.engine.Sampler;
import icyllis.arc3d.engine.SamplerDesc;
import icyllis.arc3d.granite.Draw;
import icyllis.arc3d.granite.DrawCommandList;
import icyllis.arc3d.granite.GeometryStep;
import icyllis.arc3d.granite.GraphicsPipelineDesc;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DrawPass
implements AutoCloseable {
    public static final int GEOMETRY_UNIFORM_BLOCK_BINDING = 0;
    public static final int FRAGMENT_UNIFORM_BLOCK_BINDING = 1;
    public static final String GEOMETRY_UNIFORM_BLOCK_NAME = "GeometryUniforms";
    public static final String FRAGMENT_UNIFORM_BLOCK_NAME = "FragmentUniforms";
    public static final int MAX_RENDER_STEPS = 4096;
    public static final int INVALID_INDEX = 4097;
    private final DrawCommandList mCommandList;
    private final Rect2i mBounds;
    private final int mDepthStencilFlags;
    private final ObjectArrayList<GraphicsPipelineDesc> mPipelineDescs;
    private final ObjectArrayList<SamplerDesc> mSamplerDescs;
    private final ObjectArrayList<@SharedPtr ImageViewProxy> mTextures;
    @SharedPtr
    private volatile GraphicsPipeline[] mPipelines;
    @SharedPtr
    private volatile Sampler[] mSamplers;

    private DrawPass(DrawCommandList commandList, Rect2i bounds, int depthStencilFlags, ObjectArrayList<GraphicsPipelineDesc> pipelineDescs, ObjectArrayList<SamplerDesc> samplerDescs, ObjectArrayList<@SharedPtr ImageViewProxy> textures) {
        this.mCommandList = commandList;
        this.mBounds = bounds;
        this.mDepthStencilFlags = depthStencilFlags;
        this.mPipelineDescs = pipelineDescs;
        this.mSamplerDescs = samplerDescs;
        this.mTextures = textures;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static DrawPass make(RecordingContext context, ObjectArrayList<Draw> drawList, int numSteps, @RawPtr ImageViewProxy targetView, ImageInfo deviceInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Rect2ic getBounds() {
        return this.mBounds;
    }

    public int getDepthStencilFlags() {
        return this.mDepthStencilFlags;
    }

    public DrawCommandList getCommandList() {
        return this.mCommandList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepare(ResourceProvider resourceProvider, RenderPassDesc renderPassDesc) {
        @SharedPtr GraphicsPipeline[] pipelines = new GraphicsPipeline[this.mPipelineDescs.size()];
        try {
            for (int i = 0; i < this.mPipelineDescs.size(); ++i) {
                GraphicsPipeline pipeline = resourceProvider.findOrCreateGraphicsPipeline((PipelineDesc)this.mPipelineDescs.get(i), renderPassDesc);
                if (pipeline == null) {
                    boolean bl = false;
                    return bl;
                }
                pipelines[i] = pipeline;
            }
        }
        finally {
            this.mPipelines = pipelines;
            this.mPipelineDescs.clear();
        }
        if (!this.mSamplerDescs.isEmpty()) {
            @SharedPtr Sampler[] samplers = new Sampler[this.mSamplerDescs.size()];
            try {
                for (int i = 0; i < this.mSamplerDescs.size(); ++i) {
                    Sampler sampler = resourceProvider.findOrCreateCompatibleSampler((SamplerDesc)this.mSamplerDescs.get(i));
                    if (sampler == null) {
                        boolean bl = false;
                        return bl;
                    }
                    samplers[i] = sampler;
                }
            }
            finally {
                this.mSamplers = samplers;
                this.mSamplerDescs.clear();
            }
        }
        return true;
    }

    public boolean execute(CommandBuffer commandBuffer) {
        for (GraphicsPipeline graphicsPipeline : this.mPipelines) {
            commandBuffer.trackResource(RefCnt.create(graphicsPipeline));
        }
        if (this.mSamplers != null) {
            for (ObjectListIterator objectListIterator : this.mSamplers) {
                commandBuffer.trackResource((Resource)RefCnt.create(objectListIterator));
            }
        }
        for (ImageViewProxy texture : this.mTextures) {
            commandBuffer.trackCommandBufferResource(texture.refImage());
        }
        DrawCommandList cmdList = this.getCommandList();
        int[] p = cmdList.mPrimitives.elements();
        int i = 0;
        Object[] objectArray = cmdList.mPointers.elements();
        int oi = 0;
        int lim = cmdList.mPrimitives.size();
        while (i < lim) {
            switch (p[i++]) {
                case 0: {
                    int pipelineIndex = p[i];
                    if (!commandBuffer.bindGraphicsPipeline(this.mPipelines[pipelineIndex])) {
                        return false;
                    }
                    ++i;
                    break;
                }
                case 1: {
                    int vertexCount = p[i];
                    int baseVertex = p[i + 1];
                    commandBuffer.draw(vertexCount, baseVertex);
                    i += 2;
                    break;
                }
                case 2: {
                    int indexCount = p[i];
                    int baseIndex = p[i + 1];
                    int baseVertex = p[i + 2];
                    commandBuffer.drawIndexed(indexCount, baseIndex, baseVertex);
                    i += 3;
                    break;
                }
                case 3: {
                    int instanceCount = p[i];
                    int baseInstance = p[i + 1];
                    int vertexCount = p[i + 2];
                    int baseVertex = p[i + 3];
                    commandBuffer.drawInstanced(instanceCount, baseInstance, vertexCount, baseVertex);
                    i += 4;
                    break;
                }
                case 4: {
                    int indexCount = p[i];
                    int baseIndex = p[i + 1];
                    int instanceCount = p[i + 2];
                    int baseInstance = p[i + 3];
                    int baseVertex = p[i + 4];
                    commandBuffer.drawIndexedInstanced(indexCount, baseIndex, instanceCount, baseInstance, baseVertex);
                    i += 5;
                    break;
                }
                case 5: {
                    int indexType = p[i];
                    long offset = p[i + 1];
                    commandBuffer.bindIndexBuffer(indexType, (Buffer)objectArray[oi++], offset);
                    i += 2;
                    break;
                }
                case 6: {
                    int binding = p[i];
                    long offset = p[i + 1];
                    commandBuffer.bindVertexBuffer(binding, (Buffer)objectArray[oi++], offset);
                    i += 2;
                    break;
                }
                case 7: {
                    int x = p[i];
                    int y = p[i + 1];
                    int width = p[i + 2];
                    int height = p[i + 3];
                    commandBuffer.setScissor(x, y, width, height);
                    i += 4;
                    break;
                }
                case 8: {
                    int binding = p[i];
                    long offset = p[i + 1];
                    long size = p[i + 2];
                    commandBuffer.bindUniformBuffer(binding, (Buffer)objectArray[oi++], offset, size);
                    i += 3;
                    break;
                }
                case 9: {
                    int numBindings = p[i++];
                    for (int binding = 0; binding < numBindings; ++binding) {
                        ImageViewProxy texture = (ImageViewProxy)this.mTextures.get(p[i]);
                        Sampler sampler = this.mSamplers[p[i + 1]];
                        commandBuffer.bindTextureSampler(binding, texture.getImage(), sampler, texture.getSwizzle());
                        i += 2;
                    }
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public void close() {
        int i;
        if (this.mPipelines != null) {
            for (i = 0; i < this.mPipelines.length; ++i) {
                this.mPipelines[i] = RefCnt.move(this.mPipelines[i]);
            }
        }
        if (this.mSamplers != null) {
            for (i = 0; i < this.mSamplers.length; ++i) {
                this.mSamplers[i] = RefCnt.move(this.mSamplers[i]);
            }
        }
        this.mTextures.forEach(RefCnt::unref);
        this.mTextures.clear();
    }

    private static /* synthetic */ Integer lambda$make$0(ObjectArrayList indexToPipeline, GraphicsPipelineDesc desc) {
        int index = indexToPipeline.size();
        indexToPipeline.add((Object)desc.copy());
        return index;
    }

    public static final class SortKey
    implements Comparable<SortKey> {
        public static final int PAINTERS_ORDER_OFFSET = 32;
        public static final int PAINTERS_ORDER_MASK = 65535;
        public static final int STENCIL_INDEX_OFFSET = 16;
        public static final int STENCIL_INDEX_MASK = 65535;
        public static final int STEP_INDEX_OFFSET = 50;
        public static final int STEP_INDEX_MASK = 3;
        public static final int PIPELINE_INDEX_OFFSET = 34;
        public static final int PIPELINE_INDEX_MASK = 65535;
        public static final int GEOMETRY_UNIFORM_INDEX_OFFSET = 17;
        public static final int GEOMETRY_UNIFORM_INDEX_MASK = 131071;
        public static final int FRAGMENT_UNIFORM_INDEX_OFFSET = 0;
        public static final int FRAGMENT_UNIFORM_INDEX_MASK = 131071;
        private final Draw mDraw;
        private final int mOrderKey;
        private final long mPipelineKey;
        private final int[] mTextures;

        public SortKey(Draw draw, int stepIndex, int pipelineIndex, int geometryUniformIndex, int fragmentUniformIndex, int[] textures) {
            this.mDraw = draw;
            this.mOrderKey = (int)(draw.mDrawOrder >>> 16);
            assert ((stepIndex & 3) == stepIndex);
            this.mPipelineKey = (long)stepIndex << 50 | (long)pipelineIndex << 34 | (long)geometryUniformIndex << 17 | (long)fragmentUniformIndex << 0;
            this.mTextures = textures;
        }

        public GeometryStep step() {
            return this.mDraw.mRenderer.step((int)(this.mPipelineKey >>> 50 & 3L));
        }

        public int pipelineIndex() {
            return (int)(this.mPipelineKey >>> 34 & 0xFFFFL);
        }

        public int geometryUniformIndex() {
            return (int)(this.mPipelineKey >>> 17 & 0x1FFFFL);
        }

        public int fragmentUniformIndex() {
            return (int)(this.mPipelineKey >>> 0 & 0x1FFFFL);
        }

        @Override
        public int compareTo(@Nonnull SortKey o) {
            int res = Integer.compareUnsigned(this.mOrderKey, o.mOrderKey);
            if (res != 0) {
                return res;
            }
            res = Long.compareUnsigned(this.mPipelineKey, o.mPipelineKey);
            if (res != 0) {
                return res;
            }
            return Arrays.compare(this.mTextures, o.mTextures);
        }
    }
}

