/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.BlendMode;
import icyllis.arc3d.engine.BlendInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BlendFormula {
    public static final byte OUTPUT_TYPE_ZERO = 0;
    public static final byte OUTPUT_TYPE_COVERAGE = 1;
    public static final byte OUTPUT_TYPE_MODULATE = 2;
    public static final byte OUTPUT_TYPE_SRC_ALPHA_MODULATE = 3;
    public static final byte OUTPUT_TYPE_ONE_MINUS_SRC_ALPHA_MODULATE = 4;
    public static final byte OUTPUT_TYPE_ONE_MINUS_SRC_COLOR_MODULATE = 5;
    public final byte mPrimaryOutput;
    public final byte mSecondaryOutput;
    public final byte mEquation;
    public final byte mSrcFactor;
    public final byte mDstFactor;
    private static final byte PROPERTY_MODIFIES_DST = 1;
    private final byte mProperties;

    public BlendFormula(byte primaryOutput, byte secondaryOutput, byte equation, byte srcFactor, byte dstFactor) {
        this.mPrimaryOutput = primaryOutput;
        this.mSecondaryOutput = secondaryOutput;
        this.mEquation = equation;
        this.mSrcFactor = srcFactor;
        this.mDstFactor = dstFactor;
        assert (primaryOutput == 0 == !BlendInfo.blendCoeffsUseSrcColor(srcFactor, dstFactor));
        assert (!BlendInfo.blendCoeffRefsSrc1(srcFactor));
        assert (secondaryOutput == 0 == !BlendInfo.blendCoeffRefsSrc1(dstFactor));
        assert (primaryOutput != secondaryOutput || primaryOutput == 0);
        assert (primaryOutput != 0 || secondaryOutput == 0);
        this.mProperties = BlendInfo.blendModifiesDst(equation, srcFactor, dstFactor) ? (byte)1 : 0;
    }

    public boolean hasSecondaryOutput() {
        return this.mSecondaryOutput != 0;
    }

    public boolean modifiesDst() {
        return (this.mProperties & 1) != 0;
    }

    private static BlendFormula makeCoeffFormula(byte equation, byte srcFactor, byte dstFactor) {
        if (0 == srcFactor && (0 == dstFactor || 1 == dstFactor)) {
            return new BlendFormula(0, 0, equation, srcFactor, dstFactor);
        }
        return new BlendFormula(2, 0, equation, srcFactor, dstFactor);
    }

    private static BlendFormula makeCoverageFormula(byte oneMinusDstFactorModulateOutput, byte srcFactor) {
        return new BlendFormula(2, oneMinusDstFactorModulateOutput, 0, srcFactor, 16);
    }

    private static BlendFormula makeCoverageSrcCoeffZeroFormula(byte oneMinusDstFactorModulateOutput) {
        return new BlendFormula(oneMinusDstFactorModulateOutput, 0, 2, 4, 1);
    }

    private static BlendFormula makeCoverageDstCoeffZeroFormula(byte srcFactor) {
        return new BlendFormula(2, 1, 0, srcFactor, 18);
    }

    @Nullable
    public static BlendFormula getBlendFormula(boolean isOpaque, boolean hasCoverage, @Nonnull BlendMode mode) {
        if (!hasCoverage) {
            switch (mode) {
                case CLEAR: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)0);
                }
                case SRC: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)0);
                }
                case DST: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)1);
                }
                case SRC_OVER: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)7);
                }
                case DST_OVER: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)1);
                }
                case SRC_IN: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)8, (byte)0);
                }
                case DST_IN: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)6);
                }
                case SRC_OUT: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)0);
                }
                case DST_OUT: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)7);
                }
                case SRC_ATOP: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)8, (byte)7);
                }
                case DST_ATOP: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)6);
                }
                case XOR: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)7);
                }
                case PLUS: 
                case PLUS_CLAMPED: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)1);
                }
                case MINUS: 
                case MINUS_CLAMPED: {
                    return BlendFormula.makeCoeffFormula((byte)2, (byte)1, (byte)1);
                }
                case MODULATE: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)2);
                }
                case SCREEN: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)3);
                }
            }
        } else if (!isOpaque) {
            switch (mode) {
                case CLEAR: {
                    return BlendFormula.makeCoverageSrcCoeffZeroFormula((byte)1);
                }
                case SRC: {
                    return BlendFormula.makeCoverageDstCoeffZeroFormula((byte)1);
                }
                case DST: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)1);
                }
                case SRC_OVER: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)7);
                }
                case DST_OVER: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)1);
                }
                case SRC_IN: {
                    return BlendFormula.makeCoverageDstCoeffZeroFormula((byte)8);
                }
                case DST_IN: {
                    return BlendFormula.makeCoverageSrcCoeffZeroFormula((byte)4);
                }
                case SRC_OUT: {
                    return BlendFormula.makeCoverageDstCoeffZeroFormula((byte)9);
                }
                case DST_OUT: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)7);
                }
                case SRC_ATOP: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)8, (byte)7);
                }
                case DST_ATOP: {
                    return BlendFormula.makeCoverageFormula((byte)4, (byte)9);
                }
                case XOR: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)7);
                }
                case PLUS: 
                case PLUS_CLAMPED: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)1);
                }
                case MINUS: 
                case MINUS_CLAMPED: {
                    return BlendFormula.makeCoeffFormula((byte)2, (byte)1, (byte)1);
                }
                case MODULATE: {
                    return BlendFormula.makeCoverageSrcCoeffZeroFormula((byte)5);
                }
                case SCREEN: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)3);
                }
            }
        } else {
            switch (mode) {
                case CLEAR: 
                case DST_OUT: {
                    return BlendFormula.makeCoverageSrcCoeffZeroFormula((byte)1);
                }
                case SRC: 
                case SRC_OVER: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)7);
                }
                case DST: 
                case DST_IN: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)0, (byte)1);
                }
                case DST_OVER: 
                case DST_ATOP: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)1);
                }
                case SRC_IN: 
                case SRC_ATOP: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)8, (byte)7);
                }
                case SRC_OUT: 
                case XOR: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)9, (byte)7);
                }
                case PLUS: 
                case PLUS_CLAMPED: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)1);
                }
                case MINUS: 
                case MINUS_CLAMPED: {
                    return BlendFormula.makeCoeffFormula((byte)2, (byte)1, (byte)1);
                }
                case MODULATE: {
                    return BlendFormula.makeCoverageSrcCoeffZeroFormula((byte)5);
                }
                case SCREEN: {
                    return BlendFormula.makeCoeffFormula((byte)0, (byte)1, (byte)3);
                }
            }
        }
        return null;
    }
}

