/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.Canvas;
import icyllis.arc3d.core.GlyphRunList;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Paint;
import icyllis.arc3d.core.StrikeCache;
import icyllis.arc3d.granite.GraniteDevice;
import icyllis.arc3d.granite.SubRunContainer;
import icyllis.arc3d.granite.TextBlobCache;
import javax.annotation.Nonnull;

public final class BakedTextBlob {
    BakedTextBlob mPrev;
    BakedTextBlob mNext;
    TextBlobCache.PrimaryKey mPrimaryKey;
    TextBlobCache.FeatureKey mFeatureKey;
    private final SubRunContainer mSubRuns;
    private final long mMemorySize;

    public BakedTextBlob(@Nonnull SubRunContainer subRuns) {
        this.mSubRuns = subRuns;
        long size = subRuns.getMemorySize();
        this.mMemorySize = size += 120L;
    }

    @Nonnull
    public static BakedTextBlob make(@Nonnull GlyphRunList glyphRunList, @Nonnull Paint paint, @Nonnull Matrixc positionMatrix, @Nonnull StrikeCache strikeCache) {
        SubRunContainer container = SubRunContainer.make(glyphRunList, positionMatrix, paint, strikeCache);
        return new BakedTextBlob(container);
    }

    public void draw(Canvas canvas, float originX, float originY, Paint paint, GraniteDevice device) {
        this.mSubRuns.draw(canvas, originX, originY, paint, device);
    }

    public long getMemorySize() {
        return this.mMemorySize;
    }
}

