/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine.task;

import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.task.Task;
import javax.annotation.Nonnull;

public class CopyImageTask
extends Task {
    @SharedPtr
    private ImageViewProxy mSrcProxy;
    private final int mSrcL;
    private final int mSrcT;
    private final int mSrcR;
    private final int mSrcB;
    @SharedPtr
    private ImageViewProxy mDstProxy;
    private final int mDstX;
    private final int mDstY;
    private final int mDstLevel;

    CopyImageTask(@SharedPtr ImageViewProxy srcProxy, int srcL, int srcT, int srcR, int srcB, @SharedPtr ImageViewProxy dstProxy, int dstX, int dstY, int dstLevel) {
        this.mSrcProxy = srcProxy;
        this.mSrcL = srcL;
        this.mSrcT = srcT;
        this.mSrcR = srcR;
        this.mSrcB = srcB;
        this.mDstProxy = dstProxy;
        this.mDstX = dstX;
        this.mDstY = dstY;
        this.mDstLevel = dstLevel;
    }

    @SharedPtr
    public static CopyImageTask make(@SharedPtr ImageViewProxy srcProxy, @Nonnull Rect2ic subset, @SharedPtr ImageViewProxy dstProxy, int dstX, int dstY, int dstLevel) {
        if (srcProxy == null || dstProxy == null) {
            RefCnt.move(srcProxy);
            RefCnt.move(dstProxy);
            return null;
        }
        return new CopyImageTask(srcProxy, subset.left(), subset.top(), subset.right(), subset.bottom(), dstProxy, dstX, dstY, dstLevel);
    }

    @Override
    protected void deallocate() {
        this.mSrcProxy = RefCnt.move(this.mSrcProxy);
        this.mDstProxy = RefCnt.move(this.mDstProxy);
    }

    @Override
    public int prepare(RecordingContext context) {
        if (!this.mDstProxy.instantiateIfNonLazy(context.getResourceProvider())) {
            return 1;
        }
        return 0;
    }

    @Override
    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        assert (this.mSrcProxy.isInstantiated());
        if (commandBuffer.copyImage(this.mSrcProxy.getImage(), this.mSrcL, this.mSrcT, this.mSrcR, this.mSrcB, this.mDstProxy.getImage(), this.mDstX, this.mDstY, this.mDstLevel)) {
            commandBuffer.trackCommandBufferResource(this.mSrcProxy.refImage());
            commandBuffer.trackCommandBufferResource(this.mDstProxy.refImage());
            return 0;
        }
        return 1;
    }
}

