/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.shaders;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Point;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.shaders.Color4fShader;
import icyllis.arc3d.core.shaders.Gradient1DShader;
import icyllis.arc3d.core.shaders.LocalMatrixShader;
import icyllis.arc3d.core.shaders.Shader;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class LinearGradient
extends Gradient1DShader {
    private final float mStartX;
    private final float mStartY;
    private final float mEndX;
    private final float mEndY;

    @VisibleForTesting
    public LinearGradient(float startX, float startY, float endX, float endY, @Nonnull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, int colorCount, int tileMode, int interpolation) {
        super(colors, colorSpace, positions, colorCount, tileMode, interpolation, LinearGradient.pts_to_unit_matrix(startX, startY, endX, endY));
        this.mStartX = startX;
        this.mStartY = startY;
        this.mEndX = endX;
        this.mEndY = endY;
    }

    private static Matrix pts_to_unit_matrix(float startX, float startY, float endX, float endY) {
        float dx = endX - startX;
        float dy = endY - startY;
        float mag = Point.length(dx, dy);
        float inv = mag != 0.0f ? 1.0f / mag : 0.0f;
        Matrix matrix = new Matrix();
        matrix.setSinCos(-(dy *= inv), dx *= inv, startX, startY);
        matrix.postTranslate(-startX, -startY);
        matrix.postScale(inv, inv);
        return matrix;
    }

    @CheckReturnValue
    @Nullable
    @SharedPtr
    public static Shader make(float startX, float startY, float endX, float endY, @Nonnull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, int colorCount, int tileMode, int interpolation, @Nullable Matrixc localMatrix) {
        float dist = Point.distanceTo(endX, endY, startX, startY);
        if (!Float.isFinite(dist)) {
            return null;
        }
        if (!LinearGradient.checkGradient1D(colors, positions, colorCount, tileMode)) {
            return null;
        }
        if (colorCount == 1) {
            return new Color4fShader(colors[0], colors[1], colors[2], colors[3], colorSpace);
        }
        if (localMatrix != null && !localMatrix.invert(null)) {
            return null;
        }
        if (Math.abs(dist) <= 1.5258789E-5f) {
            return LinearGradient.makeDegenerateGradient(colors, colorSpace, positions, colorCount, tileMode);
        }
        @SharedPtr LinearGradient s = new LinearGradient(startX, startY, endX, endY, colors, colorSpace, positions, colorCount, tileMode, interpolation);
        Matrix lm = localMatrix != null ? new Matrix(localMatrix) : new Matrix();
        return new LocalMatrixShader(s, lm);
    }

    @Override
    public int asGradient() {
        return 1;
    }

    public float getStartX() {
        return this.mStartX;
    }

    public float getStartY() {
        return this.mStartY;
    }

    public float getEndX() {
        return this.mEndX;
    }

    public float getEndY() {
        return this.mEndY;
    }
}

