/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.j2d;

import icyllis.arc3d.core.Glyph;
import icyllis.arc3d.core.Path;
import icyllis.arc3d.core.PixelUtils;
import icyllis.arc3d.core.ScalerContext;
import icyllis.arc3d.core.StrikeDesc;
import icyllis.arc3d.core.j2d.J2DUtils;
import icyllis.arc3d.core.j2d.Typeface_JDK;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import sun.misc.Unsafe;

public class ScalerContext_JDK
extends ScalerContext {
    private final Font mFont;
    private final FontRenderContext mFRC;

    public ScalerContext_JDK(Typeface_JDK typeface, StrikeDesc desc) {
        super(typeface, desc);
        AffineTransform transform = new AffineTransform(this.mDesc.getPostScaleX(), this.mDesc.getPostShearY(), this.mDesc.getPostShearX(), this.mDesc.getPostScaleY(), 0.0f, 0.0f);
        this.mFont = typeface.getFont().deriveFont(transform).deriveFont(this.mDesc.getTextSize());
        this.mFRC = new FontRenderContext(null, this.getMaskFormat() != 0, this.isLinearMetrics());
    }

    @Override
    protected ScalerContext.GlyphMetrics generateMetrics(Glyph glyph) {
        ScalerContext.GlyphMetrics metrics = new ScalerContext.GlyphMetrics(glyph.getMaskFormat());
        GlyphVector gv = this.mFont.createGlyphVector(this.mFRC, new int[]{glyph.getGlyphID()});
        Rectangle pixelBounds = gv.getPixelBounds(null, 0.0f, 0.0f);
        if (pixelBounds.isEmpty()) {
            Rectangle2D bounds = gv.getVisualBounds();
            metrics.mLeft = (float)bounds.getMinX();
            metrics.mTop = (float)bounds.getMinY();
            metrics.mRight = (float)bounds.getMaxX();
            metrics.mBottom = (float)bounds.getMaxY();
        } else {
            metrics.mLeft = (float)pixelBounds.getMinX();
            metrics.mTop = (float)pixelBounds.getMinY();
            metrics.mRight = (float)pixelBounds.getMaxX();
            metrics.mBottom = (float)pixelBounds.getMaxY();
        }
        return metrics;
    }

    @Override
    protected void generateImage(Glyph glyph, Object imageBase, long imageAddress) {
        BufferedImage bufferedImage = new BufferedImage(glyph.getWidth(), glyph.getHeight(), 10);
        Graphics2D g2d = bufferedImage.createGraphics();
        GlyphVector gv = this.mFont.createGlyphVector(this.mFRC, new int[]{glyph.getGlyphID()});
        g2d.setColor(Color.WHITE);
        g2d.setComposite(AlphaComposite.Src);
        g2d.drawGlyphVector(gv, -glyph.getLeft(), -glyph.getTop());
        byte[] data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        switch (glyph.getMaskFormat()) {
            case 0: {
                PixelUtils.packA8ToBW(data, Unsafe.ARRAY_BYTE_BASE_OFFSET, glyph.getWidth(), imageBase, imageAddress, glyph.getRowBytes(), glyph.getWidth(), glyph.getHeight());
                break;
            }
            case 1: {
                PixelUtils.copyImage(data, Unsafe.ARRAY_BYTE_BASE_OFFSET, glyph.getWidth(), imageBase, imageAddress, glyph.getRowBytes(), glyph.getRowBytes(), glyph.getHeight());
            }
        }
    }

    @Override
    protected boolean generatePath(Glyph glyph, Path dst) {
        GlyphVector gv = this.mFont.createGlyphVector(this.mFRC, new int[]{glyph.getGlyphID()});
        Shape outline = gv.getOutline();
        PathIterator pi = outline.getPathIterator(null);
        J2DUtils.toPath(pi, dst);
        return true;
    }
}

