/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.ColorInfo;
import icyllis.arc3d.core.ColorInt;
import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Pixmap;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Contract;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libc.LibCString;
import sun.misc.Unsafe;

public class PixelUtils {
    static final Unsafe UNSAFE;
    public static final boolean NATIVE_BIG_ENDIAN;
    private static final int[] lut5;
    private static final int[] lut6;
    public static final int kColorSpaceXformFlagUnpremul = 1;
    public static final int kColorSpaceXformFlagLinearize = 2;
    public static final int kColorSpaceXformFlagGamutTransform = 4;
    public static final int kColorSpaceXformFlagEncode = 8;
    public static final int kColorSpaceXformFlagPremul = 16;

    private static Unsafe getUnsafe() {
        try {
            Field field = MemoryUtil.class.getDeclaredField("UNSAFE");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError("No MemoryUtil.UNSAFE", e);
        }
    }

    public static void copyImage(long srcAddr, long srcRowBytes, long dstAddr, long dstRowBytes, long trimRowBytes, int rowCount) {
        PixelUtils.copyImage(srcAddr, srcRowBytes, dstAddr, dstRowBytes, trimRowBytes, rowCount, false);
    }

    public static void copyImage(long srcAddr, long srcRowBytes, long dstAddr, long dstRowBytes, long trimRowBytes, int rowCount, boolean flipY) {
        if (srcRowBytes < trimRowBytes || dstRowBytes < trimRowBytes || trimRowBytes < 0L) {
            throw new IllegalArgumentException();
        }
        if (srcRowBytes == trimRowBytes && dstRowBytes == trimRowBytes && !flipY) {
            LibCString.nmemcpy((long)dstAddr, (long)srcAddr, (long)(trimRowBytes * (long)rowCount));
        } else {
            if (flipY) {
                dstAddr += dstRowBytes * (long)(rowCount - 1);
                dstRowBytes = -dstRowBytes;
            }
            for (int i = 0; i < rowCount; ++i) {
                LibCString.nmemcpy((long)dstAddr, (long)srcAddr, (long)trimRowBytes);
                srcAddr += srcRowBytes;
                dstAddr += dstRowBytes;
            }
        }
    }

    public static void copyImage(Object srcBase, long srcAddr, long srcRowBytes, Object dstBase, long dstAddr, long dstRowBytes, long trimRowBytes, int rowCount) {
        PixelUtils.copyImage(srcBase, srcAddr, srcRowBytes, dstBase, dstAddr, dstRowBytes, trimRowBytes, rowCount, false);
    }

    public static void copyImage(Object srcBase, long srcAddr, long srcRowBytes, Object dstBase, long dstAddr, long dstRowBytes, long trimRowBytes, int rowCount, boolean flipY) {
        if (srcBase == null && dstBase == null) {
            PixelUtils.copyImage(srcAddr, srcRowBytes, dstAddr, dstRowBytes, trimRowBytes, rowCount, flipY);
        } else {
            if (srcRowBytes < trimRowBytes || dstRowBytes < trimRowBytes || trimRowBytes < 0L) {
                throw new IllegalArgumentException();
            }
            if (srcRowBytes == trimRowBytes && dstRowBytes == trimRowBytes && !flipY) {
                UNSAFE.copyMemory(srcBase, srcAddr, dstBase, dstAddr, trimRowBytes * (long)rowCount);
            } else {
                if (flipY) {
                    dstAddr += dstRowBytes * (long)(rowCount - 1);
                    dstRowBytes = -dstRowBytes;
                }
                for (int i = 0; i < rowCount; ++i) {
                    UNSAFE.copyMemory(srcBase, srcAddr, dstBase, dstAddr, trimRowBytes);
                    srcAddr += srcRowBytes;
                    dstAddr += dstRowBytes;
                }
            }
        }
    }

    public static void packA8ToBW(Object srcBase, long srcAddr, int srcRowBytes, Object dstBase, long dstAddr, int dstRowBytes, int width, int height) {
        int octets = width >> 3;
        int leftover = width & 7;
        assert (srcRowBytes >= width);
        assert (dstRowBytes >= width + 7 >> 3);
        for (int y = 0; y < height; ++y) {
            int j;
            long nextSrcAddr = srcAddr + (long)srcRowBytes;
            long nextDstAddr = dstAddr + (long)dstRowBytes;
            for (int i = 0; i < octets; ++i) {
                int bits = 0;
                for (j = 0; j < 8; ++j) {
                    bits <<= 1;
                    int v = (UNSAFE.getByte(srcBase, srcAddr + (long)j) & 0xFF) >> 7;
                    bits |= v;
                }
                UNSAFE.putByte(dstBase, dstAddr, (byte)bits);
                srcAddr += 8L;
                ++dstAddr;
            }
            if (leftover > 0) {
                int bits = 0;
                int shift = 7;
                j = 0;
                while (j < leftover) {
                    bits |= (UNSAFE.getByte(srcBase, srcAddr + (long)j) & 0xFF) >> 7 << shift;
                    ++j;
                    --shift;
                }
                UNSAFE.putByte(dstBase, dstAddr, (byte)bits);
            }
            srcAddr = nextSrcAddr;
            dstAddr = nextDstAddr;
        }
    }

    public static void unpackBWToA8(Object srcBase, long srcAddr, int srcRowBytes, Object dstBase, long dstAddr, int dstRowBytes, int width, int height) {
        assert (srcRowBytes >= width + 7 >> 3);
        assert (dstRowBytes >= width);
        for (int y = 0; y < height; ++y) {
            long nextSrcAddr = srcAddr + (long)srcRowBytes;
            long nextDstAddr = dstAddr + (long)dstRowBytes;
            int x = width;
            while (x > 0) {
                int mask = UNSAFE.getByte(srcBase, srcAddr) & 0xFF;
                for (int shift = 7; shift >= 0 && x != 0; --shift, --x) {
                    UNSAFE.putByte(dstBase, dstAddr, (mask & 1 << shift) != 0 ? (byte)-1 : 0);
                    ++dstAddr;
                }
                ++srcAddr;
            }
            srcAddr = nextSrcAddr;
            dstAddr = nextDstAddr;
        }
    }

    public static void setPixel16(Object base, long addr, short value, int count) {
        long wideValue = (long)value << 16 | (long)value;
        wideValue |= wideValue << 32;
        while (count >= 4) {
            UNSAFE.putLong(base, addr, wideValue);
            addr += 8L;
            count -= 4;
        }
        while (count-- != 0) {
            UNSAFE.putShort(base, addr, value);
            addr += 2L;
        }
    }

    public static void setPixel32(Object base, long addr, int value, int count) {
        long wideValue = (long)value << 32 | (long)value;
        while (count >= 2) {
            UNSAFE.putLong(base, addr, wideValue);
            addr += 8L;
            count -= 2;
        }
        if (count != 0) {
            assert (count == 1);
            UNSAFE.putInt(base, addr, value);
        }
    }

    public static void setPixel64(Object base, long addr, long value, int count) {
        for (int i = 0; i < count; ++i) {
            UNSAFE.putLong(base, addr, value);
            addr += 8L;
        }
    }

    public static int load_BGR_565(Object base, long addr) {
        short val = UNSAFE.getShort(base, addr);
        int b = lut5[val & 0x1F];
        int g = lut6[val >>> 5 & 0x3F];
        int r = lut5[val >>> 11 & 0x1F];
        return b | g << 8 | r << 16 | 0xFF000000;
    }

    public static int load_RGBA_1010102(Object base, long addr) {
        int val = UNSAFE.getInt(base, addr);
        int r = (int)((float)(val & 0x3FF) * 0.24926686f + 0.5f);
        int g = (int)((float)(val >>> 10 & 0x3FF) * 0.24926686f + 0.5f);
        int b = (int)((float)(val >>> 20 & 0x3FF) * 0.24926686f + 0.5f);
        int a = (int)((float)(val >>> 30) * 85.0f + 0.5f);
        return b | g << 8 | r << 16 | a << 24;
    }

    public static int load_BGRA_1010102(Object base, long addr) {
        int val = UNSAFE.getInt(base, addr);
        int r = (int)((float)(val >>> 20 & 0x3FF) * 0.24926686f + 0.5f);
        int g = (int)((float)(val >>> 10 & 0x3FF) * 0.24926686f + 0.5f);
        int b = (int)((float)(val & 0x3FF) * 0.24926686f + 0.5f);
        int a = (int)((float)(val >>> 30) * 85.0f + 0.5f);
        return b | g << 8 | r << 16 | a << 24;
    }

    public static int load_R_8(Object base, long addr) {
        byte val = UNSAFE.getByte(base, addr);
        return val << 16 | 0xFF000000;
    }

    public static int load_RG_88(Object base, long addr) {
        short val = UNSAFE.getShort(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            return val << 8 | 0xFF000000;
        }
        return val & 0xFF00 | (val & 0xFF) << 16 | 0xFF000000;
    }

    public static int load_RGB_888(Object base, long addr) {
        int r = UNSAFE.getByte(base, addr + 0L) & 0xFF;
        int g = UNSAFE.getByte(base, addr + 1L) & 0xFF;
        int b = UNSAFE.getByte(base, addr + 2L) & 0xFF;
        return b | g << 8 | r << 16 | 0xFF000000;
    }

    public static int load_RGBX_8888(Object base, long addr) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            return val >>> 8 | 0xFF000000;
        }
        return val & 0xFF00 | (val & 0xFF) << 16 | val >>> 16 & 0xFF | 0xFF000000;
    }

    public static int load_RGBA_8888(Object base, long addr) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            return val >>> 8 | val << 24;
        }
        return val & 0xFF00FF00 | (val & 0xFF) << 16 | val >>> 16 & 0xFF;
    }

    public static int load_BGRA_8888(Object base, long addr) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            return Integer.reverseBytes(val);
        }
        return val;
    }

    public static int load_ABGR_8888(Object base, long addr) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            return val & 0xFF00FF00 | (val & 0xFF) << 16 | val >>> 16 & 0xFF;
        }
        return val >>> 8 | (val & 0xFF) << 24;
    }

    public static int load_ARGB_8888(Object base, long addr) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            return val;
        }
        return Integer.reverseBytes(val);
    }

    public static int load_GRAY_8(Object base, long addr) {
        int val = UNSAFE.getByte(base, addr) & 0xFF;
        return val | val << 8 | val << 16 | 0xFF000000;
    }

    public static int load_GRAY_ALPHA_88(Object base, long addr) {
        short val = UNSAFE.getShort(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            int lum = val & 0xFF00;
            return lum << 8 | lum | lum >>> 8 | (val & 0xFF) << 24;
        }
        int lum = val & 0xFF;
        return val << 16 | lum << 8 | lum;
    }

    public static int load_ALPHA_8(Object base, long addr) {
        byte val = UNSAFE.getByte(base, addr);
        return val << 24;
    }

    public static int load_R_16(Object base, long addr) {
        int val = (int)((float)(UNSAFE.getShort(base, addr) & 0xFFFF) * 0.0038910506f + 0.5f);
        return val << 16 | 0xFF000000;
    }

    public static int load_RG_1616(Object base, long addr) {
        int g;
        int r;
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            r = (int)((float)(val >>> 16) * 0.0038910506f + 0.5f);
            g = (int)((float)(val & 0xFFFF) * 0.0038910506f + 0.5f);
        } else {
            r = (int)((float)(val & 0xFFFF) * 0.0038910506f + 0.5f);
            g = (int)((float)(val >>> 16) * 0.0038910506f + 0.5f);
        }
        return g << 8 | r << 16 | 0xFF000000;
    }

    public static int load_RGBA_16161616(Object base, long addr) {
        int a;
        int b;
        int g;
        int r;
        long val = UNSAFE.getLong(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            r = (int)((float)(val >>> 48) * 0.0038910506f + 0.5f);
            g = (int)((float)(val >>> 32 & 0xFFFFL) * 0.0038910506f + 0.5f);
            b = (int)((float)(val >>> 16 & 0xFFFFL) * 0.0038910506f + 0.5f);
            a = (int)((float)(val & 0xFFFFL) * 0.0038910506f + 0.5f);
        } else {
            r = (int)((float)(val & 0xFFFFL) * 0.0038910506f + 0.5f);
            g = (int)((float)(val >>> 16 & 0xFFFFL) * 0.0038910506f + 0.5f);
            b = (int)((float)(val >>> 32 & 0xFFFFL) * 0.0038910506f + 0.5f);
            a = (int)((float)(val >>> 48) * 0.0038910506f + 0.5f);
        }
        return b | g << 8 | r << 16 | a << 24;
    }

    public static int load_ALPHA_16(Object base, long addr) {
        int val = (int)((float)(UNSAFE.getShort(base, addr) & 0xFFFF) * 0.0038910506f + 0.5f);
        return val << 24;
    }

    public static int load_R_F16(Object base, long addr) {
        int val = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr)) * 255.0f + 0.5f);
        return val << 16 | 0xFF000000;
    }

    public static int load_RG_F16(Object base, long addr) {
        int r = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 0L)) * 255.0f + 0.5f);
        int g = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 2L)) * 255.0f + 0.5f);
        return g << 8 | r << 16 | 0xFF000000;
    }

    public static int load_RGBA_F16(Object base, long addr) {
        int r = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 0L)) * 255.0f + 0.5f);
        int g = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 2L)) * 255.0f + 0.5f);
        int b = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 4L)) * 255.0f + 0.5f);
        int a = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 6L)) * 255.0f + 0.5f);
        return b | g << 8 | r << 16 | a << 24;
    }

    public static int load_ALPHA_F16(Object base, long addr) {
        int val = (int)(MathUtil.halfToFloat(UNSAFE.getShort(base, addr)) * 255.0f + 0.5f);
        return val << 24;
    }

    public static int load_RGBA_F32(Object base, long addr) {
        int r = (int)(UNSAFE.getFloat(base, addr + 0L) * 255.0f + 0.5f);
        int g = (int)(UNSAFE.getFloat(base, addr + 4L) * 255.0f + 0.5f);
        int b = (int)(UNSAFE.getFloat(base, addr + 8L) * 255.0f + 0.5f);
        int a = (int)(UNSAFE.getFloat(base, addr + 12L) * 255.0f + 0.5f);
        return b | g << 8 | r << 16 | a << 24;
    }

    @Nonnull
    @Contract(pure=true)
    public static PixelLoad load(int ct) {
        return switch (ct) {
            case 1 -> PixelUtils::load_BGR_565;
            case 9 -> PixelUtils::load_RGBA_1010102;
            case 10 -> PixelUtils::load_BGRA_1010102;
            case 2 -> PixelUtils::load_R_8;
            case 3 -> PixelUtils::load_RG_88;
            case 4 -> PixelUtils::load_RGB_888;
            case 5 -> PixelUtils::load_RGBX_8888;
            case 6 -> PixelUtils::load_RGBA_8888;
            case 7 -> PixelUtils::load_BGRA_8888;
            case 24 -> PixelUtils::load_ABGR_8888;
            case 25 -> PixelUtils::load_ARGB_8888;
            case 22 -> PixelUtils::load_GRAY_8;
            case 23 -> PixelUtils::load_GRAY_ALPHA_88;
            case 19 -> PixelUtils::load_ALPHA_8;
            case 11 -> PixelUtils::load_R_16;
            case 13 -> PixelUtils::load_RG_1616;
            case 15 -> PixelUtils::load_RGBA_16161616;
            case 20 -> PixelUtils::load_ALPHA_16;
            case 12 -> PixelUtils::load_R_F16;
            case 14 -> PixelUtils::load_RG_F16;
            case 16 -> PixelUtils::load_RGBA_F16;
            case 21 -> PixelUtils::load_ALPHA_F16;
            case 18 -> PixelUtils::load_RGBA_F32;
            default -> throw new AssertionError(ct);
        };
    }

    public static void store_BGR_565(Object base, long addr, int src) {
        int r = src >>> 16 & 0xFF;
        int g = src >>> 8 & 0xFF;
        int b = src & 0xFF;
        r = (r * 9 + 36) / 74;
        g = (g * 21 + 42) / 85;
        b = (b * 9 + 36) / 74;
        UNSAFE.putShort(base, addr, (short)(b | g << 5 | r << 11));
    }

    public static void store_R_8(Object base, long addr, int src) {
        UNSAFE.putByte(base, addr, (byte)(src >>> 16));
    }

    public static void store_RG_88(Object base, long addr, int src) {
        if (NATIVE_BIG_ENDIAN) {
            UNSAFE.putShort(base, addr, (short)(src >>> 8));
        } else {
            UNSAFE.putShort(base, addr, (short)(src >>> 16 & 0xFF | src & 0xFF00));
        }
    }

    public static void store_RGB_888(Object base, long addr, int src) {
        UNSAFE.putByte(base, addr + 0L, (byte)(src >>> 16));
        UNSAFE.putByte(base, addr + 1L, (byte)(src >>> 8));
        UNSAFE.putByte(base, addr + 2L, (byte)src);
    }

    public static void store_RGBX_8888(Object base, long addr, int src) {
        if (NATIVE_BIG_ENDIAN) {
            UNSAFE.putInt(base, addr, src << 8 | 0xFF);
        } else {
            UNSAFE.putInt(base, addr, src & 0xFF00 | (src & 0xFF) << 16 | src >>> 16 & 0xFF | 0xFF000000);
        }
    }

    public static void store_RGBA_8888(Object base, long addr, int src) {
        if (NATIVE_BIG_ENDIAN) {
            UNSAFE.putInt(base, addr, src << 8 | src >>> 24);
        } else {
            UNSAFE.putInt(base, addr, src & 0xFF00FF00 | (src & 0xFF) << 16 | src >>> 16 & 0xFF);
        }
    }

    public static void store_BGRA_8888(Object base, long addr, int src) {
        if (NATIVE_BIG_ENDIAN) {
            UNSAFE.putInt(base, addr, Integer.reverseBytes(src));
        } else {
            UNSAFE.putInt(base, addr, src);
        }
    }

    public static void store_ABGR_8888(Object base, long addr, int src) {
        if (NATIVE_BIG_ENDIAN) {
            UNSAFE.putInt(base, addr, src & 0xFF00FF00 | (src & 0xFF) << 16 | src >>> 16 & 0xFF);
        } else {
            UNSAFE.putInt(base, addr, src << 8 | src >>> 24);
        }
    }

    public static void store_ARGB_8888(Object base, long addr, int src) {
        if (NATIVE_BIG_ENDIAN) {
            UNSAFE.putInt(base, addr, src);
        } else {
            UNSAFE.putInt(base, addr, Integer.reverseBytes(src));
        }
    }

    public static void store_GRAY_8(Object base, long addr, int src) {
        float y = (float)(src >>> 16 & 0xFF) * 0.2126f + (float)(src >>> 8 & 0xFF) * 0.7152f + (float)(src & 0xFF) * 0.0722f;
        UNSAFE.putByte(base, addr, (byte)(y + 0.5f));
    }

    public static void store_GRAY_ALPHA_88(Object base, long addr, int src) {
        float y = (float)(src >>> 16 & 0xFF) * 0.2126f + (float)(src >>> 8 & 0xFF) * 0.7152f + (float)(src & 0xFF) * 0.0722f;
        if (NATIVE_BIG_ENDIAN) {
            UNSAFE.putShort(base, addr, (short)((int)(y + 0.5f) << 8 | src >>> 24));
        } else {
            UNSAFE.putShort(base, addr, (short)((int)(y + 0.5f) | src >>> 16 & 0xFF00));
        }
    }

    public static void store_ALPHA_8(Object base, long addr, int src) {
        UNSAFE.putByte(base, addr, (byte)(src >>> 24));
    }

    @Nonnull
    @Contract(pure=true)
    public static PixelStore store(int ct) {
        return switch (ct) {
            case 1 -> PixelUtils::store_BGR_565;
            case 2 -> PixelUtils::store_R_8;
            case 3 -> PixelUtils::store_RG_88;
            case 4 -> PixelUtils::store_RGB_888;
            case 5 -> PixelUtils::store_RGBX_8888;
            case 6 -> PixelUtils::store_RGBA_8888;
            case 7 -> PixelUtils::store_BGRA_8888;
            case 24 -> PixelUtils::store_ABGR_8888;
            case 25 -> PixelUtils::store_ARGB_8888;
            case 22 -> PixelUtils::store_GRAY_8;
            case 23 -> PixelUtils::store_GRAY_ALPHA_88;
            case 19 -> PixelUtils::store_ALPHA_8;
            default -> throw new AssertionError(ct);
        };
    }

    public static void load_BGR_565(Object base, long addr, float[] dst) {
        short val = UNSAFE.getShort(base, addr);
        dst[0] = (float)(val & 0xF800) * 1.5751008E-5f;
        dst[1] = (float)(val & 0x7E0) * 4.960318E-4f;
        dst[2] = (float)(val & 0x1F) * 0.032258064f;
        dst[3] = 1.0f;
    }

    public static void load_RGBA_1010102(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        dst[0] = (float)(val & 0x3FF) * 9.775171E-4f;
        dst[1] = (float)(val >>> 10 & 0x3FF) * 9.775171E-4f;
        dst[2] = (float)(val >>> 20 & 0x3FF) * 9.775171E-4f;
        dst[3] = (float)(val >>> 30) * 0.33333334f;
    }

    public static void load_BGRA_1010102(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        dst[0] = (float)(val >>> 20 & 0x3FF) * 9.775171E-4f;
        dst[1] = (float)(val >>> 10 & 0x3FF) * 9.775171E-4f;
        dst[2] = (float)(val & 0x3FF) * 9.775171E-4f;
        dst[3] = (float)(val >>> 30) * 0.33333334f;
    }

    public static void load_R_8(Object base, long addr, float[] dst) {
        dst[0] = (float)(UNSAFE.getByte(base, addr) & 0xFF) * 0.003921569f;
        dst[2] = 0.0f;
        dst[1] = 0.0f;
        dst[3] = 1.0f;
    }

    public static void load_RG_88(Object base, long addr, float[] dst) {
        short val = UNSAFE.getShort(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[1] = (float)(val & 0xFF) * 0.003921569f;
        } else {
            dst[0] = (float)(val & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
        }
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }

    public static void load_RGB_888(Object base, long addr, float[] dst) {
        for (int i = 0; i < 3; ++i) {
            dst[i] = (float)(UNSAFE.getByte(base, addr + (long)i) & 0xFF) * 0.003921569f;
        }
        dst[3] = 1.0f;
    }

    public static void load_RGBX_8888(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val >>> 24) * 0.003921569f;
            dst[1] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
        } else {
            dst[0] = (float)(val & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
        }
        dst[3] = 1.0f;
    }

    public static void load_RGBA_8888(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val >>> 24) * 0.003921569f;
            dst[1] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[3] = (float)(val & 0xFF) * 0.003921569f;
        } else {
            dst[0] = (float)(val & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[3] = (float)(val >>> 24) * 0.003921569f;
        }
    }

    public static void load_BGRA_8888(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 24) * 0.003921569f;
            dst[3] = (float)(val & 0xFF) * 0.003921569f;
        } else {
            dst[0] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val & 0xFF) * 0.003921569f;
            dst[3] = (float)(val >>> 24) * 0.003921569f;
        }
    }

    public static void load_ABGR_8888(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[3] = (float)(val >>> 24) * 0.003921569f;
        } else {
            dst[0] = (float)(val >>> 24) * 0.003921569f;
            dst[1] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[3] = (float)(val & 0xFF) * 0.003921569f;
        }
    }

    public static void load_ARGB_8888(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val & 0xFF) * 0.003921569f;
            dst[3] = (float)(val >>> 24) * 0.003921569f;
        } else {
            dst[0] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
            dst[1] = (float)(val >>> 16 & 0xFF) * 0.003921569f;
            dst[2] = (float)(val >>> 24) * 0.003921569f;
            dst[3] = (float)(val & 0xFF) * 0.003921569f;
        }
    }

    public static void load_GRAY_8(Object base, long addr, float[] dst) {
        float y;
        dst[1] = dst[2] = (y = (float)(UNSAFE.getByte(base, addr) & 0xFF) * 0.003921569f);
        dst[0] = dst[2];
        dst[3] = 1.0f;
    }

    public static void load_GRAY_ALPHA_88(Object base, long addr, float[] dst) {
        short val = UNSAFE.getShort(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            float y;
            dst[1] = dst[2] = (y = (float)(val >>> 8 & 0xFF) * 0.003921569f);
            dst[0] = dst[2];
            dst[3] = (float)(val & 0xFF) * 0.003921569f;
        } else {
            float y;
            dst[1] = dst[2] = (y = (float)(val & 0xFF) * 0.003921569f);
            dst[0] = dst[2];
            dst[3] = (float)(val >>> 8 & 0xFF) * 0.003921569f;
        }
    }

    public static void load_ALPHA_8(Object base, long addr, float[] dst) {
        dst[2] = 0.0f;
        dst[1] = 0.0f;
        dst[0] = 0.0f;
        dst[3] = (float)(UNSAFE.getByte(base, addr) & 0xFF) * 0.003921569f;
    }

    public static void load_R_16(Object base, long addr, float[] dst) {
        dst[0] = (float)(UNSAFE.getShort(base, addr) & 0xFFFF) * 1.5259022E-5f;
        dst[2] = 0.0f;
        dst[1] = 0.0f;
        dst[3] = 1.0f;
    }

    public static void load_RG_1616(Object base, long addr, float[] dst) {
        int val = UNSAFE.getInt(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val >>> 16) * 1.5259022E-5f;
            dst[1] = (float)(val & 0xFFFF) * 1.5259022E-5f;
        } else {
            dst[0] = (float)(val & 0xFFFF) * 1.5259022E-5f;
            dst[1] = (float)(val >>> 16) * 1.5259022E-5f;
        }
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }

    public static void load_RGBA_16161616(Object base, long addr, float[] dst) {
        long val = UNSAFE.getLong(base, addr);
        if (NATIVE_BIG_ENDIAN) {
            dst[0] = (float)(val >>> 48) * 1.5259022E-5f;
            dst[1] = (float)(val >>> 32 & 0xFFFFL) * 1.5259022E-5f;
            dst[2] = (float)(val >>> 16 & 0xFFFFL) * 1.5259022E-5f;
            dst[3] = (float)(val & 0xFFFFL) * 1.5259022E-5f;
        } else {
            dst[0] = (float)(val & 0xFFFFL) * 1.5259022E-5f;
            dst[1] = (float)(val >>> 16 & 0xFFFFL) * 1.5259022E-5f;
            dst[2] = (float)(val >>> 32 & 0xFFFFL) * 1.5259022E-5f;
            dst[3] = (float)(val >>> 48) * 1.5259022E-5f;
        }
    }

    public static void load_ALPHA_16(Object base, long addr, float[] dst) {
        dst[2] = 0.0f;
        dst[1] = 0.0f;
        dst[0] = 0.0f;
        dst[3] = (float)(UNSAFE.getShort(base, addr) & 0xFFFF) * 1.5259022E-5f;
    }

    public static void load_R_F16(Object base, long addr, float[] dst) {
        dst[0] = MathUtil.halfToFloat(UNSAFE.getShort(base, addr));
        dst[2] = 0.0f;
        dst[1] = 0.0f;
        dst[3] = 1.0f;
    }

    public static void load_RG_F16(Object base, long addr, float[] dst) {
        dst[0] = MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 0L));
        dst[1] = MathUtil.halfToFloat(UNSAFE.getShort(base, addr + 2L));
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }

    public static void load_RGBA_F16(Object base, long addr, float[] dst) {
        for (int i = 0; i < 4; ++i) {
            dst[i] = MathUtil.halfToFloat(UNSAFE.getShort(base, addr + (long)(i << 1)));
        }
    }

    public static void load_ALPHA_F16(Object base, long addr, float[] dst) {
        dst[2] = 0.0f;
        dst[1] = 0.0f;
        dst[0] = 0.0f;
        dst[3] = MathUtil.halfToFloat(UNSAFE.getShort(base, addr));
    }

    public static void load_RGBA_F32(Object base, long addr, float[] dst) {
        dst[0] = UNSAFE.getFloat(base, addr + 0L);
        dst[1] = UNSAFE.getFloat(base, addr + 4L);
        dst[2] = UNSAFE.getFloat(base, addr + 8L);
        dst[3] = UNSAFE.getFloat(base, addr + 12L);
    }

    @Nonnull
    @Contract(pure=true)
    public static PixelOp loadOp(int ct) {
        return switch (ct) {
            case 1 -> PixelUtils::load_BGR_565;
            case 9 -> PixelUtils::load_RGBA_1010102;
            case 10 -> PixelUtils::load_BGRA_1010102;
            case 2 -> PixelUtils::load_R_8;
            case 3 -> PixelUtils::load_RG_88;
            case 4 -> PixelUtils::load_RGB_888;
            case 5 -> PixelUtils::load_RGBX_8888;
            case 6 -> PixelUtils::load_RGBA_8888;
            case 7 -> PixelUtils::load_BGRA_8888;
            case 24 -> PixelUtils::load_ABGR_8888;
            case 25 -> PixelUtils::load_ARGB_8888;
            case 22 -> PixelUtils::load_GRAY_8;
            case 23 -> PixelUtils::load_GRAY_ALPHA_88;
            case 19 -> PixelUtils::load_ALPHA_8;
            case 11 -> PixelUtils::load_R_16;
            case 13 -> PixelUtils::load_RG_1616;
            case 15 -> PixelUtils::load_RGBA_16161616;
            case 20 -> PixelUtils::load_ALPHA_16;
            case 12 -> PixelUtils::load_R_F16;
            case 14 -> PixelUtils::load_RG_F16;
            case 16 -> PixelUtils::load_RGBA_F16;
            case 21 -> PixelUtils::load_ALPHA_F16;
            case 18 -> PixelUtils::load_RGBA_F32;
            default -> throw new AssertionError(ct);
        };
    }

    public static void store_BGR_565(Object base, long addr, float[] src) {
        int val = (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 31.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 63.0f + 0.5f) << 5 | (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 31.0f + 0.5f) << 11;
        UNSAFE.putShort(base, addr, (short)val);
    }

    public static void store_RGBA_1010102(Object base, long addr, float[] src) {
        int val = (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 1023.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 1023.0f + 0.5f) << 10 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 1023.0f + 0.5f) << 20 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 3.0f + 0.5f) << 30;
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_BGRA_1010102(Object base, long addr, float[] src) {
        int val = (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 1023.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 1023.0f + 0.5f) << 10 | (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 1023.0f + 0.5f) << 20 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 3.0f + 0.5f) << 30;
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_R_8(Object base, long addr, float[] src) {
        byte val = (byte)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f);
        UNSAFE.putByte(base, addr, val);
    }

    public static void store_RG_88(Object base, long addr, float[] src) {
        int val = NATIVE_BIG_ENDIAN ? (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) : (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 8;
        UNSAFE.putShort(base, addr, (short)val);
    }

    public static void store_RGB_888(Object base, long addr, float[] src) {
        for (int i = 0; i < 3; ++i) {
            UNSAFE.putByte(base, addr + (long)i, (byte)(MathUtil.clamp(src[i], 0.0f, 1.0f) * 255.0f + 0.5f));
        }
    }

    public static void store_RGBX_8888(Object base, long addr, float[] src) {
        int val = NATIVE_BIG_ENDIAN ? (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 24 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | 0xFF : (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | 0xFF000000;
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_RGBA_8888(Object base, long addr, float[] src) {
        int val = NATIVE_BIG_ENDIAN ? (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 24 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) : (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) << 24;
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_BGRA_8888(Object base, long addr, float[] src) {
        int val = NATIVE_BIG_ENDIAN ? (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 24 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) : (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) << 24;
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_ABGR_8888(Object base, long addr, float[] src) {
        int val = NATIVE_BIG_ENDIAN ? (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) << 24 : (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 24 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f);
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_ARGB_8888(Object base, long addr, float[] src) {
        int val = NATIVE_BIG_ENDIAN ? (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) << 24 : (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 255.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 255.0f + 0.5f) << 24 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f);
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_GRAY_8(Object base, long addr, float[] src) {
        float y = MathUtil.clamp(src[0], 0.0f, 1.0f) * 0.2126f + MathUtil.clamp(src[1], 0.0f, 1.0f) * 0.7152f + MathUtil.clamp(src[2], 0.0f, 1.0f) * 0.0722f;
        UNSAFE.putByte(base, addr, (byte)(y * 255.0f + 0.5f));
    }

    public static void store_GRAY_ALPHA_88(Object base, long addr, float[] src) {
        float y = MathUtil.clamp(src[0], 0.0f, 1.0f) * 0.2126f + MathUtil.clamp(src[1], 0.0f, 1.0f) * 0.7152f + MathUtil.clamp(src[2], 0.0f, 1.0f) * 0.0722f;
        int val = NATIVE_BIG_ENDIAN ? (int)(y * 255.0f + 0.5f) << 8 | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) : (int)(y * 255.0f + 0.5f) | (int)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f) << 8;
        UNSAFE.putShort(base, addr, (short)val);
    }

    public static void store_ALPHA_8(Object base, long addr, float[] src) {
        byte val = (byte)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 255.0f + 0.5f);
        UNSAFE.putByte(base, addr, val);
    }

    public static void store_R_16(Object base, long addr, float[] src) {
        short val = (short)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 65535.0f + 0.5f);
        UNSAFE.putShort(base, addr, val);
    }

    public static void store_RG_1616(Object base, long addr, float[] src) {
        int val = NATIVE_BIG_ENDIAN ? (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 65535.0f + 0.5f) << 16 | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 65535.0f + 0.5f) : (int)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 65535.0f + 0.5f) | (int)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 65535.0f + 0.5f) << 16;
        UNSAFE.putInt(base, addr, val);
    }

    public static void store_RGBA_16161616(Object base, long addr, float[] src) {
        long val = NATIVE_BIG_ENDIAN ? (long)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 65535.0f + 0.5f) << 48 | (long)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 65535.0f + 0.5f) << 32 | (long)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 65535.0f + 0.5f) << 16 | (long)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 65535.0f + 0.5f) : (long)(MathUtil.clamp(src[0], 0.0f, 1.0f) * 65535.0f + 0.5f) | (long)(MathUtil.clamp(src[1], 0.0f, 1.0f) * 65535.0f + 0.5f) << 16 | (long)(MathUtil.clamp(src[2], 0.0f, 1.0f) * 65535.0f + 0.5f) << 32 | (long)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 65535.0f + 0.5f) << 48;
        UNSAFE.putLong(base, addr, val);
    }

    public static void store_ALPHA_16(Object base, long addr, float[] src) {
        short val = (short)(MathUtil.clamp(src[3], 0.0f, 1.0f) * 65535.0f + 0.5f);
        UNSAFE.putShort(base, addr, val);
    }

    public static void store_R_F16(Object base, long addr, float[] src) {
        UNSAFE.putShort(base, addr, MathUtil.floatToHalf(src[0]));
    }

    public static void store_RG_F16(Object base, long addr, float[] src) {
        UNSAFE.putShort(base, addr + 0L, MathUtil.floatToHalf(src[0]));
        UNSAFE.putShort(base, addr + 2L, MathUtil.floatToHalf(src[1]));
    }

    public static void store_RGBA_F16(Object base, long addr, float[] src) {
        for (int i = 0; i < 4; ++i) {
            UNSAFE.putShort(base, addr + (long)(i << 1), MathUtil.floatToHalf(src[i]));
        }
    }

    public static void store_ALPHA_F16(Object base, long addr, float[] src) {
        UNSAFE.putShort(base, addr, MathUtil.floatToHalf(src[3]));
    }

    public static void store_RGBA_F32(Object base, long addr, float[] src) {
        UNSAFE.putFloat(base, addr + 0L, src[0]);
        UNSAFE.putFloat(base, addr + 4L, src[1]);
        UNSAFE.putFloat(base, addr + 8L, src[2]);
        UNSAFE.putFloat(base, addr + 12L, src[3]);
    }

    @Nonnull
    @Contract(pure=true)
    public static PixelOp storeOp(int ct) {
        return switch (ct) {
            case 1 -> PixelUtils::store_BGR_565;
            case 9 -> PixelUtils::store_RGBA_1010102;
            case 10 -> PixelUtils::store_BGRA_1010102;
            case 2 -> PixelUtils::store_R_8;
            case 3 -> PixelUtils::store_RG_88;
            case 4 -> PixelUtils::store_RGB_888;
            case 5 -> PixelUtils::store_RGBX_8888;
            case 6 -> PixelUtils::store_RGBA_8888;
            case 7 -> PixelUtils::store_BGRA_8888;
            case 24 -> PixelUtils::store_ABGR_8888;
            case 25 -> PixelUtils::store_ARGB_8888;
            case 22 -> PixelUtils::store_GRAY_8;
            case 23 -> PixelUtils::store_GRAY_ALPHA_88;
            case 19 -> PixelUtils::store_ALPHA_8;
            case 11 -> PixelUtils::store_R_16;
            case 13 -> PixelUtils::store_RG_1616;
            case 15 -> PixelUtils::store_RGBA_16161616;
            case 20 -> PixelUtils::store_ALPHA_16;
            case 12 -> PixelUtils::store_R_F16;
            case 14 -> PixelUtils::store_RG_F16;
            case 16 -> PixelUtils::store_RGBA_F16;
            case 21 -> PixelUtils::store_ALPHA_F16;
            case 18 -> PixelUtils::store_RGBA_F32;
            default -> throw new AssertionError(ct);
        };
    }

    public static boolean convertPixels(@Nonnull Pixmap src, @Nonnull Pixmap dst) {
        return PixelUtils.convertPixels(src.getInfo(), src.getBase(), src.getAddress(), src.getRowBytes(), dst.getInfo(), dst.getBase(), dst.getAddress(), dst.getRowBytes(), false);
    }

    public static boolean convertPixels(@Nonnull Pixmap src, @Nonnull Pixmap dst, boolean flipY) {
        return PixelUtils.convertPixels(src.getInfo(), src.getBase(), src.getAddress(), src.getRowBytes(), dst.getInfo(), dst.getBase(), dst.getAddress(), dst.getRowBytes(), flipY);
    }

    public static boolean convertPixels(@Nonnull ImageInfo srcInfo, Object srcBase, long srcAddr, long srcRowBytes, @Nonnull ImageInfo dstInfo, Object dstBase, long dstAddr, long dstRowBytes) {
        return PixelUtils.convertPixels(srcInfo, srcBase, srcAddr, srcRowBytes, dstInfo, dstBase, dstAddr, dstRowBytes, false);
    }

    public static boolean convertPixels(@Nonnull ImageInfo srcInfo, Object srcBase, long srcAddr, long srcRowBytes, @Nonnull ImageInfo dstInfo, Object dstBase, long dstAddr, long dstRowBytes, boolean flipY) {
        if (!srcInfo.isValid() || !dstInfo.isValid()) {
            return false;
        }
        if (srcInfo.width() != dstInfo.width() || srcInfo.height() != dstInfo.height()) {
            return false;
        }
        if (srcBase == null && srcAddr == 0L || dstBase == null && dstAddr == 0L) {
            return false;
        }
        if (srcRowBytes < (long)srcInfo.minRowBytes() || dstRowBytes < (long)dstInfo.minRowBytes()) {
            return false;
        }
        int srcBpp = srcInfo.bytesPerPixel();
        int dstBpp = dstInfo.bytesPerPixel();
        if (srcRowBytes % (long)srcBpp != 0L || dstRowBytes % (long)dstBpp != 0L) {
            return false;
        }
        ColorSpace srcCS = srcInfo.colorSpace();
        int srcCT = srcInfo.colorType();
        int srcAT = srcInfo.alphaType();
        ColorSpace dstCS = dstInfo.colorSpace();
        int dstCT = dstInfo.colorType();
        int dstAT = dstInfo.alphaType();
        if (dstAT == 1) {
            dstAT = srcAT;
        }
        if (srcCS == null) {
            srcCS = ColorSpace.get(ColorSpace.Named.SRGB);
        }
        if (dstCS == null) {
            dstCS = srcCS;
        }
        boolean csXform = !srcCS.equals(dstCS);
        int flags = 0;
        if (csXform || srcAT != dstAT) {
            if (srcAT == 2) {
                flags |= 1;
            }
            if (srcAT != 1 && dstAT == 2) {
                flags |= 0x10;
            }
        }
        if (ColorInfo.colorTypeIsAlphaOnly(srcCT) && ColorInfo.colorTypeIsAlphaOnly(dstCT)) {
            csXform = false;
            flags = 0;
        }
        int width = srcInfo.width();
        int height = srcInfo.height();
        if (srcCT == dstCT && !csXform && flags == 0) {
            PixelUtils.copyImage(srcBase, srcAddr, srcRowBytes, dstBase, dstAddr, dstRowBytes, srcInfo.minRowBytes(), height, flipY);
            return true;
        }
        if (flipY) {
            dstAddr += dstRowBytes * (long)(height - 1);
            dstRowBytes = -dstRowBytes;
        }
        if (flags == 0 && !csXform && ColorInfo.maxBitsPerChannel(srcCT) <= 8 && ColorInfo.maxBitsPerChannel(dstCT) <= 8) {
            PixelLoad load = PixelUtils.load(srcCT);
            PixelStore store = PixelUtils.store(dstCT);
            for (int i = 0; i < height; ++i) {
                long nextSrcAddr = srcAddr + srcRowBytes;
                long nextDstAddr = dstAddr + dstRowBytes;
                for (int j = 0; j < width; ++j) {
                    store.store(dstBase, dstAddr, load.load(srcBase, srcAddr));
                    srcAddr += (long)srcBpp;
                    dstAddr += (long)dstBpp;
                }
                srcAddr = nextSrcAddr;
                dstAddr = nextDstAddr;
            }
        } else {
            PixelOp load = PixelUtils.loadOp(srcCT);
            boolean unpremul = (flags & 1) != 0;
            ColorSpace.Connector connector = csXform ? ColorSpace.connect(srcCS, dstCS) : null;
            boolean premul = (flags & 0x10) != 0;
            PixelOp store = PixelUtils.storeOp(dstCT);
            float[] col = new float[4];
            for (int i = 0; i < height; ++i) {
                long nextSrcAddr = srcAddr + srcRowBytes;
                long nextDstAddr = dstAddr + dstRowBytes;
                for (int j = 0; j < width; ++j) {
                    float scale;
                    load.op(srcBase, srcAddr, col);
                    if (unpremul) {
                        scale = 1.0f / col[3];
                        if (!Float.isFinite(scale)) {
                            scale = 0.0f;
                        }
                        col[0] = col[0] * scale;
                        col[1] = col[1] * scale;
                        col[2] = col[2] * scale;
                    }
                    if (connector != null) {
                        connector.transform(col);
                    }
                    if (premul) {
                        scale = col[3];
                        col[0] = col[0] * scale;
                        col[1] = col[1] * scale;
                        col[2] = col[2] * scale;
                    }
                    store.op(dstBase, dstAddr, col);
                    srcAddr += (long)srcBpp;
                    dstAddr += (long)dstBpp;
                }
                srcAddr = nextSrcAddr;
                dstAddr = nextDstAddr;
            }
        }
        return true;
    }

    static {
        int i;
        UNSAFE = PixelUtils.getUnsafe();
        NATIVE_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        int[] lu5 = new int[32];
        int[] lu6 = new int[64];
        for (i = 0; i < 32; ++i) {
            lu5[i] = (int)((float)i * 8.225806f + 0.5f);
        }
        for (i = 0; i < 64; ++i) {
            lu6[i] = (int)((float)i * 4.047619f + 0.5f);
        }
        lut5 = lu5;
        lut6 = lu6;
    }

    @FunctionalInterface
    public static interface PixelLoad {
        @ColorInt
        public int load(Object var1, long var2);
    }

    @FunctionalInterface
    public static interface PixelStore {
        public void store(Object var1, long var2, @ColorInt int var4);
    }

    @FunctionalInterface
    public static interface PixelOp {
        public void op(Object var1, long var2, float[] var4);
    }
}

