/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.PathConsumer;
import icyllis.arc3d.core.PathIterable;
import icyllis.arc3d.core.PathIterator;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.RefCounted;
import icyllis.arc3d.core.SharedPtr;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

public class Path
implements PathIterable,
PathConsumer {
    public static final int FILL_NON_ZERO = 0;
    public static final int FILL_EVEN_ODD = 1;
    public static final byte VERB_MOVE = 0;
    public static final byte VERB_LINE = 1;
    public static final byte VERB_QUAD = 2;
    public static final byte VERB_CUBIC = 4;
    public static final byte VERB_CLOSE = 5;
    public static final int DIRECTION_CW = 0;
    public static final int DIRECTION_CCW = 1;
    public static final int SEGMENT_LINE = 1;
    public static final int SEGMENT_QUAD = 2;
    public static final int SEGMENT_CUBIC = 8;
    private static final byte CONVEXITY_CONVEX = 0;
    private static final byte CONVEXITY_CONCAVE = 1;
    private static final byte CONVEXITY_UNKNOWN = 2;
    private static final byte FIRST_DIRECTION_CW = 0;
    private static final byte FIRST_DIRECTION_CCW = 1;
    private static final byte FIRST_DIRECTION_UNKNOWN = 2;
    public static final int APPROXIMATE_ARC_WITH_CUBICS = 0;
    public static final int APPROXIMATE_CONIC_WITH_QUADS = 1;
    @SharedPtr
    private PathRef mPathRef;
    private int mLastMoveToIndex;
    private byte mConvexity;
    private byte mFirstDirection;
    private byte mFillRule;

    public Path() {
        this.mPathRef = RefCnt.create(PathRef.EMPTY);
        this.resetFields();
    }

    public Path(@Nonnull Path other) {
        this.mPathRef = RefCnt.create(other.mPathRef);
        this.copyFields(other);
    }

    private void resetFields() {
        this.mLastMoveToIndex = -1;
        this.mFillRule = 0;
        this.mConvexity = (byte)2;
        this.mFirstDirection = (byte)2;
    }

    private void copyFields(@Nonnull Path other) {
        this.mLastMoveToIndex = other.mLastMoveToIndex;
        this.mConvexity = other.mConvexity;
        this.mFirstDirection = other.mFirstDirection;
        this.mFillRule = other.mFillRule;
    }

    @Override
    public int getFillRule() {
        return this.mFillRule;
    }

    public void setFillRule(int rule) {
        if ((rule & 0xFFFFFFFE) != 0) {
            throw new IllegalArgumentException();
        }
        assert (rule == 0 || rule == 1);
        this.mFillRule = (byte)rule;
    }

    public void set(@Nonnull Path other) {
        if (other != this) {
            this.mPathRef = RefCnt.create(this.mPathRef, other.mPathRef);
            this.copyFields(other);
        }
    }

    public void move(@Nonnull Path other) {
        if (other != this) {
            this.mPathRef = RefCnt.move(this.mPathRef, other.mPathRef);
            other.mPathRef = RefCnt.create(PathRef.EMPTY);
            this.copyFields(other);
            other.resetFields();
        }
    }

    public void reset() {
        if (this.mPathRef.unique()) {
            this.mPathRef.reset();
        } else {
            this.mPathRef = RefCnt.create(this.mPathRef, PathRef.EMPTY);
        }
        this.resetFields();
    }

    public void clear() {
        if (this.mPathRef.unique()) {
            this.mPathRef.reset();
        } else {
            int verbSize = this.mPathRef.mVerbSize;
            int coordSize = this.mPathRef.mCoordSize;
            this.mPathRef = RefCnt.move(this.mPathRef, new PathRef(verbSize, coordSize));
        }
        this.resetFields();
    }

    public void recycle() {
        this.mPathRef = RefCnt.create(this.mPathRef, PathRef.EMPTY);
        this.resetFields();
    }

    public void trimToSize() {
        if (this.mPathRef.unique()) {
            this.mPathRef.trimToSize();
        } else {
            this.mPathRef = RefCnt.move(this.mPathRef, new PathRef(this.mPathRef));
        }
    }

    public boolean isEmpty() {
        assert (this.mPathRef.mVerbSize == 0 == (this.mPathRef.mCoordSize == 0));
        return this.mPathRef.mVerbSize == 0;
    }

    public boolean isFinite() {
        return this.mPathRef.isFinite();
    }

    private void dirtyAfterEdit() {
        this.mConvexity = (byte)2;
        this.mFirstDirection = (byte)2;
    }

    @Override
    public void moveTo(float x, float y) {
        this.mLastMoveToIndex = this.mPathRef.mCoordSize;
        this.editor().addVerb((byte)0).addPoint(x, y);
        this.dirtyAfterEdit();
    }

    public void moveToRel(float dx, float dy) {
        int n = this.mPathRef.mCoordSize;
        if (n == 0) {
            throw new IllegalStateException("No first point");
        }
        float px = this.mPathRef.mCoords[n - 2];
        float py = this.mPathRef.mCoords[n - 1];
        this.moveTo(px + dx, py + dy);
    }

    @Override
    public void lineTo(float x, float y) {
        if (this.mLastMoveToIndex < 0) {
            throw new IllegalStateException("No initial point");
        }
        this.editor().addVerb((byte)1).addPoint(x, y);
        this.dirtyAfterEdit();
    }

    public void lineToRel(float dx, float dy) {
        int n = this.mPathRef.mCoordSize;
        if (n == 0) {
            throw new IllegalStateException("No first point");
        }
        float px = this.mPathRef.mCoords[n - 2];
        float py = this.mPathRef.mCoords[n - 1];
        this.lineTo(px + dx, py + dy);
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        if (this.mLastMoveToIndex < 0) {
            throw new IllegalStateException("No initial point");
        }
        this.editor().addVerb((byte)2).addPoint(x1, y1).addPoint(x2, y2);
        this.dirtyAfterEdit();
    }

    public void quadToRel(float dx1, float dy1, float dx2, float dy2) {
        int n = this.mPathRef.mCoordSize;
        if (n == 0) {
            throw new IllegalStateException("No first point");
        }
        float px = this.mPathRef.mCoords[n - 2];
        float py = this.mPathRef.mCoords[n - 1];
        this.quadTo(px + dx1, py + dy1, px + dx2, py + dy2);
    }

    @Override
    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.mLastMoveToIndex < 0) {
            throw new IllegalStateException("No initial point");
        }
        this.editor().addVerb((byte)4).addPoint(x1, y1).addPoint(x2, y2).addPoint(x3, y3);
        this.dirtyAfterEdit();
    }

    public void cubicToRel(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
        int n = this.mPathRef.mCoordSize;
        if (n == 0) {
            throw new IllegalStateException("No first point");
        }
        float px = this.mPathRef.mCoords[n - 2];
        float py = this.mPathRef.mCoords[n - 1];
        this.cubicTo(px + dx1, py + dy1, px + dx2, py + dy2, px + dx3, py + dy3);
    }

    @Override
    public void close() {
        int count = this.countVerbs();
        if (count != 0) {
            switch (this.mPathRef.mVerbs[count - 1]) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    this.editor().addVerb((byte)5);
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.mLastMoveToIndex ^= ~this.mLastMoveToIndex >> 31;
    }

    @Override
    public void done() {
    }

    public void transform(@Nonnull Matrixc matrix) {
        this.transform(matrix, this);
    }

    public void transform(@Nonnull Matrixc matrix, @Nullable Path dst) {
        if (matrix.isIdentity()) {
            if (dst != null && dst != this) {
                dst.set(this);
            }
            return;
        }
        if (dst == null) {
            dst = this;
        }
        if (!matrix.hasPerspective()) {
            this.mPathRef.createTransformedCopy(matrix, dst);
            if (this != dst) {
                dst.mLastMoveToIndex = this.mLastMoveToIndex;
                dst.mFillRule = this.mFillRule;
            }
        }
    }

    public int countVerbs() {
        return this.mPathRef.mVerbSize;
    }

    public int countPoints() {
        assert (this.mPathRef.mCoordSize % 2 == 0);
        return this.mPathRef.mCoordSize >> 1;
    }

    @Nonnull
    public Rect2fc getBounds() {
        return this.mPathRef.getBounds();
    }

    public void getBounds(@Nonnull Rect2f dst) {
        this.getBounds().store(dst);
    }

    public void updateBoundsCache() {
        this.mPathRef.updateBounds();
    }

    public int getSegmentMask() {
        return this.mPathRef.mSegmentMask;
    }

    @Override
    @Nonnull
    public PathIterator getPathIterator() {
        return new Iterator();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void forEach(@Nonnull PathConsumer action) {
        int n = this.countVerbs();
        if (n != 0) {
            byte[] vs = this.mPathRef.mVerbs;
            float[] cs = this.mPathRef.mCoords;
            int vi = 0;
            int ci = 0;
            block7: do {
                switch (vs[vi++]) {
                    case 0: {
                        if (vi == n) break block7;
                        action.moveTo(cs[ci++], cs[ci++]);
                        break;
                    }
                    case 1: {
                        action.lineTo(cs[ci++], cs[ci++]);
                        break;
                    }
                    case 2: {
                        action.quadTo(cs, ci);
                        ci += 4;
                        break;
                    }
                    case 4: {
                        action.cubicTo(cs, ci);
                        ci += 6;
                        break;
                    }
                    case 5: {
                        action.close();
                    }
                }
            } while (vi < n);
        }
        action.done();
    }

    public long estimatedByteSize() {
        long size = 32L;
        return size += this.mPathRef.estimatedByteSize();
    }

    public int hashCode() {
        int hash = this.mPathRef.hashCode();
        hash = 31 * hash + this.mFillRule;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            return this.mFillRule == other.mFillRule && this.mPathRef.equals(other.mPathRef);
        }
        return false;
    }

    void reversePop(@Nonnull PathConsumer out, boolean addMoveTo) {
        assert (this.mPathRef != null);
        byte[] vs = this.mPathRef.mVerbs;
        float[] cs = this.mPathRef.mCoords;
        int vi = this.mPathRef.mVerbSize;
        int ci = this.mPathRef.mCoordSize - 2;
        if (addMoveTo) {
            if (ci >= 0) {
                out.moveTo(cs[ci], cs[ci + 1]);
            } else {
                out.moveTo(0.0f, 0.0f);
            }
        }
        block6: while (vi != 0) {
            switch (vs[--vi]) {
                case 0: {
                    assert (vi == 0 && ci == 0);
                    break block6;
                }
                case 1: {
                    out.lineTo(cs[ci - 2], cs[ci - 1]);
                    ci -= 2;
                    continue block6;
                }
                case 2: {
                    out.quadTo(cs[ci - 2], cs[ci - 1], cs[ci - 4], cs[ci - 3]);
                    ci -= 4;
                    continue block6;
                }
                case 4: {
                    out.cubicTo(cs[ci - 2], cs[ci - 1], cs[ci - 4], cs[ci - 3], cs[ci - 6], cs[ci - 5]);
                    ci -= 6;
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        this.clear();
    }

    private PathRef editor() {
        if (!this.mPathRef.unique()) {
            this.mPathRef = RefCnt.move(this.mPathRef, new PathRef(this.mPathRef));
        }
        this.mPathRef.dirtyBounds();
        return this.mPathRef;
    }

    int computeConvexity() {
        if (!this.isFinite()) {
            return 1;
        }
        return 0;
    }

    @Nonnull
    private static byte[] growVerbs(@Nonnull byte[] old, int minGrow) {
        int oldCap;
        int grow = (oldCap = old.length) < 10 ? 10 - oldCap : (oldCap > 500 ? Math.max(250, oldCap >> 3) : oldCap >> 1);
        int newCap = oldCap + Math.max(grow, minGrow);
        if (newCap < 0) {
            newCap = oldCap + minGrow;
            if (newCap < 0) {
                throw new IllegalStateException("Path is too big " + oldCap + " + " + minGrow);
            }
            newCap = Integer.MAX_VALUE;
        }
        return Arrays.copyOf(old, newCap);
    }

    @Nonnull
    private static float[] growCoords(@Nonnull float[] old, int minGrow) {
        int oldCap = old.length;
        int grow = oldCap < 20 ? 20 - oldCap : (oldCap > 1000 ? Math.max(500, oldCap >> 4 << 1) : oldCap >> 2 << 1);
        assert (oldCap % 2 == 0 && minGrow % 2 == 0);
        int newCap = oldCap + Math.max(grow, minGrow);
        if (newCap < 0) {
            newCap = oldCap + minGrow;
            if (newCap < 0) {
                throw new IllegalStateException("Path is too big " + oldCap + " + " + minGrow);
            }
            newCap = 0x7FFFFFFE;
        }
        return Arrays.copyOf(old, newCap);
    }

    static final class PathRef
    implements RefCounted {
        private static final VarHandle USAGE_CNT;
        static final byte[] EMPTY_VERBS;
        static final float[] EMPTY_COORDS;
        static final PathRef EMPTY;
        volatile transient int mUsageCnt = 1;
        final Rect2f mBounds = new Rect2f(0.0f, 0.0f, -1.0f, -1.0f);
        byte[] mVerbs;
        float[] mCoords;
        int mVerbSize;
        int mCoordSize;
        byte mSegmentMask;

        PathRef() {
            this(EMPTY_VERBS, EMPTY_COORDS);
        }

        PathRef(int verbSize, int coordSize) {
            assert (coordSize % 2 == 0);
            if (verbSize > 0) {
                assert (coordSize > 0);
                this.mVerbs = new byte[verbSize];
                this.mCoords = new float[coordSize];
            } else {
                this.mVerbs = EMPTY_VERBS;
                this.mCoords = EMPTY_COORDS;
            }
        }

        PathRef(byte[] verbs, float[] coords) {
            assert (coords.length % 2 == 0);
            this.mVerbs = verbs;
            this.mCoords = coords;
        }

        PathRef(@Nonnull PathRef other) {
            this.mBounds.set(other.mBounds);
            if (other.mVerbSize > 0) {
                assert (other.mCoordSize > 0);
                this.mVerbs = Arrays.copyOf(other.mVerbs, other.mVerbSize);
                this.mCoords = Arrays.copyOf(other.mCoords, other.mCoordSize);
            } else {
                this.mVerbs = EMPTY_VERBS;
                this.mCoords = EMPTY_COORDS;
            }
            this.mVerbSize = other.mVerbSize;
            this.mCoordSize = other.mCoordSize;
            this.mSegmentMask = other.mSegmentMask;
        }

        PathRef(@Nonnull PathRef other, int incVerbs, int incCoords) {
            assert (incVerbs >= 0 && incCoords >= 0);
            assert (incCoords % 2 == 0);
            this.mVerbs = new byte[other.mVerbSize + incVerbs];
            this.mCoords = new float[other.mCoordSize + incCoords];
            this.mBounds.set(other.mBounds);
            System.arraycopy(other.mVerbs, 0, this.mVerbs, 0, other.mVerbSize);
            System.arraycopy(other.mCoords, 0, this.mCoords, 0, other.mCoordSize);
            this.mVerbSize = other.mVerbSize;
            this.mCoordSize = other.mCoordSize;
            this.mSegmentMask = other.mSegmentMask;
        }

        boolean unique() {
            return USAGE_CNT.getAcquire(this) == 1 && this != EMPTY;
        }

        @Override
        public void ref() {
            USAGE_CNT.getAndAddAcquire(this, 1);
        }

        @Override
        public void unref() {
            USAGE_CNT.getAndAdd(this, -1);
        }

        void createTransformedCopy(Matrixc matrix, Path dstPath) {
            PathRef dst;
            if (matrix.isIdentity()) {
                if (this != dstPath.mPathRef) {
                    dstPath.mPathRef = RefCnt.create(dstPath.mPathRef, this);
                }
                return;
            }
            boolean keepThisAlive = false;
            if (!dstPath.mPathRef.unique()) {
                if (dstPath.mPathRef == this) {
                    this.ref();
                    keepThisAlive = true;
                }
                dstPath.mPathRef = RefCnt.move(dstPath.mPathRef, new PathRef());
            }
            if (this != (dst = dstPath.mPathRef)) {
                dst.mVerbs = Arrays.copyOf(this.mVerbs, this.mVerbSize);
                dst.mVerbSize = this.mVerbSize;
                if (dst.mCoords.length < this.mCoordSize) {
                    dst.mCoords = dst.mCoords.length == 0 ? new float[this.mCoordSize] : Path.growCoords(dst.mCoords, this.mCoordSize - dst.mCoords.length);
                }
                dst.mCoordSize = this.mCoordSize;
            }
            matrix.mapPoints(this.mCoords, dst.mCoords, this.mCoordSize >> 1);
            dst.dirtyBounds();
            dst.mSegmentMask = this.mSegmentMask;
            if (keepThisAlive) {
                this.unref();
            }
        }

        void dirtyBounds() {
            this.mBounds.set(0.0f, 0.0f, -1.0f, -1.0f);
        }

        boolean boundsIsDirty() {
            return !this.mBounds.isSorted() && this.mBounds.isFinite();
        }

        void reset() {
            this.dirtyBounds();
            this.mSegmentMask = 0;
            this.mVerbSize = 0;
            this.mCoordSize = 0;
        }

        void reserve(int incVerbs, int incCoords) {
            assert (incVerbs >= 0 && incCoords >= 0);
            assert (incCoords % 2 == 0);
            if (this.mVerbSize > this.mVerbs.length - incVerbs) {
                this.mVerbs = Path.growVerbs(this.mVerbs, incVerbs - this.mVerbs.length + this.mVerbSize);
            }
            if (this.mCoordSize > this.mCoords.length - incCoords) {
                this.mCoords = Path.growCoords(this.mCoords, incCoords - this.mCoords.length + this.mCoordSize);
            }
        }

        void trimToSize() {
            if (this.mVerbSize > 0) {
                assert (this.mCoordSize > 0);
                if (this.mVerbSize < this.mVerbs.length) {
                    this.mVerbs = Arrays.copyOf(this.mVerbs, this.mVerbSize);
                }
                if (this.mCoordSize < this.mCoords.length) {
                    this.mCoords = Arrays.copyOf(this.mCoords, this.mCoordSize);
                }
            } else {
                this.mVerbs = EMPTY_VERBS;
                this.mCoords = EMPTY_COORDS;
            }
        }

        PathRef addVerb(byte verb) {
            int coords = switch (verb) {
                case 0 -> 2;
                case 1 -> {
                    this.mSegmentMask = (byte)(this.mSegmentMask | 1);
                    yield 2;
                }
                case 2 -> {
                    this.mSegmentMask = (byte)(this.mSegmentMask | 2);
                    yield 4;
                }
                case 4 -> {
                    this.mSegmentMask = (byte)(this.mSegmentMask | 8);
                    yield 6;
                }
                default -> 0;
            };
            this.reserve(1, coords);
            this.mVerbs[this.mVerbSize++] = verb;
            return this;
        }

        PathRef addPoint(float x, float y) {
            this.mCoords[this.mCoordSize++] = x;
            this.mCoords[this.mCoordSize++] = y;
            return this;
        }

        void updateBounds() {
            if (this.boundsIsDirty()) {
                assert (this.mCoordSize % 2 == 0);
                this.mBounds.setBoundsNoCheck(this.mCoords, 0, this.mCoordSize >> 1);
            }
        }

        boolean isFinite() {
            this.updateBounds();
            return this.mBounds.isFinite();
        }

        Rect2fc getBounds() {
            if (this.isFinite()) {
                return this.mBounds;
            }
            return Rect2f.empty();
        }

        long estimatedByteSize() {
            if (this == EMPTY) {
                return 0L;
            }
            long size = 80L;
            if (this.mVerbs != EMPTY_VERBS) {
                size += (long)(16 + MathUtil.align8(this.mVerbs.length));
            }
            if (this.mCoords != EMPTY_COORDS) {
                assert (this.mCoords.length % 2 == 0);
                size += 16L + ((long)this.mCoords.length << 2);
            }
            return size;
        }

        public int hashCode() {
            int i;
            int hash = 7;
            int count = this.mVerbSize;
            for (i = 0; i < count; ++i) {
                hash = 11 * hash + this.mVerbs[i];
            }
            count = this.mCoordSize;
            for (i = 0; i < count; ++i) {
                hash = 11 * hash + Float.floatToIntBits(this.mCoords[i]);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PathRef)) {
                return false;
            }
            PathRef other = (PathRef)obj;
            if (this.mSegmentMask != other.mSegmentMask) {
                return false;
            }
            if (this.mCoordSize != other.mCoordSize) {
                return false;
            }
            if (!Arrays.equals(this.mVerbs, 0, this.mVerbSize, other.mVerbs, 0, other.mVerbSize)) {
                return false;
            }
            int count = this.mCoordSize;
            for (int i = 0; i < count; ++i) {
                if (this.mCoords[i] == other.mCoords[i]) continue;
                return false;
            }
            return true;
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                USAGE_CNT = lookup.findVarHandle(PathRef.class, "mUsageCnt", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            EMPTY_VERBS = new byte[0];
            EMPTY_COORDS = new float[0];
            EMPTY = new PathRef();
            EMPTY.updateBounds();
        }
    }

    private class Iterator
    implements PathIterator {
        private final int count;
        private int verbPos;
        private int coordPos;

        private Iterator() {
            this.count = Path.this.countVerbs();
        }

        @Override
        public int getFillRule() {
            return Path.this.mFillRule;
        }

        @Override
        public int next(float[] coords, int offset) {
            if (this.verbPos == this.count) {
                return 6;
            }
            byte verb = Path.this.mPathRef.mVerbs[this.verbPos++];
            switch (verb) {
                case 0: {
                    if (this.verbPos == this.count) {
                        return 6;
                    }
                    if (coords != null) {
                        coords[offset] = Path.this.mPathRef.mCoords[this.coordPos];
                        coords[offset + 1] = Path.this.mPathRef.mCoords[this.coordPos + 1];
                    }
                    this.coordPos += 2;
                    break;
                }
                case 1: {
                    if (coords != null) {
                        coords[offset] = Path.this.mPathRef.mCoords[this.coordPos];
                        coords[offset + 1] = Path.this.mPathRef.mCoords[this.coordPos + 1];
                    }
                    this.coordPos += 2;
                    break;
                }
                case 2: {
                    if (coords != null) {
                        System.arraycopy(Path.this.mPathRef.mCoords, this.coordPos, coords, offset, 4);
                    }
                    this.coordPos += 4;
                    break;
                }
                case 4: {
                    if (coords != null) {
                        System.arraycopy(Path.this.mPathRef.mCoords, this.coordPos, coords, offset, 6);
                    }
                    this.coordPos += 6;
                }
            }
            return verb;
        }
    }

    static class ConvexState {
        ConvexState() {
        }
    }

    @ApiStatus.Internal
    public class RawIterator {
        private final int count;
        private int verbPos;
        private int coordPos;
        private int coordOff;
        private int coordInc;

        public RawIterator() {
            this.count = Path.this.countVerbs();
        }

        public boolean hasNext() {
            return this.verbPos < this.count;
        }

        public byte next() {
            if (this.verbPos == this.count) {
                return 6;
            }
            byte verb = Path.this.mPathRef.mVerbs[this.verbPos++];
            this.coordPos += this.coordInc;
            switch (verb) {
                case 0: 
                case 1: {
                    this.coordInc = 2;
                    break;
                }
                case 2: {
                    this.coordInc = 4;
                    break;
                }
                case 4: {
                    this.coordInc = 6;
                    break;
                }
                case 5: {
                    this.coordInc = 0;
                }
            }
            this.coordOff = verb == 0 ? 0 : -2;
            return verb;
        }

        public float x0() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff];
        }

        public float y0() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff + 1];
        }

        public float x1() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff + 2];
        }

        public float y1() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff + 3];
        }

        public float x2() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff + 4];
        }

        public float y2() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff + 5];
        }

        public float x3() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff + 6];
        }

        public float y3() {
            return Path.this.mPathRef.mCoords[this.coordPos + this.coordOff + 7];
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SegmentMask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FillRule {
    }
}

