/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Blender;
import icyllis.arc3d.core.Canvas;
import icyllis.arc3d.core.Device;
import icyllis.arc3d.core.GlyphRunList;
import icyllis.arc3d.core.Image;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.Matrix4c;
import icyllis.arc3d.core.Paint;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.RoundRect;
import icyllis.arc3d.core.SamplingOptions;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Vertices;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class NoPixelsDevice
extends Device {
    private static final int CLIP_POOL_SIZE = 16;
    private ConservativeClip[] mClipStack = new ConservativeClip[16];
    private int mClipIndex = 0;

    public NoPixelsDevice(@Nonnull Rect2ic bounds) {
        this(bounds.left(), bounds.top(), bounds.right(), bounds.bottom());
    }

    public NoPixelsDevice(int left, int top, int right, int bottom) {
        super(new ImageInfo(right - left, bottom - top));
        this.setOrigin(null, left, top);
        ConservativeClip clip = new ConservativeClip();
        clip.setRect(this.getBounds());
        this.mClipStack[0] = clip;
    }

    public final void resetForNextPicture(int left, int top, int right, int bottom) {
        this.resize(right - left, bottom - top);
        this.setOrigin(null, left, top);
        for (int i = this.mClipIndex; i > 0; --i) {
            this.pop();
        }
        ConservativeClip clip = this.mClipStack[0];
        clip.setRect(this.getBounds());
        clip.mDeferredSaveCount = 0;
    }

    @Nonnull
    private ConservativeClip push() {
        ConservativeClip clip;
        int i;
        ConservativeClip[] stack = this.mClipStack;
        if ((i = ++this.mClipIndex) == stack.length) {
            this.mClipStack = stack = Arrays.copyOf(stack, i + (i >> 1));
        }
        if ((clip = stack[i]) == null) {
            stack[i] = clip = new ConservativeClip();
        }
        return clip;
    }

    private void pop() {
        int i;
        if ((i = this.mClipIndex--) >= 16) {
            this.mClipStack[i] = null;
        }
    }

    @Nonnull
    private ConservativeClip getClip() {
        return this.mClipStack[this.mClipIndex];
    }

    @Nonnull
    private ConservativeClip getWritableClip() {
        ConservativeClip current = this.mClipStack[this.mClipIndex];
        if (current.mDeferredSaveCount > 0) {
            --current.mDeferredSaveCount;
            ConservativeClip next = this.push();
            next.set(current);
            next.mDeferredSaveCount = 0;
            return next;
        }
        return current;
    }

    @Override
    public void pushClipStack() {
        ++this.mClipStack[this.mClipIndex].mDeferredSaveCount;
    }

    @Override
    public void popClipStack() {
        ConservativeClip clip = this.mClipStack[this.mClipIndex];
        if (clip.mDeferredSaveCount > 0) {
            --clip.mDeferredSaveCount;
        } else {
            this.pop();
        }
    }

    @Override
    public void clipRect(Rect2fc rect, int clipOp, boolean doAA) {
        this.getWritableClip().op(rect, this.getLocalToDevice(), clipOp, doAA, true);
    }

    public void replaceClip(Rect2ic globalRect) {
        Rect2i deviceRect = new Rect2i();
        this.getGlobalToDevice().mapRect(globalRect, deviceRect);
        ConservativeClip clip = this.getWritableClip();
        if (!deviceRect.intersect(this.getBounds())) {
            clip.setEmpty();
        } else {
            clip.setRect(deviceRect);
        }
    }

    @Override
    public boolean isClipAA() {
        return this.getClip().mIsAA;
    }

    @Override
    public boolean isClipEmpty() {
        return this.getClipBounds().isEmpty();
    }

    @Override
    public boolean isClipRect() {
        return this.getClip().mIsRect && !this.isClipEmpty();
    }

    @Override
    public boolean isClipWideOpen() {
        return this.getClip().mIsRect && this.getClipBounds().equals(this.getBounds());
    }

    @Override
    public void getClipBounds(@Nonnull Rect2i bounds) {
        bounds.set(this.getClipBounds());
    }

    @Override
    protected Rect2ic getClipBounds() {
        return this.getClip().getBounds();
    }

    @Override
    public void drawPaint(Paint paint) {
    }

    @Override
    public void drawPoints(int mode, float[] pts, int offset, int count, Paint paint) {
    }

    @Override
    public void drawLine(float x0, float y0, float x1, float y1, int cap, float width, Paint paint) {
    }

    @Override
    public void drawRect(Rect2fc r, Paint paint) {
    }

    @Override
    public void drawRoundRect(RoundRect rr, Paint paint) {
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
    }

    @Override
    public void drawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, int cap, float width, Paint paint) {
    }

    @Override
    public void drawPie(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
    }

    @Override
    public void drawChord(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
    }

    @Override
    public void drawImageRect(@RawPtr Image image, Rect2fc src, Rect2fc dst, SamplingOptions sampling, Paint paint, int constraint) {
    }

    @Override
    protected void onDrawGlyphRunList(Canvas canvas, GlyphRunList glyphRunList, Paint paint) {
    }

    @Override
    public void drawVertices(Vertices vertices, @SharedPtr Blender blender, Paint paint) {
        RefCnt.move(blender);
    }

    private static final class ConservativeClip {
        private final Rect2i mClipBounds = new Rect2i();
        private int mDeferredSaveCount = 0;
        private boolean mIsAA = false;
        private boolean mIsRect = true;

        ConservativeClip() {
        }

        public void set(ConservativeClip clip) {
            this.mClipBounds.set(clip.mClipBounds);
            this.mIsRect = clip.mIsRect;
            this.mIsAA = clip.mIsAA;
        }

        public Rect2ic getBounds() {
            return this.mClipBounds;
        }

        public void setEmpty() {
            this.mClipBounds.setEmpty();
            this.mIsRect = true;
            this.mIsAA = false;
        }

        public void setRect(Rect2ic r) {
            this.mClipBounds.set(r);
            this.mIsRect = true;
            this.mIsAA = false;
        }

        public void op(Rect2fc localBounds, Matrix4c localToDevice, int op, boolean isAA, boolean isRect) {
            boolean isDeviceRect;
            this.mIsAA |= isAA;
            boolean bl = isDeviceRect = isRect && localToDevice.isAxisAligned();
            if (op == 1) {
                if (!localBounds.isEmpty()) {
                    Rect2i deviceRect = new Rect2i();
                    if (isAA) {
                        localToDevice.mapRectOut(localBounds, deviceRect);
                    } else {
                        localToDevice.mapRect(localBounds, deviceRect);
                    }
                    if (!this.mClipBounds.intersect(deviceRect)) {
                        this.mClipBounds.setEmpty();
                    }
                } else {
                    this.mClipBounds.setEmpty();
                }
                this.mIsRect &= isDeviceRect;
            } else if (isDeviceRect) {
                assert (op == 0);
                Rect2i deviceRect = new Rect2i();
                if (isAA) {
                    localToDevice.mapRectIn(localBounds, deviceRect);
                } else {
                    localToDevice.mapRect(localBounds, deviceRect);
                }
                Rect2i difference = new Rect2i();
                if (Rect2i.subtract(this.mClipBounds, deviceRect, difference)) {
                    this.mClipBounds.set(difference);
                } else {
                    this.mIsRect = false;
                }
            } else {
                this.mIsRect = false;
            }
        }
    }
}

