/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.sodium.mixin.clouds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.render.immediate.CloudRenderer;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.compat.sodium.impl.vertex_format.entity_xhfp.CloudVertex;
import net.irisshaders.iris.pipeline.ShaderRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4063;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_758;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CloudRenderer.class})
public abstract class MixinCloudRenderer {
    @Shadow
    private class_5944 shader;
    @Shadow
    @Final
    private class_758.class_7285 fogData;
    @Unique
    private class_291 vertexBufferWithNormals;
    @Unique
    private int prevCenterCellXIris;
    @Unique
    private int prevCenterCellYIris;
    @Unique
    private int cachedRenderDistanceIris;
    @Shadow
    private class_4063 cloudRenderMode;

    @Inject(method={"writeVertex"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void writeIrisVertex(long buffer, float x, float y, float z, int color, CallbackInfoReturnable<Long> cir) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            CloudVertex.write(buffer, x, y, z, color);
            cir.setReturnValue((Object)(buffer + 20L));
        }
    }

    @Shadow
    protected abstract void rebuildGeometry(class_287 var1, int var2, int var3, int var4);

    @Shadow
    protected abstract void applyFogModifiers(class_638 var1, class_758.class_7285 var2, class_746 var3, int var4, float var5);

    @Inject(method={"render(Lnet/minecraft/class_638;Lnet/minecraft/class_746;Lnet/minecraft/class_4587;Lorg/joml/Matrix4f;FFDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildIrisVertexBuffer(class_638 level, class_746 player, class_4587 matrices, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            ci.cancel();
            this.renderIris(level, player, matrices, projectionMatrix, ticks, tickDelta, cameraX, cameraY, cameraZ);
        }
    }

    public void renderIris(@Nullable class_638 level, class_746 player, class_4587 matrices, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ) {
        boolean fastClouds;
        if (level == null) {
            return;
        }
        float cloudHeight = level.method_28103().method_28108();
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        class_243 color = level.method_23785(tickDelta);
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = cameraX + cloudTime;
        double cloudCenterZ = cameraZ + 0.33;
        int renderDistance = class_310.method_1551().field_1690.method_38521();
        int cloudDistance = Math.max(32, renderDistance * 2 + 9);
        int centerCellX = (int)Math.floor(cloudCenterX / 12.0);
        int centerCellZ = (int)Math.floor(cloudCenterZ / 12.0);
        if (this.vertexBufferWithNormals == null || this.prevCenterCellXIris != centerCellX || this.prevCenterCellYIris != centerCellZ || this.cachedRenderDistanceIris != renderDistance || this.cloudRenderMode != class_310.method_1551().field_1690.method_1632()) {
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            this.cloudRenderMode = class_310.method_1551().field_1690.method_1632();
            this.rebuildGeometry(bufferBuilder, cloudDistance, centerCellX, centerCellZ);
            if (this.vertexBufferWithNormals == null) {
                this.vertexBufferWithNormals = new class_291(class_291.class_8555.field_44794);
            }
            this.vertexBufferWithNormals.method_1353();
            this.vertexBufferWithNormals.method_1352(bufferBuilder.method_1326());
            class_291.method_1354();
            this.prevCenterCellXIris = centerCellX;
            this.prevCenterCellYIris = centerCellZ;
            this.cachedRenderDistanceIris = renderDistance;
        }
        float previousEnd = RenderSystem.getShaderFogEnd();
        float previousStart = RenderSystem.getShaderFogStart();
        this.fogData.field_38341 = cloudDistance * 8;
        this.fogData.field_38340 = cloudDistance * 8 - 16;
        this.applyFogModifiers(level, this.fogData, player, cloudDistance * 8, tickDelta);
        RenderSystem.setShaderFogEnd((float)this.fogData.field_38341);
        RenderSystem.setShaderFogStart((float)this.fogData.field_38340);
        float translateX = (float)(cloudCenterX - (double)(centerCellX * 12));
        float translateZ = (float)(cloudCenterZ - (double)(centerCellZ * 12));
        RenderSystem.enableDepthTest();
        this.vertexBufferWithNormals.method_1353();
        boolean insideClouds = cameraY < (double)(cloudHeight + 4.5f) && cameraY > (double)(cloudHeight - 0.5f);
        boolean bl = fastClouds = this.cloudRenderMode == class_4063.field_18163;
        if (insideClouds || fastClouds) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.enableCull();
        }
        if (class_310.method_29611()) {
            class_310.method_1551().field_1769.method_29364().method_1235(false);
        }
        RenderSystem.setShaderColor((float)((float)color.field_1352), (float)((float)color.field_1351), (float)((float)color.field_1350), (float)0.8f);
        matrices.method_22903();
        Matrix4f modelViewMatrix = matrices.method_23760().method_23761();
        modelViewMatrix.translate(-translateX, cloudHeight - (float)cameraY + 0.33f, -translateZ);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.vertexBufferWithNormals.method_34427(modelViewMatrix, projectionMatrix, this.getClouds());
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)514);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.vertexBufferWithNormals.method_34427(modelViewMatrix, projectionMatrix, this.getClouds());
        matrices.method_22909();
        class_291.method_1354();
        RenderSystem.disableBlend();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (class_310.method_29611()) {
            class_310.method_1551().method_1522().method_1235(false);
        }
        RenderSystem.setShaderFogEnd((float)previousEnd);
        RenderSystem.setShaderFogStart((float)previousStart);
    }

    @ModifyArg(method={"rebuildGeometry(Lnet/minecraft/class_287;III)V"}, at=@At(value="INVOKE", target="Lorg/lwjgl/system/MemoryStack;nmalloc(I)J"))
    private int allocateNewSize(int size) {
        return IrisApi.getInstance().isShaderPackInUse() ? 480 : size;
    }

    @ModifyArg(method={"rebuildGeometry(Lnet/minecraft/class_287;III)V"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/api/vertex/buffer/VertexBufferWriter;push(Lorg/lwjgl/system/MemoryStack;JILnet/caffeinemc/mods/sodium/api/vertex/format/VertexFormatDescription;)V"), index=3)
    private VertexFormatDescription modifyArgIris(VertexFormatDescription vertexFormatDescription) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return CloudVertex.FORMAT;
        }
        return ColorVertex.FORMAT;
    }

    private class_5944 getClouds() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof ShaderRenderingPipeline) {
            return ((ShaderRenderingPipeline)pipeline).getShaderMap().getShader(ShaderKey.CLOUDS_SODIUM);
        }
        return this.shader;
    }
}

