/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.BigTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class BigTreeFeature
extends BOPTreeFeature<BigTreeConfiguration> {
    private final double trunkHeightScale = 0.618;
    private final double branchSlope = 0.381;
    private final double widthScale = 1.0;
    private final int trunkWidth = 1;

    public BigTreeFeature(Codec<BigTreeConfiguration> codec) {
        super(codec);
    }

    private void crossSection(class_1936 world, class_2338 pos, float radius, class_5819 random, class_4647.class_8179 leaves, BigTreeConfiguration config) {
        int r = (int)((double)radius + 0.618);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                if (!(Math.pow((double)Math.abs(dx) + 0.5, 2.0) + Math.pow((double)Math.abs(dz) + 0.5, 2.0) <= (double)(radius * radius))) continue;
                class_2338 blockpos = pos.method_10069(dx, 0, dz);
                if (this.canReplace(world, blockpos)) {
                    if (config.altFoliageProvider.method_23455(random, pos) != class_2246.field_10124.method_9564()) {
                        int rand = random.method_43048(4);
                        if (rand == 0) {
                            this.placeAltLeaves(world, blockpos, leaves, config);
                        } else {
                            this.placeLeaves(world, blockpos, leaves, config);
                        }
                    } else {
                        this.placeLeaves(world, blockpos, leaves, config);
                    }
                }
                int hanging_height = random.method_43048(3) + 1;
                if (config.hangingProvider.method_23455(random, pos) == class_2246.field_10124.method_9564() || random.method_43048(4) != 0) continue;
                for (int i = 0; i < hanging_height; ++i) {
                    if (!this.canReplace(world, blockpos.method_10087(i))) continue;
                    this.setHanging(world, blockpos.method_10087(i), config);
                }
            }
        }
    }

    private float treeShape(int height, int y) {
        if ((float)y < (float)height * 0.3f) {
            return -1.0f;
        }
        float radius = (float)height / 2.0f;
        float adjacent = radius - (float)y;
        float distance = class_3532.method_15355((float)(radius * radius - adjacent * adjacent));
        if (adjacent == 0.0f) {
            distance = radius;
        } else if (Math.abs(adjacent) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    private float foliageShape(int y, BigTreeConfiguration config) {
        if (y < 0 || y >= config.foliageHeight) {
            return -1.0f;
        }
        if (y == 0 || y == config.foliageHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    private void foliageCluster(class_1936 world, class_2338 pos, class_5819 random, class_4647.class_8179 leaves, BigTreeConfiguration config) {
        for (int y = 0; y < config.foliageHeight; ++y) {
            this.crossSection(world, pos.method_10086(y), this.foliageShape(y, config), random, leaves, config);
        }
    }

    private int checkLineAndOptionallySet(class_1936 world, class_2338 startPos, class_2338 endPos, boolean set, BiConsumer<class_2338, class_2680> logs, BigTreeConfiguration config) {
        if (!set && Objects.equals(startPos, endPos)) {
            return -1;
        }
        class_2338 delta = endPos.method_10069(-startPos.method_10263(), -startPos.method_10264(), -startPos.method_10260());
        int steps = this.getGreatestDistance(delta);
        float dx = (float)delta.method_10263() / (float)steps;
        float dy = (float)delta.method_10264() / (float)steps;
        float dz = (float)delta.method_10260() / (float)steps;
        for (int j = 0; j <= steps; ++j) {
            class_2338 deltaPos = startPos.method_10069(class_3532.method_15357((double)(0.5f + (float)j * dx)), class_3532.method_15357((double)(0.5f + (float)j * dy)), class_3532.method_15357((double)(0.5f + (float)j * dz)));
            if (set) {
                this.placeLog(world, deltaPos, this.getLogAxis(startPos, deltaPos), logs, config);
                continue;
            }
            if (BigTreeFeature.isFree((class_3746)world, deltaPos)) continue;
            return j;
        }
        return -1;
    }

    private int getGreatestDistance(class_2338 posIn) {
        int i = class_3532.method_15382((int)posIn.method_10263());
        int j = class_3532.method_15382((int)posIn.method_10264());
        int k = class_3532.method_15382((int)posIn.method_10260());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private class_2350.class_2351 getLogAxis(class_2338 startPos, class_2338 endPos) {
        int zDiff;
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        int xDiff = Math.abs(endPos.method_10263() - startPos.method_10263());
        int maxDiff = Math.max(xDiff, zDiff = Math.abs(endPos.method_10260() - startPos.method_10260()));
        if (maxDiff > 0) {
            if (xDiff == maxDiff) {
                axis = class_2350.class_2351.field_11048;
            } else if (zDiff == maxDiff) {
                axis = class_2350.class_2351.field_11051;
            }
        }
        return axis;
    }

    private void makeFoliage(class_1936 worldIn, int height, class_2338 pos, List<FoliageCoordinates> coordinates, class_5819 random, class_4647.class_8179 leaves, BigTreeConfiguration config) {
        for (FoliageCoordinates coordinate : coordinates) {
            if (!this.trimBranches(height, coordinate.getBranchBase() - pos.method_10264())) continue;
            this.foliageCluster(worldIn, coordinate, random, leaves, config);
        }
    }

    private boolean trimBranches(int height, int localY) {
        return (double)localY >= (double)height * 0.2;
    }

    private void makeTrunk(class_1936 world, class_2338 pos, int height, BiConsumer<class_2338, class_2680> logs, BigTreeConfiguration config) {
        this.checkLineAndOptionallySet(world, pos, pos.method_10086(height), true, logs, config);
    }

    private void makeBranches(class_1936 world, int height, class_2338 origin, List<FoliageCoordinates> coordinates, BiConsumer<class_2338, class_2680> logs, BigTreeConfiguration config) {
        for (FoliageCoordinates coordinate : coordinates) {
            int branchBase = coordinate.getBranchBase();
            class_2338 baseCoord = new class_2338(origin.method_10263(), branchBase, origin.method_10260());
            if (baseCoord.equals((Object)coordinate) || !this.trimBranches(height, branchBase - origin.method_10264())) continue;
            this.checkLineAndOptionallySet(world, baseCoord, coordinate, true, logs, config);
        }
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        int relativeY;
        int clustersPerY;
        int trunkHeight;
        BigTreeConfiguration config = (BigTreeConfiguration)configBase;
        int height = this.checkLocation((class_1936)world, pos, config.minHeight + random.method_43048(config.maxHeight), logs, config);
        if (height == -1) {
            return false;
        }
        if (world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10219 || world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10402) {
            this.method_13153((class_1945)world, pos.method_10074(), class_2246.field_10566.method_9564());
        }
        if ((trunkHeight = (int)((double)height * this.trunkHeightScale)) >= height) {
            trunkHeight = height - 1;
        }
        if ((clustersPerY = (int)(1.382 + Math.pow(config.foliageDensity * (double)height / 13.0, 2.0))) < 1) {
            clustersPerY = 1;
        }
        int trunkTop = pos.method_10264() + trunkHeight;
        ArrayList foliageCoords = Lists.newArrayList();
        foliageCoords.add(new FoliageCoordinates(pos.method_10086(relativeY), trunkTop));
        for (relativeY = height - config.foliageHeight; relativeY >= 0; --relativeY) {
            float treeShape = this.treeShape(height, relativeY);
            if (treeShape < 0.0f) continue;
            for (int i = 0; i < clustersPerY; ++i) {
                class_2338 checkEnd;
                int z;
                double angle;
                double radius = 1.0 * (double)treeShape * ((double)random.method_43057() + 0.328);
                int x = class_3532.method_15357((double)(radius * Math.sin(angle = (double)(random.method_43057() * 2.0f) * Math.PI) + 0.5));
                class_2338 checkStart = pos.method_10069(x, relativeY - 1, z = class_3532.method_15357((double)(radius * Math.cos(angle) + 0.5)));
                if (this.checkLineAndOptionallySet((class_1936)world, checkStart, checkEnd = checkStart.method_10086(5), false, logs, config) != -1) continue;
                int dx = pos.method_10263() - checkStart.method_10263();
                int dz = pos.method_10260() - checkStart.method_10260();
                double branchHeight = (double)checkStart.method_10264() - Math.sqrt(dx * dx + dz * dz) * this.branchSlope;
                int branchTop = branchHeight > (double)trunkTop ? trunkTop : (int)branchHeight;
                class_2338 checkBranchBase = new class_2338(pos.method_10263(), branchTop, pos.method_10260());
                if (this.checkLineAndOptionallySet((class_1936)world, checkBranchBase, checkStart, false, logs, config) != -1) continue;
                foliageCoords.add(new FoliageCoordinates(checkStart, checkBranchBase.method_10264()));
            }
        }
        this.makeFoliage((class_1936)world, height, pos, foliageCoords, random, leaves, config);
        this.makeTrunk((class_1936)world, pos, trunkHeight, logs, config);
        this.makeBranches((class_1936)world, height, pos, foliageCoords, logs, config);
        return true;
    }

    private int checkLocation(class_1936 world, class_2338 pos, int height, BiConsumer<class_2338, class_2680> logs, BigTreeConfiguration config) {
        int step = this.checkLineAndOptionallySet(world, pos, pos.method_10086(height - 1), false, logs, config);
        if (step == -1) {
            return height;
        }
        return step < 6 ? -1 : step;
    }

    static class FoliageCoordinates
    extends class_2338 {
        private final int branchBase;

        public FoliageCoordinates(class_2338 pos, int branchBase) {
            super(pos.method_10263(), pos.method_10264(), pos.method_10260());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

