/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.inventory.CraftResultSlot;
import com.jaquadro.minecraft.storagedrawers.inventory.RestrictedSlot;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerFramingTable
extends class_1703 {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private static final int InputX = 23;
    private static final int InputY = 35;
    private static final int MaterialSideX = 50;
    private static final int MaterialSideY = 17;
    private static final int MaterialTrimX = 102;
    private static final int MaterialTrimY = 17;
    private static final int MaterialFrontX = 50;
    private static final int MaterialFrontY = 53;
    private static final int OutputX = 133;
    private static final int OutputY = 35;
    private final BlockEntityFramingTable blockEntity;
    private final class_1263 tableInventory;
    private final class_1263 craftResult;
    private final class_3914 access;
    private final class_1657 player;
    private class_1735 inputSlot;
    private class_1735 materialSideSlot;
    private class_1735 materialTrimSlot;
    private class_1735 materialFrontSlot;
    private class_1735 outputSlot;
    private List<class_1735> playerSlots;
    private List<class_1735> hotbarSlots;

    public ContainerFramingTable(int windowId, class_1661 playerInv, Optional<PositionContent> content) {
        this((class_3917)ModContainers.FRAMING_TABLE.get(), windowId, playerInv, PositionContent.getOrNull(content, playerInv.field_7546.method_37908(), BlockEntityFramingTable.class));
    }

    protected static BlockEntityFramingTable getBlockEntity(class_1661 playerInv, class_2338 pos) {
        class_1937 level = playerInv.field_7546.method_5770();
        BlockEntityFramingTable blockEntity = WorldUtils.getBlockEntity((class_1922)level, pos, BlockEntityFramingTable.class);
        if (blockEntity != null) {
            return blockEntity;
        }
        ModServices.log.error("Expected a framing table tile entity at " + pos);
        return null;
    }

    public ContainerFramingTable(@Nullable class_3917<?> type, int windowId, class_1661 playerInventory, BlockEntityFramingTable blockEntity) {
        super(type, windowId);
        int i;
        this.blockEntity = blockEntity;
        this.tableInventory = blockEntity.inventory();
        this.craftResult = blockEntity.inventory();
        this.access = class_3914.method_17392((class_1937)blockEntity.method_10997(), (class_2338)blockEntity.method_11016());
        this.player = playerInventory.field_7546;
        this.inputSlot = this.method_7621(new RestrictedSlot(this.tableInventory, 0, 23, 35));
        this.materialSideSlot = this.method_7621(new RestrictedSlot(this.tableInventory, 1, 50, 17));
        this.materialTrimSlot = this.method_7621(new RestrictedSlot(this.tableInventory, 2, 102, 17));
        this.materialFrontSlot = this.method_7621(new RestrictedSlot(this.tableInventory, 3, 50, 53));
        this.outputSlot = this.method_7621(new CraftResultSlot(playerInventory.field_7546, this.tableInventory, this.craftResult, new int[]{0, 1, 2, 3}, 4, 133, 35));
        this.playerSlots = new ArrayList<class_1735>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<class_1735>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142)));
        }
        this.method_7609(this.tableInventory);
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).field_7874;
        int hotbarStart = this.hotbarSlots.get((int)0).field_7874;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_7874 + 1;
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            if (slotIndex == 4) {
                if (!this.method_7616(slotStack, inventoryStart, hotbarEnd, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(slotStack, itemStack);
            } else if (slotIndex == 0 || BlockEntityFramingTable.isMaterialSlot(slotIndex) ? !this.method_7616(slotStack, inventoryStart, hotbarEnd, true) : slotIndex >= inventoryStart && slotIndex < hotbarEnd && (this.blockEntity.isItemValidTarget(slotStack) ? !this.method_7616(slotStack, 0, 1, false) : (BlockEntityFramingTable.isItemValidMaterial(slotStack) ? !this.method_7616(slotStack, 1, 4, false) : (slotIndex < hotbarStart ? !this.method_7616(slotStack, hotbarStart, hotbarEnd, false) : !this.method_7616(slotStack, inventoryStart, hotbarStart, false))))) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.tableInventory.method_5443(player);
    }
}

