/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CompTierRegistry {
    public static final CompTierRegistry INSTANCE = new CompTierRegistry();
    private final List<Record> records = new ArrayList<Record>();
    private List<String> pendingRules = new ArrayList<String>();
    private boolean initialized;

    public void initialize() {
        this.initialized = true;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableExtraCompactingRules.get()).booleanValue()) {
            this.register(new class_1799((class_1935)class_2246.field_10460), new class_1799((class_1935)class_1802.field_8696), 4);
            this.register(new class_1799((class_1935)class_2246.field_10491), new class_1799((class_1935)class_1802.field_8543), 4);
            this.register(new class_1799((class_1935)class_2246.field_10171), new class_1799((class_1935)class_1802.field_8601), 4);
            this.register(new class_1799((class_1935)class_2246.field_10104), new class_1799((class_1935)class_1802.field_8621), 4);
            this.register(new class_1799((class_1935)class_2246.field_10266), new class_1799((class_1935)class_1802.field_8729), 4);
            this.register(new class_1799((class_1935)class_2246.field_10541), new class_1799((class_1935)class_1802.field_8790), 9);
            this.register(new class_1799((class_1935)class_2246.field_10153), new class_1799((class_1935)class_1802.field_8155), 4);
            this.register(new class_1799((class_1935)class_2246.field_10545), new class_1799((class_1935)class_1802.field_8497), 9);
        }
        ModCommonConfig.INSTANCE.onLoad(() -> ((List)ModCommonConfig.INSTANCE.GENERAL.compRules.get()).forEach(this::register));
        for (String rule : this.pendingRules) {
            this.register(rule);
        }
        this.pendingRules = null;
    }

    public boolean register(@NotNull class_1799 upper, @NotNull class_1799 lower, int convRate) {
        if (upper.method_7960() || lower.method_7960()) {
            return false;
        }
        this.unregisterUpperTarget(upper);
        this.unregisterLowerTarget(lower);
        Record r = new Record(upper.method_7972(), lower.method_7972(), convRate);
        r.upper.method_7939(1);
        r.lower.method_7939(1);
        this.records.add(r);
        ModServices.log.info("New compacting rule " + convRate + " " + lower.method_7909().toString() + " = 1 " + upper.method_7909().toString());
        return true;
    }

    public static boolean validateRuleSyntax(String rule) {
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        class_2960 upperResource = class_2960.method_12829((String)parts[0]);
        class_2960 lowerResource = class_2960.method_12829((String)parts[1]);
        if (upperResource == null || lowerResource == null) {
            return false;
        }
        try {
            int conv = Integer.parseInt(parts[2]);
            return conv >= 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void register(List<String> rules) {
        rules.forEach(this::register);
    }

    public boolean register(String rule) {
        if (!this.initialized) {
            this.pendingRules.add(rule);
            return true;
        }
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        class_2960 upperResource = new class_2960(parts[0]);
        class_1792 upperItem = (class_1792)class_7923.field_41178.method_10223(upperResource);
        class_2960 lowerResource = new class_2960(parts[1]);
        class_1792 lowerItem = (class_1792)class_7923.field_41178.method_10223(lowerResource);
        try {
            int conv = Integer.parseInt(parts[2]);
            return this.register(new class_1799((class_1935)upperItem), new class_1799((class_1935)lowerItem), conv);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean unregisterUpperTarget(@NotNull class_1799 stack) {
        for (Record r : this.records) {
            if (!class_1799.method_7973((class_1799)stack, (class_1799)r.upper)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public boolean unregisterLowerTarget(@NotNull class_1799 stack) {
        for (Record r : this.records) {
            if (!class_1799.method_7973((class_1799)stack, (class_1799)r.lower)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public Record findHigherTier(@NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        for (Record r : this.records) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)r.lower)) continue;
            return r;
        }
        return null;
    }

    public Record findLowerTier(@NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        for (Record r : this.records) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)r.upper)) continue;
            return r;
        }
        return null;
    }

    public static class Record {
        @NotNull
        public final class_1799 upper;
        @NotNull
        public final class_1799 lower;
        public final int convRate;

        public Record(@NotNull class_1799 upper, @NotNull class_1799 lower, int convRate) {
            this.upper = upper;
            this.lower = lower;
            this.convRate = convRate;
        }
    }
}

