/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2680;

public class CombinedModelDecorator<C extends ModelContext>
extends ModelDecorator<C> {
    private final List<ModelDecorator<C>> decorators = new ArrayList<ModelDecorator<C>>();

    public void add(ModelDecorator<C> decorator) {
        this.decorators.add(decorator);
    }

    @Override
    public boolean shouldRenderItem() {
        for (ModelDecorator<C> decorator : this.decorators) {
            if (!decorator.shouldRenderItem()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier) {
        for (ModelDecorator<C> decorator : this.decorators) {
            if (decorator.shouldRenderBase(contextSupplier)) continue;
            return false;
        }
        return super.shouldRenderBase(contextSupplier);
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier, class_1799 stack) {
        for (ModelDecorator<C> decorator : this.decorators) {
            if (decorator.shouldRenderBase(contextSupplier, stack)) continue;
            return false;
        }
        return super.shouldRenderBase(contextSupplier, stack);
    }

    @Override
    public List<class_1921> getRenderTypes(class_2680 state) {
        if (this.decorators.isEmpty()) {
            return super.getRenderTypes(state);
        }
        if (this.decorators.size() == 1) {
            return this.decorators.get(0).getRenderTypes(state);
        }
        ArrayList<class_1921> types = new ArrayList<class_1921>(this.decorators.get(0).getRenderTypes(state));
        for (int i = 1; i < this.decorators.size(); ++i) {
            for (class_1921 type : this.decorators.get(i).getRenderTypes(state)) {
                if (types.contains(type)) continue;
                types.add(type);
            }
        }
        return types;
    }

    @Override
    public List<class_1921> getRenderTypes(class_1799 stack) {
        if (this.decorators.isEmpty()) {
            return super.getRenderTypes(stack);
        }
        if (this.decorators.size() == 1) {
            return this.decorators.get(0).getRenderTypes(stack);
        }
        ArrayList<class_1921> types = new ArrayList<class_1921>(this.decorators.get(0).getRenderTypes(stack));
        for (int i = 1; i < this.decorators.size(); ++i) {
            for (class_1921 type : this.decorators.get(i).getRenderTypes(stack)) {
                if (types.contains(type)) continue;
                types.add(type);
            }
        }
        return types;
    }

    @Override
    public void emitQuads(Supplier<C> contextSupplier, BiConsumer<class_1087, class_1921> emitModel) {
        for (ModelDecorator<C> decorator : this.decorators) {
            decorator.emitQuads(contextSupplier, emitModel);
        }
    }

    @Override
    public void emitItemQuads(Supplier<C> contextSupplier, BiConsumer<class_1087, class_1921> emitModel, class_1799 stack) {
        for (ModelDecorator<C> decorator : this.decorators) {
            decorator.emitItemQuads(contextSupplier, emitModel, stack);
        }
    }
}

