/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class MaterialData
extends BlockEntityDataShim
implements IFramedMaterials {
    @NotNull
    private class_1799 frameBase;
    @NotNull
    private class_1799 materialSide;
    @NotNull
    private class_1799 materialFront;
    @NotNull
    private class_1799 materialTrim;

    public MaterialData() {
        this(class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037);
    }

    public MaterialData(@NotNull class_1799 frameBase, @NotNull class_1799 side, @NotNull class_1799 front, @NotNull class_1799 trim) {
        this.frameBase = frameBase;
        this.materialSide = side;
        this.materialFront = front;
        this.materialTrim = trim;
    }

    public MaterialData(IFramedMaterials materials) {
        this();
        if (materials != null) {
            this.frameBase = materials.getHostBlock();
            this.materialSide = materials.getMaterial(FrameMaterial.SIDE);
            this.materialFront = materials.getMaterial(FrameMaterial.FRONT);
            this.materialTrim = materials.getMaterial(FrameMaterial.TRIM);
        }
    }

    @NotNull
    public class_1799 getFrameBase() {
        return this.frameBase;
    }

    @NotNull
    public class_1799 getSide() {
        return this.materialSide;
    }

    @NotNull
    public class_1799 getFront() {
        return this.materialFront;
    }

    @NotNull
    public class_1799 getTrim() {
        return this.materialTrim;
    }

    @NotNull
    public class_1799 getEffectiveSide() {
        return this.materialSide;
    }

    @NotNull
    public class_1799 getEffectiveFront() {
        return !this.materialFront.method_7960() ? this.materialFront : this.materialSide;
    }

    @NotNull
    public class_1799 getEffectiveTrim() {
        return !this.materialTrim.method_7960() ? this.materialTrim : this.materialSide;
    }

    public void setFrameBase(@NotNull class_1799 frameBase) {
        this.frameBase = frameBase;
    }

    public void setSide(@NotNull class_1799 material) {
        this.materialSide = material;
    }

    public void setFront(@NotNull class_1799 material) {
        this.materialFront = material;
    }

    public void setTrim(@NotNull class_1799 material) {
        this.materialTrim = material;
    }

    public void clear() {
        this.materialSide = class_1799.field_8037;
        this.materialFront = class_1799.field_8037;
        this.materialTrim = class_1799.field_8037;
    }

    public boolean isEmpty() {
        return this.materialFront.method_7960() && this.materialSide.method_7960() && this.materialTrim.method_7960();
    }

    @Override
    public void read(class_2487 tag) {
        this.frameBase = class_1799.field_8037;
        if (tag.method_10545("MatB")) {
            this.frameBase = class_1799.method_7915((class_2487)tag.method_10562("MatB"));
        }
        this.materialSide = class_1799.field_8037;
        if (tag.method_10545("MatS")) {
            this.materialSide = class_1799.method_7915((class_2487)tag.method_10562("MatS"));
        }
        this.materialFront = class_1799.field_8037;
        if (tag.method_10545("MatF")) {
            this.materialFront = class_1799.method_7915((class_2487)tag.method_10562("MatF"));
        }
        this.materialTrim = class_1799.field_8037;
        if (tag.method_10545("MatT")) {
            this.materialTrim = class_1799.method_7915((class_2487)tag.method_10562("MatT"));
        }
    }

    @Override
    public class_2487 write(class_2487 tag) {
        class_2487 itag;
        if (!this.frameBase.method_7960()) {
            itag = new class_2487();
            this.frameBase.method_7953(itag);
            tag.method_10566("MatB", (class_2520)itag);
        } else if (tag.method_10545("MatB")) {
            tag.method_10551("MatB");
        }
        if (!this.materialSide.method_7960()) {
            itag = new class_2487();
            this.materialSide.method_7953(itag);
            tag.method_10566("MatS", (class_2520)itag);
        } else if (tag.method_10545("MatS")) {
            tag.method_10551("MatS");
        }
        if (!this.materialFront.method_7960()) {
            itag = new class_2487();
            this.materialFront.method_7953(itag);
            tag.method_10566("MatF", (class_2520)itag);
        } else if (tag.method_10545("MatF")) {
            tag.method_10551("MatF");
        }
        if (!this.materialTrim.method_7960()) {
            itag = new class_2487();
            this.materialTrim.method_7953(itag);
            tag.method_10566("MatT", (class_2520)itag);
        } else if (tag.method_10545("MatT")) {
            tag.method_10551("MatT");
        }
        return tag;
    }

    @Override
    @NotNull
    public class_1799 getHostBlock() {
        return this.frameBase;
    }

    @Override
    public void setHostBlock(@NotNull class_1799 stack) {
        this.frameBase = stack;
    }

    @Override
    @NotNull
    public class_1799 getMaterial(FrameMaterial material) {
        return switch (material) {
            default -> throw new IncompatibleClassChangeError();
            case FrameMaterial.SIDE -> this.materialSide;
            case FrameMaterial.TRIM -> this.materialTrim;
            case FrameMaterial.FRONT -> this.materialFront;
        };
    }

    @Override
    public void setMaterial(FrameMaterial material, @NotNull class_1799 stack) {
        switch (material) {
            case SIDE: {
                this.materialSide = stack;
                break;
            }
            case TRIM: {
                this.materialTrim = stack;
                break;
            }
            case FRONT: {
                this.materialFront = stack;
            }
        }
    }
}

