/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.dungeonz.DungeonzMain;
import net.dungeonz.access.ServerPlayerAccess;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.dungeon.DungeonPlacementHandler;
import net.dungeonz.init.DimensionInit;
import net.dungeonz.network.DungeonServerPacket;
import net.dungeonz.util.InventoryHelper;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5454;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import net.partyaddon.access.GroupManagerAccess;
import net.partyaddon.group.GroupManager;
import org.jetbrains.annotations.Nullable;

public class DungeonHelper {
    @Nullable
    public static Dungeon getCurrentDungeon(class_3222 playerEntity) {
        if (playerEntity != null && playerEntity.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD && ((ServerPlayerAccess)playerEntity).getOldServerWorld() != null) {
            class_2586 blockEntity = ((ServerPlayerAccess)playerEntity).getOldServerWorld().method_8321(((ServerPlayerAccess)playerEntity).getDungeonPortalBlockPos());
            if (blockEntity == null) {
                return null;
            }
            if (blockEntity instanceof DungeonPortalEntity) {
                DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)blockEntity;
                return dungeonPortalEntity.getDungeon();
            }
        }
        return null;
    }

    @Nullable
    public static DungeonPortalEntity getDungeonPortalEntity(class_3222 playerEntity) {
        if (((ServerPlayerAccess)playerEntity).getOldServerWorld() != null) {
            class_2586 blockEntity = ((ServerPlayerAccess)playerEntity).getOldServerWorld().method_8321(((ServerPlayerAccess)playerEntity).getDungeonPortalBlockPos());
            if (blockEntity == null) {
                return null;
            }
            if (blockEntity instanceof DungeonPortalEntity) {
                DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)blockEntity;
                return dungeonPortalEntity;
            }
        }
        return null;
    }

    public static List<class_1799> getRequiredItemStackList(Dungeon dungeon) {
        ArrayList<class_1799> requiredItemStackList = new ArrayList<class_1799>();
        for (Map.Entry<Integer, Integer> entry : dungeon.getRequiredItemCountMap().entrySet()) {
            requiredItemStackList.add(new class_1799((class_1935)class_7923.field_41178.method_10200(entry.getKey().intValue()), entry.getValue().intValue()));
        }
        return requiredItemStackList;
    }

    public static Map<String, List<class_1799>> getPossibleLootItemStackMap(Dungeon dungeon, MinecraftServer server) {
        HashMap<String, List<class_1799>> possibleLootItemStackMap = new HashMap<String, List<class_1799>>();
        for (Map.Entry<String, String> entry : dungeon.getDifficultyBossLootTableMap().entrySet()) {
            class_52 lootTable = server.method_3857().getLootTable(new class_2960(entry.getValue()));
            class_8567.class_8568 builder = new class_8567.class_8568(server.method_30002()).method_51874(class_181.field_24424, (Object)((class_3222)server.method_30002().method_18456().get(server.method_30002().method_8409().method_43048(server.method_30002().method_18456().size()))).method_19538());
            class_1277 inventory = new class_1277(27);
            lootTable.method_329((class_1263)inventory, builder.method_51875(class_173.field_1179), server.method_30002().method_8409().method_43055());
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (inventory.method_5438(i).method_7960()) continue;
                if (inventory.method_5438(i).method_7986()) {
                    inventory.method_5438(i).method_7974(0);
                }
                boolean contains = false;
                for (int u = 0; u < itemStacks.size(); ++u) {
                    if (!class_1799.method_7984((class_1799)((class_1799)itemStacks.get(u)), (class_1799)inventory.method_5438(i))) continue;
                    ((class_1799)itemStacks.get(u)).method_7933(inventory.method_5438(i).method_7947());
                    contains = true;
                    break;
                }
                if (contains) continue;
                itemStacks.add(inventory.method_5438(i));
            }
            possibleLootItemStackMap.put(entry.getKey(), itemStacks);
        }
        return possibleLootItemStackMap;
    }

    public static void teleportDungeon(class_3222 player, class_2338 dungeonPortalPos, @Nullable UUID requiredMinGroupUuid) {
        class_2586 class_25862;
        if (player.method_37908().method_8321(dungeonPortalPos) != null && (class_25862 = player.method_37908().method_8321(dungeonPortalPos)) instanceof DungeonPortalEntity) {
            DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)class_25862;
            if (player.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD) {
                class_3218 oldWorld = ((ServerPlayerAccess)player).getOldServerWorld();
                if (oldWorld != null) {
                    FabricDimensions.teleport((class_1297)player, (class_3218)oldWorld, (class_5454)DungeonPlacementHandler.leave(player, oldWorld));
                    return;
                }
            } else {
                class_3218 dungeonWorld = player.method_37908().method_8503().method_3847(DimensionInit.DUNGEON_WORLD);
                if (dungeonWorld == null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Failed to find world, was it registered?"), false);
                    return;
                }
                if (dungeonPortalEntity.getDungeon() != null) {
                    if (dungeonPortalEntity.getDungeonPlayerCount() + dungeonPortalEntity.getDeadDungeonPlayerUUIDs().size() < dungeonPortalEntity.getMaxGroupSize()) {
                        if (dungeonPortalEntity.isOnCooldown((int)dungeonWorld.method_8510())) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_cooldown"), false);
                            return;
                        }
                        if (dungeonPortalEntity.getDungeonPlayerCount() > 0 && dungeonPortalEntity.getPrivateGroup()) {
                            if (DungeonzMain.isPartyAddonLoaded) {
                                GroupManager groupManager = ((GroupManagerAccess)player).getGroupManager();
                                if (groupManager.getGroupPlayerIdList().isEmpty() || !groupManager.getGroupPlayerIdList().contains(dungeonPortalEntity.getDungeonPlayerUuids().get(0))) {
                                    player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_private"), false);
                                    return;
                                }
                            } else {
                                player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_private"), false);
                                return;
                            }
                        }
                        if (!player.method_7337()) {
                            if (InventoryHelper.hasRequiredItemStacks(player.method_31548(), DungeonHelper.getRequiredItemStackList(dungeonPortalEntity.getDungeon()))) {
                                InventoryHelper.decrementRequiredItemStacks(player.method_31548(), DungeonHelper.getRequiredItemStackList(dungeonPortalEntity.getDungeon()));
                            } else {
                                player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.missing"), false);
                                return;
                            }
                        }
                        if (!dungeonPortalEntity.getWaitingUuids().isEmpty() && dungeonPortalEntity.getWaitingUuids().contains(player.method_5667())) {
                            player.method_7346();
                            return;
                        }
                        if (dungeonPortalEntity.getDungeonPlayerCount() <= 0 && requiredMinGroupUuid != null && dungeonPortalEntity.getMinGroupSize() > 1) {
                            dungeonPortalEntity.addWaitingUuid(requiredMinGroupUuid);
                            if (dungeonPortalEntity.getMinGroupSize() > dungeonPortalEntity.getWaitingUuids().size()) {
                                player.method_7353((class_2561)class_2561.method_43469((String)"text.dungeonz.dungeon_min_group_size", (Object[])new Object[]{dungeonPortalEntity.getMinGroupSize() - dungeonPortalEntity.getWaitingUuids().size()}), false);
                                return;
                            }
                            if (dungeonPortalEntity.getdungeonTeleportCountdown() <= 0) {
                                dungeonPortalEntity.startDungeonTeleportCountdown(dungeonWorld);
                                player.method_7346();
                            }
                        } else if (dungeonPortalEntity.getDungeonPlayerCount() <= 0 && dungeonPortalEntity.getdungeonTeleportCountdown() <= 0) {
                            dungeonPortalEntity.addWaitingUuid(requiredMinGroupUuid);
                            dungeonPortalEntity.startDungeonTeleportCountdown(dungeonWorld);
                            player.method_7346();
                        } else if (dungeonPortalEntity.getdungeonTeleportCountdown() > 0) {
                            dungeonPortalEntity.addWaitingUuid(requiredMinGroupUuid);
                            player.method_7346();
                        } else if (!dungeonPortalEntity.getDeadDungeonPlayerUUIDs().contains(player.method_5667()) || dungeonPortalEntity.getDungeon().isRespawnAllowed()) {
                            DungeonHelper.teleportPlayer(player, dungeonWorld, dungeonPortalEntity, dungeonPortalPos);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dead_player"), false);
                            player.method_7346();
                        }
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_full"), false);
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_missing"), false);
                }
            }
        }
    }

    public static void teleportPlayer(class_3222 serverPlayerEntity, class_3218 dungeonWorld, DungeonPortalEntity dungeonPortalEntity, class_2338 dungeonPortalPos) {
        class_3222 playerEntity = (class_3222)FabricDimensions.teleport((class_1297)serverPlayerEntity, (class_3218)dungeonWorld, (class_5454)DungeonPlacementHandler.enter(serverPlayerEntity, dungeonWorld, serverPlayerEntity.method_51469(), dungeonPortalEntity, dungeonPortalPos, dungeonPortalEntity.getDifficulty(), dungeonPortalEntity.getDisableEffects()));
        DungeonServerPacket.writeS2CDungeonInfoPacket(playerEntity, dungeonPortalEntity.getDungeon().getBreakableBlockIdList(), dungeonPortalEntity.getDungeon().getplaceableBlockIdList(), dungeonPortalEntity.getDungeon().isElytraAllowed());
    }

    public static void teleportOutOfDungeon(class_3222 player) {
        class_3218 oldWorld = ((ServerPlayerAccess)player).getOldServerWorld();
        if (oldWorld != null) {
            FabricDimensions.teleport((class_1297)player, (class_3218)oldWorld, (class_5454)DungeonPlacementHandler.leave(player, oldWorld));
        } else {
            class_243 spawnPos = null;
            spawnPos = player.method_26280() != null ? new class_243((double)player.method_26280().method_10263(), (double)player.method_26280().method_10264(), (double)player.method_26280().method_10260()) : (class_243)class_1657.method_26091((class_3218)player.field_13995.method_3847(player.method_26281()), (class_2338)((ServerPlayerAccess)player).getDungeonSpawnBlockPos(), (float)0.0f, (boolean)true, (boolean)true).get();
            FabricDimensions.teleport((class_1297)player, (class_3218)player.field_13995.method_3847(player.method_26281()), (class_5454)new class_5454(spawnPos, new class_243(0.0, 0.0, 0.0), 0.0f, 0.0f));
        }
    }
}

