/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.dungeonz.DungeonzMain;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.init.ConfigInit;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DungeonLoader
implements SimpleSynchronousResourceReloadListener {
    public class_2960 getFabricId() {
        return new class_2960("dungeonz", "dungeon_loader");
    }

    public void method_14491(class_3300 manager) {
        manager.method_14488("dungeon", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                String dungeonTypeId = data.get("dungeon_type").getAsString();
                if (!ConfigInit.CONFIG.defaultDungeons && (dungeonTypeId.equals("dark_dungeon") || dungeonTypeId.equals("jungle_dungeon"))) {
                    return;
                }
                int maxGroupSize = data.get("max_group_size").getAsInt();
                int minGroupSize = data.has("min_group_size") ? data.get("min_group_size").getAsInt() : 0;
                int cooldown = data.get("cooldown").getAsInt();
                boolean allowElytra = data.has("elytra") ? data.get("elytra").getAsBoolean() : false;
                boolean allowRespawn = data.has("respawn") ? data.get("respawn").getAsBoolean() : true;
                class_2960 dungeonBackgroundId = new class_2960(data.has("background_texture") ? data.get("background_texture").getAsString() : "");
                class_2960 dungeonStructurePoolId = new class_2960(data.get("dungeon_structure_pool_id").getAsString());
                ArrayList<String> difficulties = new ArrayList<String>();
                JsonObject difficultyObject = data.get("difficulty").getAsJsonObject();
                Iterator difficultyIterator = difficultyObject.keySet().iterator();
                HashMap<String, Float> difficultyMobModificator = new HashMap<String, Float>();
                HashMap<String, List<String>> difficultyLootTableIds = new HashMap<String, List<String>>();
                HashMap<String, Float> difficultyBossModificator = new HashMap<String, Float>();
                HashMap<String, String> difficultyBossLootTable = new HashMap<String, String>();
                while (difficultyIterator.hasNext()) {
                    String difficulty = (String)difficultyIterator.next();
                    difficulties.add(difficulty);
                    JsonObject specificDifficultyObject = difficultyObject.get(difficulty).getAsJsonObject();
                    difficultyMobModificator.put(difficulty, Float.valueOf(specificDifficultyObject.get("mob_modificator").getAsFloat()));
                    ArrayList<String> lootTableIds = new ArrayList<String>();
                    for (int i = 0; i < specificDifficultyObject.get("loot_table_ids").getAsJsonArray().size(); ++i) {
                        lootTableIds.add(specificDifficultyObject.get("loot_table_ids").getAsJsonArray().get(i).getAsString());
                    }
                    difficultyLootTableIds.put(difficulty, lootTableIds);
                    difficultyBossModificator.put(difficulty, Float.valueOf(specificDifficultyObject.get("boss_modificator").getAsFloat()));
                    difficultyBossLootTable.put(difficulty, specificDifficultyObject.get("boss_loot_table_id").getAsString());
                }
                JsonObject blockObject = data.get("blocks").getAsJsonObject();
                Iterator blockIterator = blockObject.keySet().iterator();
                HashMap blockIdEntityMap = new HashMap();
                HashMap<Integer, HashMap<String, Float>> blockIdEntitySpawnChance = new HashMap<Integer, HashMap<String, Float>>();
                HashMap<Integer, Integer> blockIdBlockReplacement = new HashMap<Integer, Integer>();
                int bossBlockId = -1;
                int bossLootBlockId = -1;
                int exitBlockId = -1;
                class_1299 bossEntityType = null;
                class_2487 bossNbtCompound = null;
                while (blockIterator.hasNext()) {
                    String block = (String)blockIterator.next();
                    if (((class_2248)class_7923.field_41175.method_10223(new class_2960(block))).toString().equals("Block{minecraft:air}")) {
                        DungeonzMain.LOGGER.warn("{} is not a valid block identifier", (Object)block);
                        continue;
                    }
                    int rawBlockId = class_7923.field_41175.method_10206((Object)((class_2248)class_7923.field_41175.method_10223(new class_2960(block))));
                    JsonObject specificBlockObject = blockObject.get(block).getAsJsonObject();
                    if (specificBlockObject.has("spawns")) {
                        ArrayList<class_1299> entityTypes = new ArrayList<class_1299>();
                        for (int i = 0; i < specificBlockObject.get("spawns").getAsJsonArray().size(); ++i) {
                            if (!class_7923.field_41177.method_10250(new class_2960(specificBlockObject.get("spawns").getAsJsonArray().get(i).getAsString()))) {
                                DungeonzMain.LOGGER.warn("{} is not a valid entity identifier", (Object)specificBlockObject.get("spawns").getAsJsonArray().get(i).getAsString());
                                continue;
                            }
                            entityTypes.add((class_1299)class_7923.field_41177.method_10223(new class_2960(specificBlockObject.get("spawns").getAsJsonArray().get(i).getAsString())));
                        }
                        blockIdEntityMap.put(rawBlockId, entityTypes);
                        HashMap<String, Float> difficultyChance = new HashMap<String, Float>();
                        for (int i = 0; i < difficulties.size(); ++i) {
                            difficultyChance.put((String)difficulties.get(i), Float.valueOf(specificBlockObject.get("chance").getAsJsonObject().get((String)difficulties.get(i)).getAsFloat()));
                        }
                        blockIdEntitySpawnChance.put(rawBlockId, difficultyChance);
                    } else if (specificBlockObject.has("boss_entity")) {
                        if (!class_7923.field_41177.method_10250(new class_2960(specificBlockObject.get("boss_entity").getAsString()))) {
                            DungeonzMain.LOGGER.warn("{} is not a valid entity identifier", (Object)specificBlockObject.get("boss_entity").getAsString());
                        }
                        bossEntityType = (class_1299)class_7923.field_41177.method_10223(new class_2960(specificBlockObject.get("boss_entity").getAsString()));
                        bossNbtCompound = DungeonLoader.tryReadNbtData(specificBlockObject);
                        bossBlockId = rawBlockId;
                    } else if (specificBlockObject.has("exit_block") && specificBlockObject.get("exit_block").getAsBoolean()) {
                        exitBlockId = rawBlockId;
                    } else if (specificBlockObject.has("boss_loot_block") && specificBlockObject.get("boss_loot_block").getAsBoolean()) {
                        bossLootBlockId = rawBlockId;
                    } else {
                        DungeonzMain.LOGGER.warn("{} has no set spawns nor exit block nor boss loot block nor boss entity", blockIterator);
                    }
                    if (!specificBlockObject.get("replace").isJsonNull()) {
                        class_2960 blockIdentifier = new class_2960(specificBlockObject.get("replace").getAsString());
                        if (!blockIdentifier.toString().equals("minecraft:air") && ((class_2248)class_7923.field_41175.method_10223(blockIdentifier)).toString().equals("Block{minecraft:air}")) {
                            DungeonzMain.LOGGER.warn("{} is not a valid block identifier", (Object)specificBlockObject.get("replace").getAsString());
                            continue;
                        }
                        blockIdBlockReplacement.put(rawBlockId, class_7923.field_41175.method_10206((Object)((class_2248)class_7923.field_41175.method_10223(blockIdentifier))));
                        continue;
                    }
                    blockIdBlockReplacement.put(rawBlockId, -1);
                }
                JsonObject spawnerObject = data.get("spawner").getAsJsonObject();
                Iterator spawnerIterator = spawnerObject.keySet().iterator();
                HashMap<Integer, Integer> spawnerEntityIdCountMap = new HashMap<Integer, Integer>();
                while (spawnerIterator.hasNext()) {
                    String entityString = (String)spawnerIterator.next();
                    class_2960 entityIdentifier = new class_2960(entityString);
                    if (((class_1299)class_7923.field_41177.method_10223(entityIdentifier)).toString().equals("entity.minecraft.pig")) {
                        DungeonzMain.LOGGER.warn("{} is not a valid entity identifier", (Object)entityString);
                        continue;
                    }
                    spawnerEntityIdCountMap.put(class_7923.field_41177.method_10206((Object)((class_1299)class_7923.field_41177.method_10223(entityIdentifier))), spawnerObject.get(entityString).getAsInt());
                }
                ArrayList<Integer> breakableBlockIds = new ArrayList<Integer>();
                if (data.has("breakable")) {
                    for (int i = 0; i < data.get("breakable").getAsJsonArray().size(); ++i) {
                        class_2960 blockIdentifier = new class_2960(data.get("breakable").getAsJsonArray().get(i).getAsString());
                        if (((class_2248)class_7923.field_41175.method_10223(blockIdentifier)).toString().equals("Block{minecraft:air}")) {
                            DungeonzMain.LOGGER.warn("{} is not a valid block identifier", (Object)data.get("breakable").getAsJsonArray().get(i).getAsString());
                            continue;
                        }
                        breakableBlockIds.add(class_7923.field_41175.method_10206((Object)((class_2248)class_7923.field_41175.method_10223(blockIdentifier))));
                    }
                }
                ArrayList<Integer> placeableBlockIds = new ArrayList<Integer>();
                if (data.has("placeable")) {
                    for (int i = 0; i < data.get("placeable").getAsJsonArray().size(); ++i) {
                        class_2960 blockIdentifier = new class_2960(data.get("placeable").getAsJsonArray().get(i).getAsString());
                        if (((class_2248)class_7923.field_41175.method_10223(blockIdentifier)).toString().equals("Block{minecraft:air}")) {
                            DungeonzMain.LOGGER.warn("{} is not a valid block identifier", (Object)data.get("placeable").getAsJsonArray().get(i).getAsString());
                            continue;
                        }
                        placeableBlockIds.add(class_7923.field_41175.method_10206((Object)((class_2248)class_7923.field_41175.method_10223(blockIdentifier))));
                    }
                }
                JsonObject requiredObject = data.get("required").getAsJsonObject();
                Iterator requiredIterator = requiredObject.keySet().iterator();
                HashMap<Integer, Integer> requiredItemCountMap = new HashMap<Integer, Integer>();
                while (requiredIterator.hasNext()) {
                    String itemString = (String)requiredIterator.next();
                    class_2960 itemIdentifier = new class_2960(itemString);
                    if (((class_1792)class_7923.field_41178.method_10223(itemIdentifier)).toString().equals("air")) {
                        DungeonzMain.LOGGER.warn("{} is not a valid item identifier", (Object)itemString);
                        continue;
                    }
                    requiredItemCountMap.put(class_7923.field_41178.method_10206((Object)((class_1792)class_7923.field_41178.method_10223(itemIdentifier))), requiredObject.get(itemString).getAsInt());
                }
                if (bossEntityType == null) {
                    DungeonzMain.LOGGER.warn("{} has no set boss", (Object)data);
                    return;
                }
                Dungeon.addDungeon(new Dungeon(dungeonTypeId, blockIdEntityMap, blockIdEntitySpawnChance, blockIdBlockReplacement, spawnerEntityIdCountMap, requiredItemCountMap, breakableBlockIds, placeableBlockIds, difficultyMobModificator, difficultyLootTableIds, difficultyBossModificator, difficultyBossLootTable, bossEntityType, bossNbtCompound, bossBlockId, bossLootBlockId, exitBlockId, allowRespawn, allowElytra, maxGroupSize, minGroupSize, cooldown, dungeonBackgroundId, dungeonStructurePoolId));
            }
            catch (Exception e) {
                DungeonzMain.LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
    }

    @Nullable
    private static class_2487 tryReadNbtData(JsonObject json) {
        if (json.has("data") && json.get("data") != null && !json.get("data").getAsString().equals("")) {
            try {
                return new class_2522(new StringReader(json.get("data").getAsString())).method_10727();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                throw new JsonParseException("Failed to load nbt data of json object " + json);
            }
        }
        return null;
    }
}

