/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.BlockEntityBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.packets.PacketScreenSetChannel;
import com.supermartijn642.tesseract.screen.PlayerRenderer;
import com.supermartijn642.tesseract.screen.RedstoneButton;
import com.supermartijn642.tesseract.screen.TesseractAddChannelScreen;
import com.supermartijn642.tesseract.screen.TesseractButton;
import com.supermartijn642.tesseract.screen.TesseractRemoveChannelScreen;
import com.supermartijn642.tesseract.screen.TransferButton;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class TesseractScreen
extends BlockEntityBaseWidget<TesseractBlockEntity> {
    private static final int MAX_DISPLAYED_CHANNELS = 12;
    private static final int CHANNEL_CUTOFF_LENGTH = 100;
    private static final class_2960 BACKGROUND = new class_2960("tesseract", "textures/gui/new_gui.png");
    private static final int BACKGROUND_WIDTH = 249;
    private static final int BACKGROUND_HEIGHT = 211;
    private static final class_2960 CHANNEL_BACKGROUND = new class_2960("tesseract", "textures/gui/background.png");
    private static final class_2960 TAB_ON = new class_2960("tesseract", "textures/gui/tab_new.png");
    private static final class_2960 TAB_OFF = new class_2960("tesseract", "textures/gui/tab_off_new.png");
    private static final class_2960 ITEM_ICON = new class_2960("tesseract", "textures/gui/item_tab_icon.png");
    private static final class_2960 ENERGY_ICON = new class_2960("tesseract", "textures/gui/energy_tab_icon.png");
    private static final class_2960 FLUID_ICON = new class_2960("tesseract", "textures/gui/fluid_tab_icon.png");
    private static final class_2960 SCROLL_BUTTONS = new class_2960("minecraft", "textures/gui/server_selection.png");
    public static final class_2960 LOCK_ON = new class_2960("tesseract", "textures/gui/lock_on.png");
    public static final class_2960 LOCK_OFF = new class_2960("tesseract", "textures/gui/lock_off.png");
    private static final class_2960 REDSTONE_TAB = new class_2960("tesseract", "textures/gui/redstone_tab.png");
    private static final class_2960 SIDE_TAB = new class_2960("tesseract", "textures/gui/side_tab_new.png");
    private static final class_2960 CHECKMARK = new class_2960("tesseract", "textures/gui/checkmark_icon.png");
    private static EnumChannelType type = EnumChannelType.ITEMS;
    private TesseractButton setButton;
    private TesseractButton removeButton;
    private TransferButton transferButton;
    private RedstoneButton redstoneButton;
    private int selectedChannel = -1;
    private int scrollOffset = 0;

    public TesseractScreen(class_1937 level, class_2338 pos) {
        super(0, 0, 249, 211, level, pos);
    }

    protected void addWidgets(TesseractBlockEntity entity) {
        this.setButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(113, 185, 61, 18, (class_2561)TextComponents.translation((String)"gui.tesseract.set").get(), () -> {
            if (this.object != null) {
                if (((TesseractBlockEntity)((Object)((Object)this.object))).getChannelId(type) == this.selectedChannel) {
                    Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenSetChannel(type, -1, this.blockEntityPos));
                    this.setButton.setText((class_2561)TextComponents.translation((String)"gui.tesseract.set").get());
                } else {
                    Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenSetChannel(type, this.selectedChannel, this.blockEntityPos));
                    this.setButton.setText((class_2561)TextComponents.translation((String)"gui.tesseract.unset").get());
                }
            }
        }));
        this.setButton.active = false;
        this.removeButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(180, 185, 61, 18, (class_2561)TextComponents.translation((String)"gui.tesseract.remove").get(), () -> {
            Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, this.selectedChannel);
            if (channel != null && (channel.creator.equals(ClientUtils.getPlayer().method_5667()) || ClientUtils.getPlayer().method_5687(2) && class_437.method_25442())) {
                ClientUtils.displayScreen((class_437)WidgetScreen.of((Widget)new TesseractRemoveChannelScreen(this.blockEntityLevel, this.blockEntityPos, type, this.selectedChannel)));
            }
        }));
        this.removeButton.setRedBackground();
        this.removeButton.active = false;
        this.addWidget((Widget)new TesseractButton(29, 190, 50, 10, (class_2561)TextComponents.translation((String)"gui.tesseract.add").get(), () -> ClientUtils.displayScreen((class_437)WidgetScreen.of((Widget)new TesseractAddChannelScreen(this.blockEntityLevel, this.blockEntityPos, type)))));
        this.transferButton = (TransferButton)this.addWidget((Widget)new TransferButton(-21, 156));
        this.transferButton.update(entity, type);
        this.redstoneButton = (RedstoneButton)this.addWidget((Widget)new RedstoneButton(-25, 37));
        this.redstoneButton.update(entity);
        super.addWidgets((Object)entity);
    }

    protected void update(TesseractBlockEntity entity) {
        this.transferButton.update(entity, type);
        this.redstoneButton.update(entity);
        super.update((Object)entity);
    }

    protected void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, TesseractBlockEntity object) {
        this.setFocused(true);
        super.renderBackground(context, mouseX, mouseY, (Object)object);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY, TesseractBlockEntity entity) {
        GlStateManager._enableBlend();
        ScreenUtils.bindTexture((class_2960)BACKGROUND);
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        class_5250 s = TextComponents.translation((String)("gui.tesseract." + type.name().toLowerCase(Locale.ROOT))).get();
        ScreenUtils.drawCenteredString((class_4587)context.poseStack(), (class_2561)s, (float)177.0f, (float)14.0f, (int)-1);
        this.drawTabs(context);
        this.drawChannels(context.poseStack(), mouseX, mouseY, entity);
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, this.selectedChannel);
        if (channel != null) {
            this.drawSelectedChannelInfo(context.poseStack(), channel);
        }
        super.render(context, mouseX, mouseY, (Object)entity);
    }

    protected void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY, TesseractBlockEntity entity) {
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
        for (int i = 0; i < 12 && i + this.scrollOffset < channels.size(); ++i) {
            String creatorName;
            Channel channel = channels.get(i + this.scrollOffset);
            int x = entity.getChannelId(type) == channel.id ? 17 : 5;
            int y = 31 + i * 13;
            if (mouseX < x || mouseX >= x + 9 || mouseY < y + 2 || mouseY >= y + 11 || (creatorName = PlayerRenderer.getPlayerUsername(channel.creator)) == null) continue;
            ScreenUtils.drawTooltip((class_4587)context.poseStack(), (String)creatorName, (int)mouseX, (int)mouseY);
        }
        if (mouseX >= 9 && mouseX < 31 && mouseY >= (type == EnumChannelType.ITEMS ? 2 : 4) && mouseY < 28) {
            ScreenUtils.drawTooltip((class_4587)context.poseStack(), (class_2561)EnumChannelType.ITEMS.getTranslation(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 38 && mouseX < 60 && mouseY >= (type == EnumChannelType.ENERGY ? 2 : 4) && mouseY < 28) {
            ScreenUtils.drawTooltip((class_4587)context.poseStack(), (class_2561)EnumChannelType.ENERGY.getTranslation(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 67 && mouseX < 89 && mouseY >= (type == EnumChannelType.FLUID ? 2 : 4) && mouseY < 28) {
            ScreenUtils.drawTooltip((class_4587)context.poseStack(), (class_2561)EnumChannelType.FLUID.getTranslation(), (int)mouseX, (int)mouseY);
        }
        super.renderTooltips(context, mouseX, mouseY, (Object)entity);
    }

    private void drawTabs(WidgetRenderContext context) {
        this.drawTab(context, EnumChannelType.ITEMS, 6, ITEM_ICON);
        this.drawTab(context, EnumChannelType.ENERGY, 35, ENERGY_ICON);
        this.drawTab(context, EnumChannelType.FLUID, 64, FLUID_ICON);
        ScreenUtils.bindTexture((class_2960)SIDE_TAB);
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)-27.0f, (float)150.0f, (float)30.0f, (float)32.0f);
        ScreenUtils.bindTexture((class_2960)REDSTONE_TAB);
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)-30.0f, (float)32.0f, (float)30.0f, (float)30.0f);
    }

    private void drawTab(WidgetRenderContext context, EnumChannelType type, int x, class_2960 icon) {
        ScreenUtils.bindTexture((class_2960)(type == TesseractScreen.type ? TAB_ON : TAB_OFF));
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)x, (float)(type == TesseractScreen.type ? 0.0f : 2.0f), (float)28.0f, (float)(type == TesseractScreen.type ? 31.0f : 26.0f));
        float width = 16.0f;
        float height = 16.0f;
        float iconX = (float)x + (28.0f - width) / 2.0f;
        float iconY = (float)(TesseractScreen.type == type ? 0 : 2) + (29.0f - height) / 2.0f;
        ScreenUtils.drawItem((class_4587)context.poseStack(), (class_1799)new class_1799((class_1935)type.item.get()), null, (int)((int)iconX), (int)((int)iconY));
    }

    private void drawChannels(class_4587 matrixStack, int mouseX, int mouseY, TesseractBlockEntity entity) {
        ScreenUtils.bindTexture((class_2960)CHANNEL_BACKGROUND);
        ScreenUtils.drawTexture((class_4587)matrixStack, (float)3.0f, (float)31.0f, (float)102.0f, (float)156.0f, (float)0.0f, (float)0.0f, (float)0.3984375f, (float)0.61328125f);
        ScreenUtils.drawTexture((class_4587)matrixStack, (float)26.0f, (float)187.0f, (float)56.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.21875f, (float)0.0625f);
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
        int channelHeight = 13;
        for (int i = 0; i < 12 && i + this.scrollOffset < channels.size(); ++i) {
            int x = 3;
            int y = 31 + i * channelHeight;
            Channel channel = channels.get(i + this.scrollOffset);
            if (entity.getChannelId(type) == channel.id) {
                ScreenUtils.fillRect((class_4587)matrixStack, (float)x, (float)y, (float)102.0f, (float)channelHeight, (int)1761636432);
            }
            if (this.selectedChannel == channel.id) {
                ScreenUtils.fillRect((class_4587)matrixStack, (float)x, (float)y, (float)102.0f, (float)1.0f, (int)-1);
                ScreenUtils.fillRect((class_4587)matrixStack, (float)x, (float)(y + 12), (float)102.0f, (float)1.0f, (int)-1);
                ScreenUtils.fillRect((class_4587)matrixStack, (float)x, (float)y, (float)1.0f, (float)channelHeight, (int)-1);
                ScreenUtils.fillRect((class_4587)matrixStack, (float)(x + 101), (float)y, (float)1.0f, (float)channelHeight, (int)-1);
            } else if (mouseX >= x && mouseX < 105 && mouseY >= y && mouseY < y + channelHeight) {
                ScreenUtils.fillRect((class_4587)matrixStack, (float)x, (float)y, (float)102.0f, (float)1.0f, (int)-10066330);
                ScreenUtils.fillRect((class_4587)matrixStack, (float)x, (float)(y + 12), (float)102.0f, (float)1.0f, (int)-10066330);
                ScreenUtils.fillRect((class_4587)matrixStack, (float)x, (float)y, (float)1.0f, (float)channelHeight, (int)-10066330);
                ScreenUtils.fillRect((class_4587)matrixStack, (float)(x + 101), (float)y, (float)1.0f, (float)channelHeight, (int)-10066330);
            }
            x += 2;
            if (entity.getChannelId(type) == channel.id) {
                ScreenUtils.bindTexture((class_2960)CHECKMARK);
                ScreenUtils.drawTexture((class_4587)matrixStack, (float)x, (float)(y + 2), (float)9.0f, (float)9.0f);
                x += 12;
            }
            PlayerRenderer.renderPlayerHead(channel.creator, matrixStack, x, y + 2, 9, 9);
            boolean isOwnedChannel = channel.creator.equals(ClientUtils.getPlayer().method_5667());
            int availableWidth = 100 - (x += 12) - (isOwnedChannel ? 9 : 0);
            Object name = channel.name;
            if (ClientUtils.getFontRenderer().method_1727((String)name) > availableWidth) {
                name = ClientUtils.getFontRenderer().method_27527().method_27494((String)name, availableWidth - ClientUtils.getFontRenderer().method_1727("..."), class_2583.field_24360) + "...";
            }
            ScreenUtils.drawString((class_4587)matrixStack, (String)name, (float)x, (float)(y + 3), (int)-1);
            x += ClientUtils.getFontRenderer().method_1727((String)name) + 3;
            if (!isOwnedChannel) continue;
            ScreenUtils.bindTexture((class_2960)(channel.isPrivate ? LOCK_ON : LOCK_OFF));
            ScreenUtils.drawTexture((class_4587)matrixStack, (float)x, (float)(y + 2), (float)9.0f, (float)9.0f);
        }
    }

    private void drawSelectedChannelInfo(class_4587 matrixStack, Channel channel) {
        matrixStack.method_22903();
        matrixStack.method_46416(177.0f, 35.0f, 0.0f);
        matrixStack.method_22905(1.2f, 1.2f, 1.0f);
        ScreenUtils.drawCenteredString((class_4587)matrixStack, (String)channel.name, (float)0.0f, (float)0.0f, (int)0xE0E0E0);
        matrixStack.method_22909();
        ScreenUtils.drawString((class_4587)matrixStack, (class_2561)TextComponents.string((String)"Creator:").italic().get(), (float)117.0f, (float)55.0f, (int)-10066330);
        PlayerRenderer.renderPlayerHead(channel.creator, matrixStack, 117, 65, 9, 9);
        String creatorName = PlayerRenderer.getPlayerUsername(channel.creator);
        if (creatorName != null) {
            ScreenUtils.drawString((class_4587)matrixStack, (String)creatorName, (float)129.0f, (float)66.0f, (int)0xE0E0E0);
        }
        ScreenUtils.drawString((class_4587)matrixStack, (class_2561)TextComponents.string((String)"Category:").italic().get(), (float)117.0f, (float)80.0f, (int)-10066330);
        matrixStack.method_22903();
        matrixStack.method_46416(115.0f, 88.0f, 0.0f);
        matrixStack.method_22905(0.8f, 0.8f, 1.0f);
        ScreenUtils.drawItem((class_4587)matrixStack, (class_1799)new class_1799((class_1935)TesseractScreen.type.item.get()), null, (int)0, (int)0);
        matrixStack.method_22909();
        ScreenUtils.drawString((class_4587)matrixStack, (class_2561)channel.type.getTranslation(), (float)129.0f, (float)91.0f, (int)0xE0E0E0);
        ScreenUtils.drawString((class_4587)matrixStack, (class_2561)TextComponents.string((String)"Accessibility:").italic().get(), (float)117.0f, (float)105.0f, (int)-10066330);
        ScreenUtils.bindTexture((class_2960)(channel.isPrivate ? LOCK_ON : LOCK_OFF));
        ScreenUtils.drawTexture((class_4587)matrixStack, (float)116.0f, (float)114.0f, (float)11.0f, (float)11.0f);
        ScreenUtils.drawString((class_4587)matrixStack, (class_2561)TextComponents.translation((String)("gui.tesseract.channel." + (channel.isPrivate ? "private" : "public"))).get(), (float)129.0f, (float)116.0f, (int)0xE0E0E0);
    }

    private void setChannelType(EnumChannelType type) {
        TesseractScreen.type = type;
        this.scrollOffset = 0;
        this.selectedChannel = -1;
        this.setButton.active = false;
        this.setButton.setText((class_2561)TextComponents.translation((String)"gui.tesseract.set").get());
        this.removeButton.active = false;
    }

    protected boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled, TesseractBlockEntity entity) {
        if (!hasBeenHandled && button == 0) {
            if (mouseY >= 2 && mouseY < 28) {
                if (mouseX >= 6 && mouseX < 34 && type != EnumChannelType.ITEMS) {
                    this.setChannelType(EnumChannelType.ITEMS);
                    hasBeenHandled = true;
                } else if (mouseX >= 35 && mouseX < 63 && type != EnumChannelType.ENERGY) {
                    this.setChannelType(EnumChannelType.ENERGY);
                    hasBeenHandled = true;
                } else if (mouseX >= 64 && mouseX < 92 && type != EnumChannelType.FLUID) {
                    this.setChannelType(EnumChannelType.FLUID);
                    hasBeenHandled = true;
                }
            } else if (mouseX >= 3 && mouseX < 105 && mouseY >= 31 && mouseY < 187) {
                int index = (mouseY - 31) / 13 + this.scrollOffset;
                List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
                if (index < channels.size()) {
                    this.selectedChannel = channels.get((int)index).id;
                    this.setButton.setText((class_2561)TextComponents.translation((String)("gui.tesseract." + (entity.getChannelId(type) == this.selectedChannel ? "unset" : "set"))).get());
                    this.setButton.active = true;
                    this.removeButton.active = channels.get((int)index).creator.equals(class_310.method_1551().field_1724.method_5667());
                } else {
                    this.selectedChannel = -1;
                    this.setButton.active = false;
                    this.setButton.setText((class_2561)TextComponents.translation((String)"gui.tesseract.set").get());
                    this.removeButton.active = false;
                }
                hasBeenHandled = true;
            }
        }
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled, (Object)entity);
    }

    protected boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled, TesseractBlockEntity entity) {
        if (!hasBeenHandled) {
            if (TesseractChannelManager.CLIENT.getChannels(type).size() > 12) {
                this.scrollOffset = Math.max(this.scrollOffset - (int)scrollAmount, 0);
                this.scrollOffset = Math.min(this.scrollOffset, TesseractChannelManager.CLIENT.getChannels(type).size() - 12);
            } else {
                this.scrollOffset = 0;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled, (Object)entity);
    }

    protected class_2561 getNarrationMessage(TesseractBlockEntity entity) {
        return TextComponents.translation((String)"gui.tesseract.title").get();
    }
}

