/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.model.util;

import com.iafenvoy.uranus.Uranus;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.TabulaModelHandler;
import com.iafenvoy.uranus.client.model.tabula.TabulaModelContainer;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class TabulaModelHandlerHelper {
    private static final Map<class_2960, TabulaModelContainer> MODELS = new HashMap<class_2960, TabulaModelContainer>();

    public static void reloadModel(class_3300 manager) {
        MODELS.clear();
        for (Map.Entry entry : manager.method_14488("models/tabula", id -> id.method_12832().endsWith(".tbl")).entrySet()) {
            class_2960 id2 = (class_2960)entry.getKey();
            try {
                MODELS.put(id2, TabulaModelHandler.INSTANCE.loadTabulaModel(TabulaModelHandlerHelper.getModelJsonStream(id2.toString(), ((class_3298)entry.getValue()).method_14482())));
            }
            catch (Exception e) {
                Uranus.LOGGER.error("Failed to load tabula {}", (Object)id2.toString(), (Object)e);
            }
        }
        Uranus.LOGGER.info("Successfully load {} tabula models", (Object)MODELS.size());
    }

    @Nullable
    public static TabulaModelContainer getContainer(class_2960 id) {
        return MODELS.get(id);
    }

    @Nullable
    public static <T extends class_1297> TabulaModel<T> getModel(class_2960 id) {
        return TabulaModelHandlerHelper.getModel(id, null);
    }

    @Nullable
    public static <T extends class_1297> TabulaModel<T> getModel(class_2960 id, Supplier<ITabulaModelAnimator<T>> tabulaAnimator) {
        return TabulaModelHandlerHelper.getModel(id, new MemorizeSupplier<ITabulaModelAnimator<T>>(tabulaAnimator));
    }

    @Nullable
    public static <T extends class_1297> TabulaModel<T> getModel(class_2960 id, MemorizeSupplier<ITabulaModelAnimator<T>> tabulaAnimator) {
        try {
            String path = "models/tabula/" + id.method_12832();
            if (!path.endsWith(".tbl")) {
                path = path + ".tbl";
            }
            if (MODELS.containsKey(id = id.method_45136(path))) {
                return new TabulaModel<T>(MODELS.get(id), tabulaAnimator);
            }
        }
        catch (Exception e) {
            Uranus.LOGGER.error("Failed to load model {}", (Object)id, (Object)e);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static TabulaModelContainer loadTabulaModel(String path) throws IOException {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith(".tbl")) {
            path = (String)path + ".tbl";
        }
        InputStream stream = class_310.method_1551().method_1478().open(new class_2960((String)path));
        return TabulaModelHandler.INSTANCE.loadTabulaModel(TabulaModelHandlerHelper.getModelJsonStream((String)path, stream));
    }

    private static InputStream getModelJsonStream(String name, InputStream file) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(file);
        do {
            if ((entry = zip.getNextEntry()) != null) continue;
            throw new RuntimeException("No model.json present in " + name);
        } while (!entry.getName().equals("model.json"));
        return zip;
    }
}

