/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.api.DynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSources;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import toni.sodiumdynamiclights.DynamicLightSource;
import toni.sodiumdynamiclights.DynamicLightsConfig;
import toni.sodiumdynamiclights.accessor.WorldRendererAccessor;

public class SodiumDynamicLights
implements ClientModInitializer {
    public static final String NAMESPACE = "sodiumdynamiclights";
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private static SodiumDynamicLights INSTANCE;
    public final Logger logger = LoggerFactory.getLogger((String)"sodiumdynamiclights");
    public final DynamicLightsConfig config = new DynamicLightsConfig();
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;

    public void onInitializeClient() {
        INSTANCE = this;
        this.log("Initializing SodiumDynamicLights...");
        ClientLifecycleEvents.CLIENT_STOPPING.register(mc -> DynamicLightsConfig.SPECS.save());
        ForgeConfigRegistry.INSTANCE.register(NAMESPACE, ModConfig.Type.CLIENT, (IConfigSpec)DynamicLightsConfig.SPECS);
        FabricLoader.getInstance().getEntrypointContainers(NAMESPACE, DynamicLightsInitializer.class).stream().map(EntrypointContainer::getEntrypoint).forEach(dynamicLightsInitializer -> dynamicLightsInitializer.onInitializeDynamicLights());
        FabricLoader.getInstance().getEntrypointContainers("dynamiclights", DynamicLightsInitializer.class).stream().map(EntrypointContainer::getEntrypoint).forEach(dynamicLightsInitializer -> dynamicLightsInitializer.onInitializeDynamicLights());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960(SodiumDynamicLights.NAMESPACE, "dynamiclights_resources");
            }

            public void method_14491(class_3300 manager) {
                ItemLightSources.load(manager);
            }
        });
        WorldRenderEvents.START.register(context -> this.updateAll(context.worldRenderer()));
        DynamicLightHandlers.registerDefaultHandlers();
    }

    public void updateAll(@NotNull class_761 renderer) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            this.lightSourcesLock.readLock().lock();
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.sodiumdynamiclights$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
            this.lightSourcesLock.readLock().unlock();
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull class_2338 pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull class_1297 entity, int lightmap) {
        int posLightLevel = (int)this.getDynamicLightLevel(entity.method_23312());
        int entityLuminance = ((DynamicLightSource)entity).sdl$getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = class_765.method_24186((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull class_2338 pos) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (DynamicLightSource lightSource : this.dynamicLightSources) {
            result = SodiumDynamicLights.maxDynamicLightLevel(pos, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return class_3532.method_15350((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull class_2338 pos, @NotNull DynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.sdl$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.method_10263() - lightSource.sdl$getDynamicLightX() + 0.5) * dx + (dy = (double)pos.method_10264() - lightSource.sdl$getDynamicLightY() + 0.5) * dy + (dz = (double)pos.method_10260() - lightSource.sdl$getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.sdl$getDynamicLightLevel().method_8608()) {
            return;
        }
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.lightSourcesLock.writeLock().lock();
        this.dynamicLightSources.add(lightSource);
        this.lightSourcesLock.writeLock().unlock();
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.sdl$getDynamicLightLevel().method_8608()) {
            return false;
        }
        this.lightSourcesLock.readLock().lock();
        boolean result = this.dynamicLightSources.contains(lightSource);
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        this.lightSourcesLock.readLock().lock();
        int result = this.dynamicLightSources.size();
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            lightSource.sodiumdynamiclights$scheduleTrackedChunksRebuild(class_310.method_1551().field_1769);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void clearLightSources() {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (it.sdl$getLuminance() > 0) {
                it.sdl$resetDynamicLight();
            }
            it.sodiumdynamiclights$scheduleTrackedChunksRebuild(class_310.method_1551().field_1769);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (it.sdl$getLuminance() > 0) {
                it.sdl$resetDynamicLight();
            }
            it.sodiumdynamiclights$scheduleTrackedChunksRebuild(class_310.method_1551().field_1769);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof class_1297 && !(lightSource instanceof class_1657));
    }

    public void removeCreeperLightSources() {
        this.removeLightSources(entity -> entity instanceof class_1548);
    }

    public void removeTntLightSources() {
        this.removeLightSources(entity -> entity instanceof class_1541);
    }

    public void removeBlockEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof class_2586);
    }

    public void log(String info) {
        this.logger.info("[LambDynLights] " + info);
    }

    public void warn(String info) {
        this.logger.warn("[LambDynLights] " + info);
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, @NotNull class_2338 chunkPos) {
        SodiumDynamicLights.scheduleChunkRebuild(renderer, chunkPos.method_10263(), chunkPos.method_10264(), chunkPos.method_10260());
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, long chunkPos) {
        SodiumDynamicLights.scheduleChunkRebuild(renderer, class_2338.method_10061((long)chunkPos), class_2338.method_10071((long)chunkPos), class_2338.method_10083((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, int x, int y, int z) {
        if (class_310.method_1551().field_1687 != null) {
            ((WorldRendererAccessor)renderer).sodiumdynamiclights$scheduleChunkRebuild(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull class_2338 chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.method_10063();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.sdl$isDynamicLightEnabled();
        int luminance = lightSource.sdl$getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.sdl$setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.sdl$setDynamicLightEnabled(false);
        }
    }

    private static boolean isEyeSubmergedInFluid(class_1309 entity) {
        if (!((Boolean)SodiumDynamicLights.get().config.getWaterSensitiveCheck().get()).booleanValue()) {
            return false;
        }
        class_2338 eyePos = class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321());
        return !entity.method_37908().method_8316(eyePos).method_15769();
    }

    public static int getLivingEntityLuminanceFromItems(class_1309 entity) {
        boolean submergedInFluid = SodiumDynamicLights.isEyeSubmergedInFluid(entity);
        int luminance = 0;
        for (class_1799 equipped : entity.method_5743()) {
            if (equipped.method_7960()) continue;
            luminance = Math.max(luminance, SodiumDynamicLights.getLuminanceFromItemStack(equipped, submergedInFluid));
        }
        return luminance;
    }

    public static int getLuminanceFromItemStack(@NotNull class_1799 stack, boolean submergedInWater) {
        return ItemLightSources.getLuminance(stack, submergedInWater);
    }

    public static SodiumDynamicLights get() {
        return INSTANCE;
    }
}

