/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.items.AbstractComputerItem;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.util.NBTUtil;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5556;
import net.minecraft.class_5620;

public class TurtleItem
extends AbstractComputerItem
implements IColouredItem {
    public static final class_5620 CAULDRON_INTERACTION = (blockState, level, pos, player, hand, stack) -> {
        if (IColouredItem.getColourBasic(stack) == -1) {
            return class_1269.field_5811;
        }
        if (!level.field_9236) {
            IColouredItem.setColourBasic(stack, -1);
            class_5556.method_31650((class_2680)blockState, (class_1937)level, (class_2338)pos);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    };

    public TurtleItem(TurtleBlock block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    public class_1799 create(int id, @Nullable String label, int colour, @Nullable UpgradeData<ITurtleUpgrade> leftUpgrade, @Nullable UpgradeData<ITurtleUpgrade> rightUpgrade, int fuelLevel, @Nullable class_2960 overlay) {
        class_2487 tag;
        class_1799 stack = new class_1799((class_1935)this);
        if (label != null) {
            stack.method_7977((class_2561)class_2561.method_43470((String)label));
        }
        if (id >= 0) {
            stack.method_7948().method_10569("ComputerId", id);
        }
        IColouredItem.setColourBasic(stack, colour);
        if (fuelLevel > 0) {
            stack.method_7948().method_10569("Fuel", fuelLevel);
        }
        if (overlay != null) {
            stack.method_7948().method_10582("Overlay", overlay.toString());
        }
        if (leftUpgrade != null) {
            tag = stack.method_7948();
            tag.method_10582("LeftUpgrade", leftUpgrade.upgrade().getUpgradeID().toString());
            if (!leftUpgrade.data().method_33133()) {
                tag.method_10566("LeftUpgradeNbt", (class_2520)leftUpgrade.data().method_10553());
            }
        }
        if (rightUpgrade != null) {
            tag = stack.method_7948();
            tag.method_10582("RightUpgrade", rightUpgrade.upgrade().getUpgradeID().toString());
            if (!rightUpgrade.data().method_33133()) {
                tag.method_10566("RightUpgradeNbt", (class_2520)rightUpgrade.data().method_10553());
            }
        }
        return stack;
    }

    public class_2561 method_7864(class_1799 stack) {
        String baseString = this.method_7866(stack);
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (left != null && right != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded_twice"), (Object[])new Object[]{class_2561.method_43471((String)right.getUnlocalisedAdjective()), class_2561.method_43471((String)left.getUnlocalisedAdjective())});
        }
        if (left != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{class_2561.method_43471((String)left.getUnlocalisedAdjective())});
        }
        if (right != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{class_2561.method_43471((String)right.getUnlocalisedAdjective())});
        }
        return class_2561.method_43471((String)baseString);
    }

    @Nullable
    public String getCreatorModId(class_1799 stack) {
        String mod;
        String mod2;
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        if (left != null && (mod2 = TurtleUpgrades.instance().getOwner(left)) != null && !mod2.equals("computercraft")) {
            return mod2;
        }
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (right != null && (mod = TurtleUpgrades.instance().getOwner(right)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return "computercraft";
    }

    @Override
    public class_1799 changeItem(class_1799 stack, class_1792 newItem) {
        class_1799 class_17992;
        if (newItem instanceof TurtleItem) {
            TurtleItem turtle = (TurtleItem)newItem;
            class_17992 = turtle.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), this.getUpgradeWithData(stack, TurtleSide.LEFT), this.getUpgradeWithData(stack, TurtleSide.RIGHT), this.getFuelLevel(stack), this.getOverlay(stack));
        } else {
            class_17992 = class_1799.field_8037;
        }
        return class_17992;
    }

    @Nullable
    public ITurtleUpgrade getUpgrade(class_1799 stack, TurtleSide side) {
        String key;
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return null;
        }
        String string = key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        if (!tag.method_10545(key)) {
            return null;
        }
        return TurtleUpgrades.instance().get(tag.method_10558(key));
    }

    @Nullable
    public UpgradeData<ITurtleUpgrade> getUpgradeWithData(class_1799 stack, TurtleSide side) {
        String key;
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return null;
        }
        String string = key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        if (!tag.method_10545(key)) {
            return null;
        }
        ITurtleUpgrade upgrade = TurtleUpgrades.instance().get(tag.method_10558(key));
        if (upgrade == null) {
            return null;
        }
        String dataKey = side == TurtleSide.LEFT ? "LeftUpgradeNbt" : "RightUpgradeNbt";
        return UpgradeData.of(upgrade, NBTUtil.getCompoundOrEmpty(tag, dataKey));
    }

    @Nullable
    public class_2960 getOverlay(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("Overlay") ? new class_2960(tag.method_10558("Overlay")) : null;
    }

    public int getFuelLevel(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("Fuel") ? tag.method_10550("Fuel") : 0;
    }
}

