/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Contract;

public class TerminalState {
    private final boolean colour;
    final int width;
    final int height;
    final int cursorX;
    final int cursorY;
    final boolean cursorBlink;
    final int cursorBgColour;
    final int cursorFgColour;
    final byte[] contents;

    TerminalState(boolean colour, int width, int height, int cursorX, int cursorY, boolean cursorBlink, int cursorFgColour, int cursorBgColour, byte[] contents) {
        this.colour = colour;
        this.width = width;
        this.height = height;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        this.cursorBlink = cursorBlink;
        this.cursorFgColour = cursorFgColour;
        this.cursorBgColour = cursorBgColour;
        this.contents = contents;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static TerminalState create(@Nullable NetworkedTerminal terminal) {
        return terminal == null ? null : terminal.write();
    }

    public TerminalState(class_2540 buf) {
        this.colour = buf.readBoolean();
        this.width = buf.method_10816();
        this.height = buf.method_10816();
        this.cursorX = buf.method_10816();
        this.cursorY = buf.method_10816();
        this.cursorBlink = buf.readBoolean();
        byte cursorColour = buf.readByte();
        this.cursorBgColour = cursorColour >> 4 & 0xF;
        this.cursorFgColour = cursorColour & 0xF;
        this.contents = buf.method_10795();
    }

    public void write(class_2540 buf) {
        buf.writeBoolean(this.colour);
        buf.method_10804(this.width);
        buf.method_10804(this.height);
        buf.method_10804(this.cursorX);
        buf.method_10804(this.cursorY);
        buf.writeBoolean(this.cursorBlink);
        buf.writeByte(this.cursorBgColour << 4 | this.cursorFgColour);
        buf.method_10813(this.contents);
    }

    public int size() {
        return this.contents.length;
    }

    public void apply(NetworkedTerminal terminal) {
        terminal.read(this);
    }

    public NetworkedTerminal create() {
        NetworkedTerminal terminal = new NetworkedTerminal(this.width, this.height, this.colour);
        terminal.read(this);
        return terminal;
    }
}

