/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.api.component.ComputerComponent;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.ComputerAccess;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.ApiLifecycle;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

final class ComputerSystem
extends ComputerAccess
implements IComputerSystem,
ApiLifecycle {
    private final ServerComputer computer;
    private final IAPIEnvironment environment;
    private final Map<ComputerComponent<?>, Object> components;
    private boolean active;

    ComputerSystem(ServerComputer computer, IAPIEnvironment environment, Map<ComputerComponent<?>, Object> components) {
        super(environment);
        this.computer = computer;
        this.environment = environment;
        this.components = components;
    }

    void activate() {
        this.active = true;
    }

    @Override
    public void shutdown() {
        this.unmountAll();
    }

    @Override
    public String getAttachmentName() {
        return "computer";
    }

    @Override
    public class_3218 getLevel() {
        if (!this.active) {
            throw new IllegalStateException("Cannot access level when constructing the API. Computers are not guaranteed to stay in one place and\nAPIs should not rely on the level remaining constant. Instead, call this method when needed.\n".replace('\n', ' ').strip());
        }
        return this.computer.getLevel();
    }

    @Override
    public class_2338 getPosition() {
        if (!this.active) {
            throw new IllegalStateException("Cannot access computer position when constructing the API. Computers are not guaranteed to stay in one\nplace and APIs should not rely on the position remaining constant. Instead, call this method when\nneeded.\n".replace('\n', ' ').strip());
        }
        return this.computer.getPosition();
    }

    @Override
    @Nullable
    public String getLabel() {
        return this.environment.getLabel();
    }

    @Override
    public Map<String, IPeripheral> getAvailablePeripherals() {
        return Map.of();
    }

    @Override
    @Nullable
    public IPeripheral getAvailablePeripheral(String name) {
        return null;
    }

    @Override
    @Nullable
    public <T> T getComponent(ComputerComponent<T> component) {
        return (T)this.components.get(component);
    }
}

