/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.core;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import i18nupdatemod.util.Log;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class GameConfig {
    private static final Gson GSON = new Gson();
    private static final Type STRING_LIST_TYPE = new TypeToken<List<String>>(){}.getType();
    protected Map<String, String> configs = new LinkedHashMap<String, String>();
    private final Path configFile;

    public GameConfig(Path configFile) throws Exception {
        this.configFile = configFile;
        if (!Files.exists(configFile, new LinkOption[0])) {
            return;
        }
        this.configs = FileUtils.readLines((File)configFile.toFile(), (Charset)StandardCharsets.UTF_8).stream().map(it -> it.split(":", 2)).filter(it -> ((String[])it).length == 2).collect(Collectors.toMap(it -> it[0], it -> it[1], (a, b) -> a, LinkedHashMap::new));
    }

    public void writeToFile() throws Exception {
        FileUtils.writeLines((File)this.configFile.toFile(), (String)"UTF-8", (Collection)this.configs.entrySet().stream().map(it -> (String)it.getKey() + ":" + (String)it.getValue()).collect(Collectors.toList()));
    }

    public void addResourcePack(String baseName, String resourcePack) {
        List resourcePacks = (List)GSON.fromJson(this.configs.computeIfAbsent("resourcePacks", it -> "[]"), STRING_LIST_TYPE);
        if (resourcePacks.contains(resourcePack)) {
            return;
        }
        resourcePacks = resourcePacks.stream().filter(it -> !it.contains(baseName)).collect(Collectors.toList());
        resourcePacks.add(resourcePack);
        this.configs.put("resourcePacks", GSON.toJson(resourcePacks));
        Log.info(String.format("Resource Packs: %s", this.configs.get("resourcePacks")));
    }
}

