/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;

public class CorporeaCrystalCubeBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor,
Wandable {
    private static final String TAG_REQUEST_TARGET = "requestTarget";
    private static final String TAG_ITEM_COUNT = "itemCount";
    private static final String TAG_LOCK = "lock";
    private class_1799 requestTarget = class_1799.field_8037;
    private int itemCount = 0;
    private int ticks = 0;
    private int compValue = 0;
    public boolean locked = false;

    public CorporeaCrystalCubeBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.CORPOREA_CRYSTAL_CUBE, pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CorporeaCrystalCubeBlockEntity self) {
        ++self.ticks;
        if (self.ticks % 20 == 0) {
            self.updateCount();
        }
    }

    public void setRequestTarget(class_1799 stack) {
        if (!stack.method_7960() && !this.locked) {
            this.requestTarget = stack.method_46651(1);
            this.method_5431();
            this.updateCount();
        }
    }

    public class_1799 getRequestTarget() {
        return this.requestTarget;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void doRequest(class_1657 player) {
        if (this.field_11863.field_9236) {
            return;
        }
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.method_7960()) {
            int count = player.method_5715() ? this.requestTarget.method_7914() : 1;
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(this.requestTarget, true);
            this.doCorporeaRequest(matcher, count, spark, (class_1309)player);
        }
    }

    private void updateCount() {
        if (this.field_11863.field_9236) {
            return;
        }
        int sum = 0;
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.method_7960()) {
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(this.requestTarget, true);
            List<class_1799> stacks = CorporeaHelper.instance().requestItem(matcher, -1, spark, null, false).stacks();
            for (class_1799 stack : stacks) {
                sum += stack.method_7947();
            }
        }
        this.setCount(sum);
    }

    private void setCount(int count) {
        int oldCount = this.itemCount;
        this.itemCount = count;
        if (this.itemCount != oldCount) {
            this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(this.itemCount);
            this.method_5431();
        }
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        class_2487 cmp = new class_2487();
        if (!this.requestTarget.method_7960()) {
            cmp = this.requestTarget.method_7953(cmp);
        }
        tag.method_10566(TAG_REQUEST_TARGET, (class_2520)cmp);
        tag.method_10569(TAG_ITEM_COUNT, this.itemCount);
        tag.method_10556(TAG_LOCK, this.locked);
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        class_2487 cmp = tag.method_10562(TAG_REQUEST_TARGET);
        this.requestTarget = class_1799.method_7915((class_2487)cmp);
        this.setCount(tag.method_10550(TAG_ITEM_COUNT));
        this.locked = tag.method_10577(TAG_LOCK);
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable class_1309 entity) {
        if (!this.requestTarget.method_7960()) {
            List<class_1799> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
            spark.onItemsRequested(stacks);
            boolean did = false;
            int sum = 0;
            for (class_1799 reqStack : stacks) {
                class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, reqStack);
                this.field_11863.method_8649((class_1297)item);
                if (!class_1799.method_7984((class_1799)this.requestTarget, (class_1799)reqStack)) continue;
                sum += reqStack.method_7947();
                did = true;
            }
            if (did) {
                this.setCount(this.getItemCount() - sum);
            }
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (player == null || player.method_5715()) {
            this.locked = !this.locked;
            this.method_5431();
            return true;
        }
        return false;
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    public static class Hud {
        public static void render(class_332 gui, CorporeaCrystalCubeBlockEntity cube) {
            class_4587 ps = gui.method_51448();
            class_310 mc = class_310.method_1551();
            class_3695 profiler = mc.method_16011();
            profiler.method_15396("crystalCube");
            class_1799 target = cube.getRequestTarget();
            if (!target.method_7960()) {
                String nameStr = target.method_7964().getString();
                String countStr = cube.getItemCount() + "x";
                String lockedStr = class_1074.method_4662((String)"botaniamisc.locked", (Object[])new Object[0]);
                int strlen = Math.max(mc.field_1772.method_1727(nameStr), mc.field_1772.method_1727(countStr));
                if (cube.locked) {
                    strlen = Math.max(strlen, mc.field_1772.method_1727(lockedStr));
                }
                int centerX = mc.method_22683().method_4486() / 2;
                int centerY = mc.method_22683().method_4502() / 2;
                ps.method_22903();
                ps.method_46416((float)centerX, (float)centerY, 0.0f);
                RenderHelper.renderHUDBox(gui, 8, -11, strlen + 32, cube.locked ? 21 : 11);
                gui.method_25303(mc.field_1772, nameStr, 30, -9, 0x6666FF);
                gui.method_25303(mc.field_1772, countStr, 30, 1, 0xFFFFFF);
                if (cube.locked) {
                    gui.method_25303(mc.field_1772, lockedStr, 30, 11, 0xFFAA00);
                }
                gui.method_51427(target, 10, -9);
                ps.method_22909();
            }
            profiler.method_15407();
        }
    }
}

