/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common;

import com.sun.jna.Platform;
import io.github.reserveword.imblocker.common.Common;
import io.github.reserveword.imblocker.common.IMManagerLinux;
import io.github.reserveword.imblocker.common.IMManagerMac;
import io.github.reserveword.imblocker.common.IMManagerStub;
import io.github.reserveword.imblocker.common.IMManagerWindows;

public final class IMManager {
    private static final PlatformIMManager INSTANCE;

    private IMManager() {
    }

    public static void setEnglish(boolean english) {
        INSTANCE.setEnglishState(english);
    }

    public static void syncState() {
        INSTANCE.syncState();
    }

    public static boolean getState() {
        return INSTANCE.getState();
    }

    public static void setState(boolean on) {
        INSTANCE.setState(on);
    }

    static {
        if (Platform.isWindows()) {
            INSTANCE = new IMManagerWindows();
        } else if (Platform.isMac()) {
            INSTANCE = new IMManagerMac();
        } else if (Platform.isLinux()) {
            INSTANCE = new IMManagerLinux();
        } else {
            Common.LOGGER.warn("Unsupported platform, using stub");
            INSTANCE = new IMManagerStub();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PlatformIMManager {
        public void setEnglishState(Boolean var1);

        public void syncState();

        public boolean getState();

        public void setState(boolean var1);
    }
}

