/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import io.github.reserveword.imblocker.common.Common;
import io.github.reserveword.imblocker.common.Config;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class ForgeConfig
extends Config {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    private static final Set<Class<?>> recoveredScreens;
    private static Set<Class<?>> screenBlacklist;
    private static Set<Class<?>> screenWhitelist;
    private static Set<Class<?>> inputBlacklist;
    private static Set<Class<?>> inputWhitelist;

    private ForgeConfig() {
    }

    public static void reload() {
        screenWhitelist = ForgeConfig.bakeList(ForgeConfig.CLIENT.screenWhitelist, "screenWhitelist");
        screenBlacklist = ForgeConfig.bakeList(ForgeConfig.CLIENT.screenBlacklist, "screenBlacklist");
        inputWhitelist = ForgeConfig.bakeList(ForgeConfig.CLIENT.inputWhitelist, "inputWhitelist");
        inputBlacklist = ForgeConfig.bakeList(ForgeConfig.CLIENT.inputBlacklist, "inputBlacklist");
    }

    private static Set<Class<?>> bakeList(ForgeConfigSpec.ConfigValue<List<? extends String>> cfg, String name) {
        HashSet clsSet = new HashSet();
        for (String s : (List)cfg.get()) {
            try {
                if (s.contains(":")) {
                    String[] ss = s.split(":");
                    s = ss[ss.length - 1];
                }
                clsSet.add(Class.forName(s));
            }
            catch (ClassNotFoundException e) {
                Common.LOGGER.warn("Class {} not found, ignored.", (Object)s);
            }
            catch (Throwable e) {
                Common.LOGGER.warn((Object)e);
            }
        }
        Common.LOGGER.info("imblocker bakelist {} result {}", (Object)name, clsSet);
        return clsSet;
    }

    @Override
    public boolean inScreenBlacklist(Class<?> cls) {
        return screenBlacklist.contains(cls);
    }

    @Override
    public boolean inScreenWhitelist(Class<?> cls) {
        return screenWhitelist != null && screenWhitelist.contains(cls);
    }

    @Override
    public boolean inInputBlacklist(Class<?> cls) {
        return inputBlacklist.contains(cls);
    }

    @Override
    public boolean inInputWhitelist(Class<?> cls) {
        return inputWhitelist.contains(cls);
    }

    @Override
    public Boolean getUseExperimental() {
        return (Boolean)ForgeConfig.CLIENT.useExperimental.get();
    }

    public String getClassName(Class<?> cls) {
        CodeSource source = cls.getProtectionDomain().getCodeSource();
        if (source == null || cls.getName().startsWith("net.minecraft.")) {
            return "minecraft:" + cls.getName();
        }
        URL loc = source.getLocation();
        AtomicReference<String> name = new AtomicReference<String>("UNKNOWN_SCREEN");
        ModList.get().forEachModContainer((modid, mod) -> {
            try {
                if (!"minecraft".equals(modid) && !"imblocker".equals(modid) && loc == mod.getMod().getClass().getProtectionDomain().getCodeSource().getLocation()) {
                    name.set(modid + ":" + cls.getName());
                }
            }
            catch (NullPointerException npe) {
                Common.LOGGER.error("something is null when grabbing mod jar:");
                Object modobj = mod.getMod();
                Class<?> modcls = modobj != null ? modobj.getClass() : null;
                ProtectionDomain pd = modcls != null ? modcls.getProtectionDomain() : null;
                CodeSource cs = pd != null ? pd.getCodeSource() : null;
                Common.LOGGER.warn("modid {}, mod {}, class {}, domain {}, source {}", modid, modobj, modcls, (Object)pd, (Object)cs);
                Common.LOGGER.error("enableScreenRecovering disabled.");
                ForgeConfig.CLIENT.enableScreenRecovering.set((Object)false);
            }
        });
        return name.get();
    }

    static {
        recoveredScreens = new HashSet();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        Config.INSTANCE = new ForgeConfig();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> screenWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> screenBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> inputWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> inputBlacklist;
        private final ForgeConfigSpec.ConfigValue<Integer> checkIntervalMilli;
        private final ForgeConfigSpec.ConfigValue<Boolean> enableScreenRecovering;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> recoveredScreens;
        private final ForgeConfigSpec.ConfigValue<Boolean> useExperimental;
        private final ForgeConfigSpec.ConfigValue<Boolean> checkCommandChat;

        Client(ForgeConfigSpec.Builder builder) {
            this.checkIntervalMilli = builder.comment("Check once every several milliseconds").translation("key.imblocker.checkIntervalMilli").defineInRange("checkIntervalMilli", 100, 1, Integer.MAX_VALUE);
            this.screenBlacklist = builder.comment("Matched screens would disable your IME").translation("key.imblocker.screenBlacklist").defineList("screenBlacklist", Collections.emptyList(), Config.checkClassForName);
            this.screenWhitelist = builder.comment("Matched screens would enable your IME").translation("key.imblocker.screenWhitelist").defineList("screenWhitelist", Arrays.asList(BookEditScreen.class.getName(), SignEditScreen.class.getName(), "net.minecraft.client.gui.screens.inventory.HangingSignEditScreen", "journeymap.client.ui.waypoint.WaypointEditor", "com.ldtteam.blockout.BOScreen"), Config.checkClassForName);
            this.inputBlacklist = builder.comment("Matched input box would disable your IME").translation("key.imblocker.inputBlacklist").defineList("inputBlacklist", Collections.emptyList(), Config.checkClassForName);
            this.inputWhitelist = builder.comment("Matched input box would enable your IME").translation("key.imblocker.inputWhitelist").defineList("inputWhitelist", Collections.emptyList(), Config.checkClassForName);
            this.enableScreenRecovering = builder.comment("Do we output recoveredScreens? because it may cause lag").translation("key.imblocker.enableScreenRecovering").define("enableScreenRecovering", false);
            this.recoveredScreens = builder.comment(new String[]{"Here lists all Screens that is not in whitelist nor blacklist, ", "so you may easily add those to whitelist/blacklist."}).translation("key.imblocker.recoveredScreens").defineList("recoveredScreens", Collections.emptyList(), s -> true);
            this.useExperimental = builder.comment("Disable this and let me know if input or control is messed up").translation("key.imblocker.useExperimental").define("useExperimental", false);
            this.checkCommandChat = builder.comment("Disable IME when typing commands").translation("key.imblocker.checkCommandChat").define("checkCommandChat", true);
        }
    }
}

