/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier2;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class FishingStationBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    private final RebornInventory<FishingStationBlockEntity> inventory = new RebornInventory(7, "FishingStationBlockEntity", 64, (MachineBaseBlockEntity)this);

    public FishingStationBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.FISHING_STATION, pos, state);
    }

    private boolean insertIntoInv(List<class_1799> stacks) {
        boolean result = false;
        block0: for (class_1799 stack : stacks) {
            for (int i = 0; i < 6; ++i) {
                if (this.insertIntoInv(i, stack)) {
                    result = true;
                }
                if (stack.method_7960()) continue block0;
            }
        }
        return result;
    }

    private boolean insertIntoInv(int slot, class_1799 stack) {
        int freeStackSpace;
        class_1799 targetStack = this.inventory.method_5438(slot);
        if (targetStack.method_7960()) {
            this.inventory.method_5447(slot, stack.method_7972());
            stack.method_7934(stack.method_7947());
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)stack, (class_1799)targetStack, (boolean)true, (boolean)false) && (freeStackSpace = targetStack.method_7914() - targetStack.method_7947()) > 0) {
            int transferAmount = Math.min(freeStackSpace, stack.method_7947());
            targetStack.method_7933(transferAmount);
            stack.method_7934(transferAmount);
            return true;
        }
        return false;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        this.charge(6);
        long useRequirement = this.getEuPerTick(TechRebornConfig.fishingStationEnergyPerCatch);
        if (this.getStored() < useRequirement) {
            return;
        }
        int speed = (int)Math.round(this.getSpeedMultiplier() / TechRebornConfig.overclockerSpeed) + 1;
        if (world.method_8510() % (long)(TechRebornConfig.fishingStationInterval / speed) != 0L) {
            return;
        }
        class_2338 frontPos = pos.method_10093(this.getFacing());
        class_3610 frontFluid = world.method_8316(frontPos);
        if (!frontFluid.method_33659((class_3611)class_3612.field_15910)) {
            return;
        }
        class_8567 lootContextParameterSet = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)frontPos)).method_51874(class_181.field_1229, (Object)TRContent.Machine.FISHING_STATION.getStack()).method_51875(class_173.field_1176);
        class_52 lootTable = world.method_8503().method_3857().getLootTable(class_39.field_353);
        ObjectArrayList list = lootTable.method_51878(lootContextParameterSet);
        if (this.insertIntoInv((List<class_1799>)list)) {
            this.useEnergy(useRequirement);
        }
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.fishingStationMaxEnergy;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.fishingStationMaxInput;
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return TRContent.Machine.FISHING_STATION.getStack();
    }

    public RebornInventory<FishingStationBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("fishing_station").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).outputSlot(0, 30, 22).outputSlot(1, 48, 22).outputSlot(2, 30, 40).outputSlot(3, 48, 40).outputSlot(4, 30, 58).outputSlot(5, 48, 58).energySlot(6, 8, 72).syncEnergyValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

