/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.rei_stuff;

import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.client.ClientWorldGenState;
import uk.me.desert_island.rer.rei_stuff.LootDisplay;
import uk.me.desert_island.rer.rei_stuff.WorldGenDisplay;

@Environment(value=EnvType.CLIENT)
public class WorldGenCategory
implements DisplayCategory<WorldGenDisplay> {
    static final Map<class_5321<class_1937>, CategoryIdentifier<?>> WORLD_IDENTIFIER_MAP = Maps.newHashMap();
    private final class_5321<class_1937> world;
    private final ValueAnimator<Double> scroll = ValueAnimator.ofDouble();

    public CategoryIdentifier<? extends WorldGenDisplay> getCategoryIdentifier() {
        return WORLD_IDENTIFIER_MAP.get(this.world);
    }

    public WorldGenCategory(class_5321<class_1937> world) {
        WORLD_IDENTIFIER_MAP.put(world, CategoryIdentifier.of((String)"roughlyenoughresources", (String)(world.method_29177().method_12832() + "_worldgen_category")));
        this.world = world;
        ClientGuiEvent.RENDER_POST.register((screen, matrices, mouseX, mouseY, delta) -> {
            if ((Double)this.scroll.target() < 0.0) {
                this.scroll.setTarget((Object)((Double)this.scroll.target() - (Double)this.scroll.target() * 0.6599999999999999 * (double)delta / 3.0));
            } else if ((Double)this.scroll.target() > 256.0) {
                this.scroll.setTarget((Object)(((Double)this.scroll.target() - 256.0) * (1.0 - 0.6599999999999999 * (double)delta / 3.0) + 384.0 - 128.0));
            }
            this.scroll.update((double)delta);
        });
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1799)RERUtils.fromWorldToItemStack(this.world));
    }

    public DisplayRenderer getSimpleRenderer(WorldGenDisplay recipe) {
        final EntryIngredient stacks = recipe.getOutputEntries().get(0);
        final Tooltip[] tooltip = new Tooltip[]{null};
        return new DisplayRenderer(){

            private EntryStack<?> getCurrent() {
                if (stacks.isEmpty()) {
                    return EntryStack.empty();
                }
                return stacks.size() == 1 ? (EntryStack)stacks.get(0) : (EntryStack)stacks.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)stacks.size())));
            }

            public Tooltip getTooltip(TooltipContext mouse) {
                return tooltip[0];
            }

            public int getHeight() {
                return 22;
            }

            public void render(class_332 graphics, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                EntryStack<?> current = this.getCurrent();
                Rectangle innerBounds = new Rectangle(rectangle.x + rectangle.width / 2 - 8, rectangle.y + 3, 16, 16);
                current.render(graphics, innerBounds, mouseX, mouseY, delta);
                tooltip[0] = innerBounds.contains(mouseX, mouseY) ? current.getTooltip(TooltipContext.of((Point)new Point(mouseX, mouseY))) : null;
            }
        };
    }

    public class_2561 getTitle() {
        return class_2561.method_43469((String)"rer.worldgen.category", (Object[])new Object[]{WorldGenCategory.mapAndJoinToString(this.world.method_29177().method_12832().split("_"), StringUtils::capitalize, " ")});
    }

    public static <T> String mapAndJoinToString(T[] list, Function<T, String> function, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public List<Widget> setupDisplay(WorldGenDisplay display, final Rectangle bounds) {
        class_2248 block = display.getOutputBlock();
        final Point startPoint = new Point(bounds.getMinX() + 2, bounds.getMinY() + 3);
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        widgets.add((Widget)Widgets.createSlotBase((Rectangle)new Rectangle(bounds.x + 1, bounds.y + 2, 130, 62)));
        widgets.add(new Widget(){

            public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            }

            public List<? extends class_364> method_25396() {
                return Collections.emptyList();
            }

            public boolean method_25401(double mouseX, double mouseY, double amount) {
                double mouseH = mouseX - (double)startPoint.x;
                if (bounds.contains(mouseX, mouseY) && mouseH >= 0.0 && mouseH < 128.0 && mouseY < (double)(bounds.y + 64)) {
                    WorldGenCategory.this.scroll.setTo((Object)Doubles.constrainToRange((double)((Double)WorldGenCategory.this.scroll.target() + amount * -20.0), (double)-100.0, (double)356.0), 200L);
                    return true;
                }
                return super.method_25401(mouseX, mouseY, amount);
            }
        });
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            ClientWorldGenState worldGenState = ClientWorldGenState.byWorld(display.getWorld());
            int graphHeight = 60;
            double maxPortion = worldGenState.getMaxPortion(block);
            int mouseH = mouseX - startPoint.x;
            int mouseHeight = mouseX - startPoint.x + -64 + (int)Math.round((Double)this.scroll.value());
            for (int height = 0; height < 128; ++height) {
                double portion = worldGenState.getPortionAtHeight(block, height + (int)Math.round((Double)this.scroll.value()));
                double relPortion = maxPortion == 0.0 ? 0.0 : portion / maxPortion;
                graphics.method_25294(startPoint.x + height, startPoint.y + (int)((double)graphHeight * (1.0 - relPortion)), startPoint.x + height + 1, startPoint.y + graphHeight, -16777216);
            }
            ScissorsHandler.INSTANCE.scissor(new Rectangle(bounds.x + 2, bounds.y + 2, 128, 62));
            for (int y = Math.max(-64, -60) - 150; y < 470; y += 30) {
                int yOffseted = y - (int)Math.round((Double)this.scroll.value()) - -64;
                if (yOffseted >= 0 && yOffseted < 128) {
                    graphics.method_25294(startPoint.x + yOffseted, startPoint.y, startPoint.x + yOffseted + 1, startPoint.y + graphHeight, -12303292);
                }
                graphics.method_51433(class_310.method_1551().field_1772, String.valueOf(y), startPoint.x + yOffseted + 2, startPoint.y + 2, -12303292, false);
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (bounds.contains(mouseX, mouseY) && mouseH >= 0 && mouseH < 128 && mouseY < bounds.y + 64 && mouseHeight >= -64 && mouseHeight < 320) {
                double portion = worldGenState.getPortionAtHeight(block, mouseHeight - -64);
                double rel_portion = maxPortion == 0.0 ? 0.0 : portion / maxPortion;
                graphics.method_25294(mouseX, startPoint.y, mouseX + 1, startPoint.y + graphHeight, -1321676);
                graphics.method_25294(startPoint.x, startPoint.y + Math.min((int)((double)graphHeight * (1.0 - rel_portion)), graphHeight - 1), startPoint.x + 128, startPoint.y + Math.min((int)((double)graphHeight * (1.0 - rel_portion)), graphHeight - 1) + 1, -1321676);
                REIRuntime.getInstance().queueTooltip(Tooltip.create((Point)new Point(mouseX, mouseY), (class_2561[])new class_2561[]{class_2561.method_43470((String)("Y: " + mouseHeight)), class_2561.method_43470((String)("Chance: " + LootDisplay.FORMAT_MORE.format(portion * 100.0) + "%"))}));
            }
        }));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getMaxX() - 16, bounds.getMinY() + 3)).entries((Collection)display.getOutputEntries().get(0)));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + 65, bounds.getMaxY() - 10), (class_2561)class_2561.method_43470((String)class_7923.field_41175.method_10221((Object)block).toString())).noShadow().color(-12566464, -4473925));
        Button scrollLeft = Widgets.createButton((Rectangle)new Rectangle(bounds.getMaxX() - 16, bounds.getMinY() + 24, 16, 16), (class_2561)class_2561.method_43470((String)"\u2190"));
        scrollLeft.setOnClick(button -> this.scroll(-50));
        widgets.add((Widget)scrollLeft);
        Button scrollRight = Widgets.createButton((Rectangle)new Rectangle(bounds.getMaxX() - 16, bounds.getMinY() + 24 + 20, 16, 16), (class_2561)class_2561.method_43470((String)"\u2192"));
        scrollRight.setOnClick(button -> this.scroll(50));
        widgets.add((Widget)scrollRight);
        return widgets;
    }

    public int getDisplayHeight() {
        return 76;
    }

    public void scroll(int incr) {
        this.scroll.setTo((Object)Doubles.constrainToRange((double)((Double)this.scroll.target() + (double)incr), (double)0.0, (double)256.0), 300L);
    }
}

