/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.TinkerStationRepairRecipe;

public class CraftingTableRepairKitRecipe
extends class_1852 {
    public CraftingTableRepairKitRecipe(class_2960 id) {
        super(id, class_7710.field_40251);
    }

    protected boolean toolMatches(class_1799 stack) {
        return stack.method_31573(TinkerTags.Items.MULTIPART_TOOL) && stack.method_31573(TinkerTags.Items.DURABILITY);
    }

    @Nullable
    protected Pair<ToolStack, class_1799> getRelevantInputs(class_8566 inv) {
        ToolStack tool = null;
        class_1799 repairKit = null;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_7909() instanceof IRepairKitItem) {
                if (repairKit != null) {
                    return null;
                }
                MaterialId inputMaterial = IMaterialItem.getMaterialFromStack(stack).getId();
                if (inputMaterial.equals(IMaterial.UNKNOWN_ID)) {
                    return null;
                }
                repairKit = stack;
                continue;
            }
            if (this.toolMatches(stack)) {
                if (tool != null) {
                    return null;
                }
                tool = ToolStack.from(stack);
                if (tool.isBroken() || tool.getDamage() != 0) continue;
                return null;
            }
            return null;
        }
        if (tool == null || repairKit == null) {
            return null;
        }
        return Pair.of(tool, repairKit);
    }

    public boolean matches(class_8566 inv, class_1937 worldIn) {
        Pair<ToolStack, class_1799> inputs = this.getRelevantInputs(inv);
        return inputs != null && TinkerStationRepairRecipe.getRepairIndex((IToolStackView)inputs.getFirst(), IMaterialItem.getMaterialFromStack((class_1799)inputs.getSecond()).getId()) >= 0;
    }

    protected float getRepairAmount(IToolStackView tool, class_1799 repairStack) {
        float f;
        MaterialId repairMaterial = IMaterialItem.getMaterialFromStack(repairStack).getId();
        class_1792 class_17922 = repairStack.method_7909();
        if (class_17922 instanceof IRepairKitItem) {
            IRepairKitItem kit = (IRepairKitItem)class_17922;
            f = kit.getRepairAmount();
        } else {
            f = ((Double)Config.COMMON.repairKitAmount.get()).floatValue();
        }
        float repairFactor = f;
        MaterialStatsId repairStats = TinkerStationRepairRecipe.getDefaultStatsId(tool, repairMaterial);
        float repairAmount = (float)MaterialRecipe.getRepairDurability(tool.getDefinition().getData(), repairMaterial, repairStats) * repairFactor / 3.0f;
        if (repairAmount > 0.0f) {
            repairAmount *= TinkerStationRepairRecipe.getRepairWeight(tool, repairMaterial);
        }
        return repairAmount;
    }

    public class_1799 assemble(class_8566 inv, class_5455 registryAccess) {
        Pair<ToolStack, class_1799> inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.method_8114());
            return class_1799.field_8037;
        }
        ToolStack tool = ((ToolStack)inputs.getFirst()).copy();
        float repairAmount = this.getRepairAmount(tool, (class_1799)inputs.getSecond());
        if (repairAmount > 0.0f) {
            for (ModifierEntry entry : tool.getModifierList()) {
                repairAmount = entry.getHook(TinkerHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairAmount);
                if (!(repairAmount <= 0.0f)) continue;
                return tool.createStack();
            }
            ToolDamageUtil.repair(tool, (int)repairAmount);
        }
        return tool.createStack();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.craftingTableRepairSerializer.get();
    }
}

