/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2212;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.ToolStatArgument;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.StatOverrideModifier;

public class StatsCommand {
    private static final String SUCCESS_KEY_PREFIX = TConstruct.makeTranslationKey("command", "stats.success.");
    private static final String RESET_ALL_SINGLE = TConstruct.makeTranslationKey("command", "stats.success.reset.all.single");
    private static final String RESET_ALL_MULTIPLE = TConstruct.makeTranslationKey("command", "stats.success.reset.all.multiple");
    private static final String RESET_STAT_SINGLE = TConstruct.makeTranslationKey("command", "stats.success.reset.stat.single");
    private static final String RESET_STAT_MULTIPLE = TConstruct.makeTranslationKey("command", "stats.success.reset.stat.multiple");
    private static final SimpleCommandExceptionType INVALID_ADD = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "stats.failure.invalid_add"));
    private static final SimpleCommandExceptionType INVALID_MULTIPLY = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "stats.failure.invalid_multiply"));
    private static final Dynamic2CommandExceptionType FAILED_TO_PARSE = new Dynamic2CommandExceptionType((stat, tag) -> TConstruct.makeTranslation("command", "stats.success.bonus.set.parse_fail", stat, tag));
    private static final DynamicCommandExceptionType MODIFIER_ERROR = new DynamicCommandExceptionType(error -> (class_2561)error);

    public static void register(LiteralArgumentBuilder<class_2168> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bonus").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"stat_type", ToolStatArgument.stat(INumericToolStat.class)).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> StatsCommand.update((CommandContext<class_2168>)context, Type.BONUS, Operation.MODIFY)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"stat_type", ToolStatArgument.stat()).then(class_2170.method_9244((String)"value", (ArgumentType)class_2212.method_9389()).executes(context -> StatsCommand.update((CommandContext<class_2168>)context, Type.BONUS, Operation.SET))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"multiplier").then(class_2170.method_9247((String)"multiply").then(class_2170.method_9244((String)"float_stat", ToolStatArgument.stat(INumericToolStat.class)).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> StatsCommand.update((CommandContext<class_2168>)context, Type.MULTIPLY, Operation.MODIFY)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"float_stat", ToolStatArgument.stat(INumericToolStat.class)).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> StatsCommand.update((CommandContext<class_2168>)context, Type.MULTIPLY, Operation.SET))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(StatsCommand::resetAll)).then(class_2170.method_9244((String)"stat_type", ToolStatArgument.stat()).executes(StatsCommand::resetStat))));
    }

    private static List<class_1309> updateEntities(CommandContext<class_2168> context, BiPredicate<IToolStackView, StatOverrideModifier> updateAction) throws CommandSyntaxException {
        return HeldModifiableItemIterator.apply(context, (living, stack) -> {
            boolean hasModifier;
            ToolStack tool = ToolStack.copyFrom(stack);
            StatOverrideModifier stats = (StatOverrideModifier)TinkerModifiers.statOverride.get();
            boolean needsModifier = updateAction.test(tool, stats);
            int level = tool.getUpgrades().getLevel(stats.getId());
            boolean bl = hasModifier = level > 0;
            if (needsModifier && !hasModifier) {
                tool.addModifier(stats.getId(), 1);
            } else if (hasModifier && !needsModifier) {
                tool.removeModifier(stats.getId(), level);
            } else {
                tool.rebuildStats();
            }
            ValidatedResult validated = tool.validate();
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            living.method_6122(class_1268.field_5808, tool.createStack(stack.method_7947()));
            return true;
        });
    }

    private static <T> List<class_1309> setStat(CommandContext<class_2168> context, IToolStat<T> stat, class_2520 tag) throws CommandSyntaxException {
        Object value = stat.read(tag);
        if (value == null) {
            throw FAILED_TO_PARSE.create((Object)stat.getPrefix(), (Object)tag);
        }
        return StatsCommand.updateEntities(context, (tool, stats) -> stats.set((IToolStackView)tool, stat, value));
    }

    private static int update(CommandContext<class_2168> context, Type type, Operation op) throws CommandSyntaxException {
        Object display;
        List<class_1309> successes;
        IToolStat<?> stat = ToolStatArgument.getStat(context, type.stat);
        if (op == Operation.SET && type == Type.BONUS) {
            class_2520 tag = class_2212.method_9390(context, (String)"value");
            successes = StatsCommand.setStat(context, stat, tag);
            display = tag;
        } else {
            float value = FloatArgumentType.getFloat(context, (String)"value");
            if (op == Operation.MODIFY) {
                if (value == 0.0f && type == Type.BONUS) {
                    throw INVALID_ADD.create();
                }
                if (value == 1.0f && type == Type.MULTIPLY) {
                    throw INVALID_MULTIPLY.create();
                }
            }
            INumericToolStat numeric = (INumericToolStat)stat;
            successes = type == Type.BONUS ? StatsCommand.updateEntities(context, (tool, stats) -> stats.addBonus((IToolStackView)tool, numeric, value)) : (op == Operation.SET ? StatsCommand.updateEntities(context, (tool, stats) -> stats.setMultiplier((IToolStackView)tool, numeric, value)) : StatsCommand.updateEntities(context, (tool, stats) -> stats.multiply((IToolStackView)tool, numeric, value)));
            display = Float.valueOf(value);
        }
        class_2168 source = (class_2168)context.getSource();
        int size = successes.size();
        String successKey = SUCCESS_KEY_PREFIX + type.key + "." + op.key + ".";
        if (size == 1) {
            source.method_9226(() -> class_2561.method_43469((String)(successKey + "single"), (Object[])new Object[]{stat.getPrefix(), display, ((class_1309)successes.get(0)).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)(successKey + "multiple"), (Object[])new Object[]{stat.getPrefix(), display, size}), true);
        }
        return size;
    }

    private static int resetStat(CommandContext<class_2168> context) throws CommandSyntaxException {
        IToolStat<?> stat = ToolStatArgument.getStat(context, "stat_type");
        List<class_1309> successes = StatsCommand.updateEntities(context, (tool, stats) -> {
            if (stat instanceof INumericToolStat) {
                INumericToolStat numeric = (INumericToolStat)stat;
                stats.setMultiplier((IToolStackView)tool, numeric, 1.0f);
            }
            return stats.remove((IToolStackView)tool, stat);
        });
        class_2168 source = (class_2168)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.method_9226(() -> class_2561.method_43469((String)RESET_STAT_SINGLE, (Object[])new Object[]{stat.getPrefix(), ((class_1309)successes.get(0)).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)RESET_STAT_MULTIPLE, (Object[])new Object[]{stat.getPrefix(), size}), true);
        }
        return size;
    }

    private static int resetAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        List<class_1309> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            StatOverrideModifier stats;
            ToolStack tool = ToolStack.from(stack);
            int level = tool.getModifierLevel(stats = (StatOverrideModifier)TinkerModifiers.statOverride.get());
            if (level > 0) {
                tool = tool.copy();
                tool.removeModifier(stats.getId(), level);
                class_2561 error = tool.tryValidate();
                if (error != null) {
                    throw MODIFIER_ERROR.create((Object)error);
                }
                error = stats.getHook(TinkerHooks.REMOVE).onRemoved(tool, stats);
                if (error != null) {
                    throw MODIFIER_ERROR.create((Object)error);
                }
                living.method_6122(class_1268.field_5808, tool.createStack(stack.method_7947()));
            }
            return true;
        });
        class_2168 source = (class_2168)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.method_9226(() -> class_2561.method_43469((String)RESET_ALL_SINGLE, (Object[])new Object[]{((class_1309)successes.get(0)).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)RESET_ALL_MULTIPLE, (Object[])new Object[]{size}), true);
        }
        return size;
    }

    private static enum Type {
        BONUS("stat_type"),
        MULTIPLY("float_stat");

        private final String key = this.name().toLowerCase(Locale.US);
        private final String stat;

        private Type(String stat) {
            this.stat = stat;
        }
    }

    private static enum Operation {
        MODIFY,
        SET;

        private final String key = this.name().toLowerCase(Locale.US);
    }
}

