/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public final class ModifierUtil {
    public static final String TAG_ENCHANTMENTS = "Enchantments";
    private static final class_2960 ACTIVE_MODIFIER = TConstruct.getResource("active_modifier");

    @Nullable
    public static class_2499 applyHarvestEnchantments(ToolStack tool, class_1799 stack, ToolHarvestContext context) {
        class_2499 originalEnchants = null;
        class_3222 player = context.getPlayer();
        if (player == null || !player.method_7337()) {
            class_1799 pants;
            HashMap enchantments = new HashMap();
            BiConsumer<class_1887, Integer> enchantmentConsumer = (ench, add) -> {
                if (ench != null && add != null) {
                    Integer level = (Integer)enchantments.get(ench);
                    if (level != null) {
                        add = add + level;
                    }
                    enchantments.put(ench, add);
                }
            };
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.TOOL_HARVEST_ENCHANTMENTS).applyHarvestEnchantments(tool, entry, context, enchantmentConsumer);
            }
            if (player != null && (pants = player.method_6118(class_1304.field_6172)).method_31573(TinkerTags.Items.LEGGINGS)) {
                ToolStack pantsTool = ToolStack.from(pants);
                for (ModifierEntry entry : pantsTool.getModifierList()) {
                    entry.getHook(TinkerHooks.LEGGINGS_HARVEST_ENCHANTMENTS).applyHarvestEnchantments(pantsTool, entry, context, enchantmentConsumer);
                }
            }
            if (!enchantments.isEmpty()) {
                originalEnchants = stack.method_7921();
                class_1890.method_8214(enchantments, (class_1799)stack);
            }
        }
        return originalEnchants;
    }

    public static void restoreEnchantments(class_1799 stack, class_2499 originalTag) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null) {
            if (originalTag.isEmpty()) {
                nbt.method_10551(TAG_ENCHANTMENTS);
            } else {
                nbt.method_10566(TAG_ENCHANTMENTS, (class_2520)originalTag);
            }
        }
    }

    public static int getLootingLevel(IToolStackView tool, class_1309 holder, class_1297 target, @Nullable class_1282 damageSource) {
        if (tool.isBroken()) {
            return 0;
        }
        return LootingModifierHook.getLootingValue(TinkerHooks.TOOL_LOOTING, tool, holder, target, damageSource, 0);
    }

    public static int getLeggingsLootingLevel(class_1309 holder, class_1297 target, @Nullable class_1282 damageSource, int toolLooting) {
        ToolStack pantsTool;
        class_1799 pants = holder.method_6118(class_1304.field_6172);
        if (!pants.method_7960() && pants.method_31573(TinkerTags.Items.LEGGINGS) && !(pantsTool = ToolStack.from(pants)).isBroken()) {
            toolLooting = LootingModifierHook.getLootingValue(TinkerHooks.LEGGINGS_LOOTING, pantsTool, holder, target, damageSource, toolLooting);
        }
        return toolLooting;
    }

    public static void dropItem(class_1297 target, class_1799 stack) {
        if (!stack.method_7960() && !target.method_37908().field_9236) {
            class_1542 ent = new class_1542(target.method_37908(), target.method_23317(), target.method_23318() + 1.0, target.method_23321(), stack);
            ent.method_6988();
            class_5819 rand = target.method_37908().field_9229;
            ent.method_18799(ent.method_18798().method_1031((double)((rand.method_43057() - rand.method_43057()) * 0.1f), (double)(rand.method_43057() * 0.05f), (double)((rand.method_43057() - rand.method_43057()) * 0.1f)));
            target.method_37908().method_8649((class_1297)ent);
        }
    }

    public static int getModifierLevel(class_1799 stack, ModifierId modifier) {
        class_2499 list;
        int size;
        class_2487 nbt;
        if (!stack.method_7960() && stack.method_31573(TinkerTags.Items.MODIFIABLE) && (nbt = stack.method_7969()) != null && nbt.method_10573("tic_modifiers", 9) && (size = (list = nbt.method_10554("tic_modifiers", 10)).size()) > 0) {
            String key = modifier.toString();
            for (int i = 0; i < size; ++i) {
                class_2487 entry = list.method_10602(i);
                if (!key.equals(entry.method_10558("name"))) continue;
                return entry.method_10550("level");
            }
        }
        return 0;
    }

    public static boolean hasUpgrades(class_1799 stack) {
        if (!stack.method_7960() && stack.method_31573(TinkerTags.Items.MODIFIABLE)) {
            class_2487 nbt = stack.method_7969();
            return nbt != null && !nbt.method_10554("tic_upgrades", 10).isEmpty();
        }
        return false;
    }

    public static boolean validArmorSlot(class_1309 living, class_1304 slot) {
        return slot.method_5925() == class_1304.class_1305.field_6178 || living.method_6118(slot).method_31573(TinkerTags.Items.HELD);
    }

    public static boolean validArmorSlot(IToolStackView tool, class_1304 slot) {
        return slot.method_5925() == class_1304.class_1305.field_6178 || tool.hasTag(TinkerTags.Items.HELD);
    }

    public static void addTotalArmorModifierLevel(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount, boolean allowBroken) {
        if (ModifierUtil.validArmorSlot(tool, context.getChangedSlot()) && (allowBroken || !tool.isBroken())) {
            context.getTinkerData().ifPresent(data -> {
                int totalLevels = data.get(key, 0) + amount;
                if (totalLevels <= 0) {
                    data.remove(key);
                } else {
                    data.put(key, totalLevels);
                }
            });
        }
    }

    public static void addTotalArmorModifierLevel(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount) {
        ModifierUtil.addTotalArmorModifierLevel(tool, context, key, amount, false);
    }

    public static void addTotalArmorModifierFloat(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Float> key, float amount) {
        if (ModifierUtil.validArmorSlot(tool, context.getChangedSlot()) && !tool.isBroken()) {
            context.getTinkerData().ifPresent(data -> {
                float totalLevels = data.get(key, Float.valueOf(0.0f)).floatValue() + amount;
                if (totalLevels <= 0.005f) {
                    data.remove(key);
                } else {
                    data.put(key, Float.valueOf(totalLevels));
                }
            });
        }
    }

    public static int getTotalModifierLevel(class_1309 living, TinkerDataCapability.TinkerDataKey<Integer> key) {
        return TinkerDataCapability.CAPABILITY.maybeGet((Object)living).map(data -> (Integer)data.get(key)).orElse(0);
    }

    public static float getTotalModifierFloat(class_1309 living, TinkerDataCapability.TinkerDataKey<Float> key) {
        return TinkerDataCapability.CAPABILITY.maybeGet((Object)living).map(data -> (Float)data.get(key)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static boolean hasAquaAffinity(class_1309 living) {
        return ModifierUtil.getTotalModifierLevel(living, TinkerDataKeys.AQUA_AFFINITY) > 0 || class_1890.method_8200((class_1309)living);
    }

    public static boolean checkVolatileFlag(class_1799 stack, class_2960 flag) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10573("tic_volatile_data", 10)) {
            return nbt.method_10562("tic_volatile_data").method_10577(flag.toString());
        }
        return false;
    }

    public static int getVolatileInt(class_1799 stack, class_2960 flag) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10573("tic_volatile_data", 10)) {
            return nbt.method_10562("tic_volatile_data").method_10550(flag.toString());
        }
        return 0;
    }

    public static int getPersistentInt(class_1799 stack, class_2960 flag, int defealtValue) {
        String flagString;
        class_2487 persistent;
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10573("tic_persistent_data", 10) && (persistent = nbt.method_10562("tic_persistent_data")).method_10573(flagString = flag.toString(), 3)) {
            return persistent.method_10550(flagString);
        }
        return defealtValue;
    }

    public static String getPersistentString(class_1799 stack, class_2960 flag) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10573("tic_persistent_data", 10)) {
            return nbt.method_10562("tic_persistent_data").method_10558(flag.toString());
        }
        return "";
    }

    public static boolean canPerformAction(IToolStackView tool, ToolAction action) {
        if (!tool.isBroken()) {
            if (tool.getDefinition().getData().canPerformAction(action)) {
                return true;
            }
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!entry.getHook(TinkerHooks.TOOL_ACTION).canPerformAction(tool, entry, action)) continue;
                return true;
            }
        }
        return false;
    }

    public static void startUsingItem(IToolStackView tool, ModifierId modifier, class_1309 living, class_1268 hand) {
        tool.getPersistentData().putString(ACTIVE_MODIFIER, modifier.toString());
        living.method_6019(hand);
    }

    @Nullable
    public static ModifierEntry getActiveModifier(IToolStackView tool) {
        ModifierId modifier;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(ACTIVE_MODIFIER, 8) && (modifier = ModifierId.tryParse(persistentData.getString(ACTIVE_MODIFIER))) != null) {
            return tool.getModifiers().getEntry(modifier);
        }
        return null;
    }

    @Deprecated
    public static void checkFastUsingItem(IToolStackView tool, class_1309 living) {
    }

    @Deprecated
    public static void finishUsingItem(class_1309 living) {
    }

    @Deprecated
    public static void finishUsingItem(class_1309 living, IToolStackView tool) {
        ModifierUtil.finishUsingItem(tool);
    }

    public static void finishUsingItem(IToolStackView tool) {
        tool.getPersistentData().remove(ACTIVE_MODIFIER);
    }

    public static float getInaccuracy(IToolStackView tool, class_1309 living, float velocity) {
        return 3.0f * (1.0f / ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.ACCURACY) - 1.0f);
    }

    private ModifierUtil() {
    }
}

