/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import slimeknights.tconstruct.library.utils.Util;

public class ToolAttackContext {
    @Nonnull
    private final class_1309 attacker;
    @Nullable
    private final class_1657 playerAttacker;
    @Nonnull
    private final class_1268 hand;
    @Nonnull
    private final class_1304 slotType;
    @Nonnull
    private final class_1297 target;
    @Nullable
    private final class_1309 livingTarget;
    private final boolean isCritical;
    private final float cooldown;
    private final boolean isExtraAttack;

    public ToolAttackContext(class_1309 attacker, @Nullable class_1657 playerAttacker, class_1268 hand, class_1297 target, @Nullable class_1309 livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        this(attacker, playerAttacker, hand, Util.getSlotType(hand), target, livingTarget, isCritical, cooldown, isExtraAttack);
    }

    public boolean isFullyCharged() {
        return this.getCooldown() > 0.9f;
    }

    @Nonnull
    public class_1309 getAttacker() {
        return this.attacker;
    }

    @Nullable
    public class_1657 getPlayerAttacker() {
        return this.playerAttacker;
    }

    @Nonnull
    public class_1268 getHand() {
        return this.hand;
    }

    @Nonnull
    public class_1304 getSlotType() {
        return this.slotType;
    }

    @Nonnull
    public class_1297 getTarget() {
        return this.target;
    }

    @Nullable
    public class_1309 getLivingTarget() {
        return this.livingTarget;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public boolean isExtraAttack() {
        return this.isExtraAttack;
    }

    public ToolAttackContext(@Nonnull class_1309 attacker, @Nullable class_1657 playerAttacker, @Nonnull class_1268 hand, @Nonnull class_1304 slotType, @Nonnull class_1297 target, @Nullable class_1309 livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (slotType == null) {
            throw new NullPointerException("slotType is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.attacker = attacker;
        this.playerAttacker = playerAttacker;
        this.hand = hand;
        this.slotType = slotType;
        this.target = target;
        this.livingTarget = livingTarget;
        this.isCritical = isCritical;
        this.cooldown = cooldown;
        this.isExtraAttack = isExtraAttack;
    }
}

