/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

public class MaterialRecipeSerializer
extends LoggingRecipeSerializer<MaterialRecipe> {
    private static final ItemOutput EMPTY = ItemOutput.fromStack((class_1799)class_1799.field_8037);

    public MaterialRecipe fromJson(class_2960 recipeId, JsonObject json) {
        String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
        class_1856 ingredient = class_1856.method_52177((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
        int value = class_3518.method_15282((JsonObject)json, (String)"value", (int)1);
        int needed = class_3518.method_15282((JsonObject)json, (String)"needed", (int)1);
        MaterialVariantId materialId = MaterialVariantId.fromJson(json, "material");
        ItemOutput leftover = EMPTY;
        if (value > 1 && json.has("leftover")) {
            leftover = ItemOutput.fromJson((JsonElement)json.get("leftover"));
        }
        return new MaterialRecipe(recipeId, group, ingredient, value, needed, materialId, leftover);
    }

    @Nullable
    protected MaterialRecipe fromNetworkSafe(class_2960 recipeId, class_2540 buffer) {
        String group = buffer.method_10800(Short.MAX_VALUE);
        class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
        int value = buffer.readInt();
        int needed = buffer.readInt();
        MaterialVariantId materialId = MaterialVariantId.parse(buffer.method_10800(Short.MAX_VALUE));
        ItemOutput leftover = ItemOutput.read((class_2540)buffer);
        return new MaterialRecipe(recipeId, group, ingredient, value, needed, materialId, leftover);
    }

    protected void toNetworkSafe(class_2540 buffer, MaterialRecipe recipe) {
        buffer.method_10814(recipe.group);
        recipe.ingredient.method_8088(buffer);
        buffer.writeInt(recipe.value);
        buffer.writeInt(recipe.needed);
        buffer.method_10814(recipe.material.getVariant().toString());
        recipe.leftover.write(buffer);
    }
}

