/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipeBuilder
extends AbstractRecipeBuilder<AlloyRecipeBuilder> {
    private final FluidStack output;
    private final int temperature;
    private final List<FluidIngredient> inputs = new ArrayList<FluidIngredient>();

    public static AlloyRecipeBuilder alloy(FluidStack fluid) {
        return AlloyRecipeBuilder.alloy(fluid, FluidVariantAttributes.getTemperature((FluidVariant)fluid.getType()) - 300);
    }

    public static AlloyRecipeBuilder alloy(class_3611 fluid, long amount) {
        return AlloyRecipeBuilder.alloy(new FluidStack(fluid, amount));
    }

    public AlloyRecipeBuilder addInput(FluidIngredient input) {
        this.inputs.add(input);
        return this;
    }

    public AlloyRecipeBuilder addInput(FluidStack input) {
        return this.addInput(FluidIngredient.of((FluidStack)input));
    }

    public AlloyRecipeBuilder addInput(class_3611 fluid, long amount) {
        return this.addInput(FluidIngredient.of((FluidStack)new FluidStack(fluid, amount)));
    }

    public AlloyRecipeBuilder addInput(class_6862<class_3611> tag, long amount) {
        return this.addInput(FluidIngredient.of(tag, (long)amount));
    }

    public void save(Consumer<class_2444> consumer) {
        this.save(consumer, Objects.requireNonNull(class_7923.field_41173.method_10221((Object)this.output.getFluid())));
    }

    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.inputs.size() < 2) {
            throw new IllegalStateException("Invalid alloying recipe " + id + ", must have at least two inputs");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "alloys");
        consumer.accept((class_2444)new Result(id, advancementId));
    }

    private AlloyRecipeBuilder(FluidStack output, int temperature) {
        this.output = output;
        this.temperature = temperature;
    }

    public static AlloyRecipeBuilder alloy(FluidStack output, int temperature) {
        return new AlloyRecipeBuilder(output, temperature);
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super((AbstractRecipeBuilder)AlloyRecipeBuilder.this, ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            JsonArray inputArray = new JsonArray();
            for (FluidIngredient input : AlloyRecipeBuilder.this.inputs) {
                inputArray.add(input.serialize());
            }
            json.add("inputs", (JsonElement)inputArray);
            json.add("result", (JsonElement)RecipeHelper.serializeFluidStack((FluidStack)AlloyRecipeBuilder.this.output));
            json.addProperty("temperature", (Number)AlloyRecipeBuilder.this.temperature);
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerSmeltery.alloyingSerializer.get();
        }
    }
}

