/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.models.TransformTypeDependentItemBakedModel;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_326;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;
import slimeknights.mantle.client.model.util.BakedItemModel;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolModel
implements IUnbakedGeometry<ToolModel> {
    private static final Logger log = LogManager.getLogger(ToolModel.class);
    public static final Loader LOADER = new Loader();
    public static final class_326 COLOR_HANDLER = (stack, index) -> {
        class_806 patt4799$temp;
        class_1087 itemModel;
        if (index >= 0 && (itemModel = class_310.method_1551().method_1480().method_4012().method_3304(stack.method_7909())) != null && (patt4799$temp = itemModel.method_4710()) instanceof MaterialOverrideHandler) {
            MaterialOverrideHandler overrides = (MaterialOverrideHandler)patt4799$temp;
            ToolStack tool = ToolStack.from(stack);
            int localIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            for (int i = modifiers.size() - 1; i >= 0; --i) {
                ModifierEntry entry = modifiers.get(i);
                IBakedModifierModel modifierModel = overrides.getModifierModel(entry.getModifier());
                if (modifierModel == null) continue;
                int modelIndexes = modifierModel.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return modifierModel.getTint(tool, entry, index - localIndex);
                }
                localIndex += modelIndexes;
            }
        }
        return -1;
    };
    private final List<ToolPart> toolParts;
    private final boolean isLarge;
    private final class_241 offset;
    private final List<class_2960> smallModifierRoots;
    private final List<class_2960> largeModifierRoots;
    private final List<ModifierId> firstModifiers;
    private Map<ModifierId, IBakedModifierModel> modifierModels = Collections.emptyMap();

    public static void registerItemColors(Supplier<? extends IModifiable> item) {
        ColorProviderRegistry.ITEM.register((Object)COLOR_HANDLER, (Object[])new class_1935[]{item.get()});
    }

    private static void addModifierQuads(Function<class_4730, class_1058> spriteGetter, Map<ModifierId, IBakedModifierModel> modifierModels, List<ModifierId> firstModifiers, IToolStackView tool, Consumer<Mesh> quadConsumer, ItemLayerPixels pixels, class_4590 transforms, boolean isLarge) {
        if (!modifierModels.isEmpty()) {
            int modelIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            if (!modifiers.isEmpty()) {
                int i;
                FirstModifier[] firsts = new FirstModifier[firstModifiers.size()];
                Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
                for (i = modifiers.size() - 1; i >= 0; --i) {
                    IBakedModifierModel model;
                    ModifierEntry entry = modifiers.get(i);
                    ModifierId modifier = entry.getModifier().getId();
                    if (hidden.contains((Object)modifier) || (model = modifierModels.get((Object)modifier)) == null) continue;
                    int index = firstModifiers.indexOf((Object)modifier);
                    if (index == -1) {
                        quadConsumer.accept(model.getQuads(tool, entry, spriteGetter, transforms, isLarge, modelIndex, pixels));
                    } else {
                        firsts[index] = new FirstModifier(entry, model, modelIndex);
                    }
                    modelIndex += model.getTintIndexes();
                }
                for (i = firsts.length - 1; i >= 0; --i) {
                    FirstModifier first = firsts[i];
                    if (first == null) continue;
                    quadConsumer.accept(first.model.getQuads(tool, first.entry, spriteGetter, transforms, isLarge, first.modelIndex, pixels));
                }
            }
        }
    }

    private static class_1087 bakeInternal(class_793 owner, Function<class_4730, class_1058> spriteGetter, @Nullable class_4590 largeTransforms, List<ToolPart> parts, Map<ModifierId, IBakedModifierModel> modifierModels, List<ModifierId> firstModifiers, List<MaterialVariantId> materials, @Nullable IToolStackView tool, class_806 overrides) {
        boolean isBroken = tool != null && tool.isBroken();
        class_1058 particle = null;
        ReversedListBuilder smallBuilder = new ReversedListBuilder();
        ReversedListBuilder largeBuilder = new ReversedListBuilder();
        ItemLayerPixels smallPixels = new ItemLayerPixels();
        ItemLayerPixels largePixels = new ItemLayerPixels();
        Consumer<Mesh> smallConsumer = arg_0 -> ((ReversedListBuilder)smallBuilder).add(arg_0);
        Consumer<Mesh> largeConsumer = arg_0 -> ((ReversedListBuilder)largeBuilder).add(arg_0);
        if (tool != null && !modifierModels.isEmpty()) {
            ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, smallConsumer, smallPixels, class_4590.method_22931(), false);
            if (largeTransforms != null) {
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, largeConsumer, largePixels, largeTransforms, true);
            }
        }
        if (parts.isEmpty()) {
            particle = spriteGetter.apply(owner.method_24077(isBroken && owner.method_3432("broken") ? "broken" : "tool"));
            smallConsumer.accept(MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (class_1058)particle, (class_4590)class_4590.method_22931(), (int)0, (ItemLayerPixels)smallPixels));
            if (largeTransforms != null) {
                largeConsumer.accept(MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (class_1058)spriteGetter.apply(owner.method_24077(isBroken && owner.method_3432("broken_large") ? "broken_large" : "tool_large")), (class_4590)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
            }
        } else {
            for (int i = parts.size() - 1; i >= 0; --i) {
                ToolPart part = parts.get(i);
                if (part.hasMaterials()) {
                    int index = part.index();
                    MaterialVariantId material = null;
                    if (index < materials.size()) {
                        material = materials.get(index);
                    }
                    particle = MaterialModel.getPartQuads(smallConsumer, owner, spriteGetter, class_4590.method_22931(), part.getName(isBroken, false), -1, material, smallPixels);
                    if (largeTransforms == null) continue;
                    MaterialModel.getPartQuads(largeConsumer, owner, spriteGetter, largeTransforms, part.getName(isBroken, true), -1, material, largePixels);
                    continue;
                }
                particle = spriteGetter.apply(owner.method_24077(part.getName(isBroken, false)));
                smallConsumer.accept(MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (class_1058)particle, (class_4590)class_4590.method_22931(), (int)0, (ItemLayerPixels)smallPixels));
                if (largeTransforms == null) continue;
                largeConsumer.accept(MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (class_1058)spriteGetter.apply(owner.method_24077(part.getName(isBroken, true))), (class_4590)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
            }
        }
        MeshBuilder finalSmallMesh = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = finalSmallMesh.getEmitter();
        for (Mesh mesh : smallBuilder.build()) {
            mesh.outputTo(emitter);
        }
        if (largeTransforms != null) {
            MeshBuilder finalLargeMesh = RendererAccess.INSTANCE.getRenderer().meshBuilder();
            QuadEmitter largeEmitter = finalLargeMesh.getEmitter();
            for (Mesh mesh : largeBuilder.build()) {
                mesh.outputTo(largeEmitter);
            }
            return new BakedLargeToolModel(finalLargeMesh.build(), finalSmallMesh.build(), particle, owner.method_3443(), overrides, owner.method_24298().method_24299());
        }
        return new BakedItemModel(finalSmallMesh.build(), quad -> true, particle, owner.method_3443(), overrides, true, owner.method_24298().method_24299());
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        HashSet allTextures;
        block6: {
            block5: {
                allTextures = Sets.newHashSet();
                if (!this.toolParts.isEmpty()) break block5;
                allTextures.add(owner.method_24077("tool"));
                if (owner.method_3432("broken")) {
                    allTextures.add(owner.method_24077("broken"));
                }
                if (!this.isLarge) break block6;
                allTextures.add(owner.method_24077("tool_large"));
                if (!owner.method_3432("broken_large")) break block6;
                allTextures.add(owner.method_24077("broken_large"));
                break block6;
            }
            for (ToolPart part : this.toolParts) {
                if (part.hasMaterials()) {
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, false), null);
                    if (part.hasBroken()) {
                        MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, false), null);
                    }
                    if (!this.isLarge) continue;
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, true), null);
                    if (!part.hasBroken()) continue;
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, true), null);
                    continue;
                }
                allTextures.add(owner.method_24077(part.getName(false, false)));
                if (part.hasBroken()) {
                    allTextures.add(owner.method_24077(part.getName(true, false)));
                }
                if (!this.isLarge) continue;
                allTextures.add(owner.method_24077(part.getName(false, true)));
                if (!part.hasBroken()) continue;
                allTextures.add(owner.method_24077(part.getName(true, true)));
            }
        }
        this.modifierModels = ModifierModelManager.getModelsForTool(this.smallModifierRoots, this.isLarge ? this.largeModifierRoots : Collections.emptyList(), allTextures);
        class_4590 largeTransforms = this.isLarge ? new class_4590(new Vector3f((this.offset.field_1343 - 8.0f) / 32.0f, (-this.offset.field_1342 - 8.0f) / 32.0f, 0.0f), null, new Vector3f(2.0f, 2.0f, 1.0f), null) : null;
        overrides = new MaterialOverrideHandler(owner, this.toolParts, this.firstModifiers, largeTransforms, this.modifierModels, overrides);
        return ToolModel.bakeInternal(owner, spriteGetter, largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, Collections.emptyList(), null, overrides);
    }

    public ToolModel(List<ToolPart> toolParts, boolean isLarge, class_241 offset, List<class_2960> smallModifierRoots, List<class_2960> largeModifierRoots, List<ModifierId> firstModifiers) {
        this.toolParts = toolParts;
        this.isLarge = isLarge;
        this.offset = offset;
        this.smallModifierRoots = smallModifierRoots;
        this.largeModifierRoots = largeModifierRoots;
        this.firstModifiers = firstModifiers;
    }

    private record FirstModifier(ModifierEntry entry, IBakedModifierModel model, int modelIndex) {
    }

    private record ToolPart(String name, int index, @Nullable String broken) {
        public boolean hasBroken() {
            return this.broken != null;
        }

        public boolean hasMaterials() {
            return this.index >= 0;
        }

        public String getName(boolean isBroken, boolean isLarge) {
            Object name = this.name;
            if (isBroken && this.broken != null) {
                name = this.broken;
            }
            if (isLarge) {
                name = "large_" + (String)name;
            }
            return name;
        }

        public static ToolPart read(JsonObject json) {
            String name = class_3518.method_15265((JsonObject)json, (String)"name");
            int index = class_3518.method_15282((JsonObject)json, (String)"index", (int)-1);
            String broken = null;
            if (json.has("broken")) {
                broken = class_3518.method_15265((JsonObject)json, (String)"broken");
            }
            return new ToolPart(name, index, broken);
        }
    }

    private static class BakedLargeToolModel
    implements class_1087,
    TransformTypeDependentItemBakedModel {
        private final Mesh largeQuads;
        private final class_1058 particleIcon;
        private final class_809 transforms;
        private final class_806 overrides;
        private final boolean usesBlockLight;
        private final class_1087 guiModel;

        private BakedLargeToolModel(Mesh largeQuads, Mesh smallQuads, class_1058 particle, class_809 transforms, class_806 overrides, boolean isSideLit) {
            this.largeQuads = largeQuads;
            this.particleIcon = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            this.usesBlockLight = isSideLit;
            this.guiModel = new BakedLargeToolGui(this, smallQuads);
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
            return ImmutableList.of();
        }

        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
            this.largeQuads.outputTo(context.getEmitter());
        }

        public boolean isVanillaAdapter() {
            return false;
        }

        public class_1087 applyTransform(class_811 type, class_4587 mat, boolean leftHanded, TransformTypeDependentItemBakedModel.DefaultTransform defaultTransform) {
            if (type == class_811.field_4317) {
                return ((TransformTypeDependentItemBakedModel)this.guiModel).applyTransform(type, mat, leftHanded, defaultTransform);
            }
            defaultTransform.apply((class_1087)this);
            return this;
        }

        public boolean method_4708() {
            return true;
        }

        public boolean method_4712() {
            return false;
        }

        public boolean method_4713() {
            return false;
        }

        public class_809 method_4709() {
            return this.transforms;
        }

        public class_1058 method_4711() {
            return this.particleIcon;
        }

        public class_806 method_4710() {
            return this.overrides;
        }

        public boolean method_24304() {
            return this.usesBlockLight;
        }
    }

    public static final class MaterialOverrideHandler
    extends class_806 {
        private static boolean ignoreNested = false;
        private final Cache<ToolCacheKey, class_1087> cache = CacheBuilder.newBuilder().maximumSize((long)MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().size() * 3L / 2L).build();
        private final class_793 owner;
        private final List<ToolPart> toolParts;
        private final List<ModifierId> firstModifiers;
        @Nullable
        private final class_4590 largeTransforms;
        private final Map<ModifierId, IBakedModifierModel> modifierModels;
        private final class_806 nested;

        private MaterialOverrideHandler(class_793 owner, List<ToolPart> toolParts, List<ModifierId> firstModifiers, @Nullable class_4590 largeTransforms, Map<ModifierId, IBakedModifierModel> modifierModels, class_806 nested) {
            this.owner = owner;
            this.toolParts = toolParts;
            this.firstModifiers = firstModifiers;
            this.largeTransforms = largeTransforms;
            this.modifierModels = modifierModels;
            this.nested = nested;
        }

        @Nullable
        public IBakedModifierModel getModifierModel(Modifier modifier) {
            return this.modifierModels.get((Object)modifier.getId());
        }

        private class_1087 bakeDynamic(List<MaterialVariantId> materials, IToolStackView tool) {
            return ToolModel.bakeInternal(this.owner, class_4730::method_24148, this.largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, materials, tool, class_806.field_4292);
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
            class_1087 overridden;
            if (!ignoreNested && (overridden = this.nested.method_3495(originalModel, stack, world, entity, seed)) != null && overridden != originalModel) {
                ignoreNested = true;
                class_1087 finalModel = overridden.method_4710().method_3495(overridden, stack, world, entity, seed);
                ignoreNested = false;
                return finalModel;
            }
            List<MaterialVariantId> materialIds = MaterialIdNBT.from(stack).getMaterials();
            ToolStack tool = ToolStack.from(stack);
            boolean broken = ToolDamageUtil.isBroken(stack);
            if (!broken && materialIds.isEmpty() && tool.getUpgrades().isEmpty()) {
                return originalModel;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
                Object cacheKey;
                IBakedModifierModel model;
                Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
                if (hidden.contains((Object)entry.getId()) || (model = this.getModifierModel(entry.getModifier())) == null || (cacheKey = model.getCacheKey(tool, entry)) == null) continue;
                builder.add(cacheKey);
            }
            try {
                return (class_1087)this.cache.get((Object)new ToolCacheKey(materialIds, (List<Object>)builder.build(), broken), () -> this.bakeDynamic(materialIds, tool));
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                return originalModel;
            }
        }
    }

    private static class Loader
    implements IGeometryLoader<ToolModel> {
        private Loader() {
        }

        public ToolModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            List parts = Collections.emptyList();
            if (modelContents.has("parts")) {
                parts = JsonHelper.parseList((JsonObject)modelContents, (String)"parts", ToolPart::read);
            }
            boolean isLarge = class_3518.method_15258((JsonObject)modelContents, (String)"large", (boolean)false);
            class_241 offset = class_241.field_1340;
            if (modelContents.has("large_offset")) {
                offset = MaterialModel.arrayToObject(modelContents, "large_offset");
            }
            List smallModifierRoots = Collections.emptyList();
            List largeModifierRoots = Collections.emptyList();
            if (modelContents.has("modifier_roots")) {
                if (isLarge) {
                    JsonObject modifierRoots = class_3518.method_15296((JsonObject)modelContents, (String)"modifier_roots");
                    BiFunction<JsonElement, String, class_2960> parser = (element, string) -> new class_2960(class_3518.method_15287((JsonElement)element, (String)string));
                    smallModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"small", parser);
                    largeModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"large", parser);
                } else {
                    smallModifierRoots = JsonHelper.parseList((JsonObject)modelContents, (String)"modifier_roots", (element, string) -> new class_2960(class_3518.method_15287((JsonElement)element, (String)string)));
                }
            }
            List firstModifiers = Collections.emptyList();
            if (modelContents.has("first_modifiers")) {
                firstModifiers = JsonHelper.parseList((JsonObject)modelContents, (String)"first_modifiers", ModifierId::convertFromJson);
            }
            return new ToolModel(parts, isLarge, offset, smallModifierRoots, largeModifierRoots, firstModifiers);
        }
    }

    private record ToolCacheKey(List<MaterialVariantId> materials, List<Object> modifierData, boolean broken) {
    }

    private static class BakedLargeToolGui
    extends ForwardingBakedModel
    implements TransformTypeDependentItemBakedModel {
        private final Mesh guiQuads;

        public BakedLargeToolGui(BakedLargeToolModel model, Mesh guiQuads) {
            this.wrapped = model;
            this.guiQuads = guiQuads;
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
            return ImmutableList.of();
        }

        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
            context.pushTransform(quad -> quad.lightFace() == class_2350.field_11035);
            this.guiQuads.outputTo(context.getEmitter());
            context.popTransform();
        }

        public class_1087 applyTransform(class_811 transform, class_4587 mat, boolean leftHanded, TransformTypeDependentItemBakedModel.DefaultTransform defaultTransform) {
            ((BakedLargeToolModel)this.wrapped).transforms.method_3503(transform).method_23075(leftHanded, mat);
            return this;
        }
    }
}

