/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.joml.Matrix4f;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;

public final class GuiUtil {
    public static void drawBackground(class_332 graphics, class_465<?> screen, class_2960 background) {
        RenderUtils.setup(background);
        graphics.method_25302(background, screen.field_2776, screen.field_2800, 0, 0, screen.field_2792, screen.field_2779);
    }

    @Deprecated
    public static void drawContainerNames(class_332 graphics, class_465<?> screen, class_327 font, class_2561 invName) {
        String name = screen.method_25440().getString();
        graphics.method_51433(font, name, screen.field_2792 / 2 - font.method_1727(name) / 2, 6, 0x404040, false);
        graphics.method_51439(font, invName, 8, screen.field_2779 - 96 + 2, 0x404040, false);
    }

    public static boolean isHovered(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public static boolean isTankHovered(int mouseX, int mouseY, int amount, int capacity, int x, int y, int width, int height) {
        if (mouseX < x || mouseX > x + width || mouseY > y + height) {
            return false;
        }
        int topHeight = height - height * amount / capacity;
        return mouseY > y + topHeight;
    }

    public static void renderFluidTank(class_4587 matrices, class_465<?> screen, FluidStack stack, long capacity, int x, int y, int width, int height, int depth) {
        GuiUtil.renderFluidTank(matrices, screen, stack, stack.getAmount(), capacity, x, y, width, height, depth);
    }

    public static void renderFluidTank(class_4587 matrices, class_465<?> screen, FluidStack stack, long amount, long capacity, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty() && capacity > 0L) {
            int maxY = y + height;
            long fluidHeight = Math.min((long)height * amount / capacity, (long)height);
            GuiUtil.renderTiledFluid(matrices, screen, stack, x, (long)maxY - fluidHeight, width, fluidHeight, depth);
        }
    }

    public static void renderTiledFluid(class_4587 matrices, class_465<?> screen, FluidStack stack, int x, long y, int width, long height, int depth) {
        if (!stack.isEmpty()) {
            class_1058 fluidSprite = FluidVariantRendering.getSprite((FluidVariant)stack.getType());
            RenderUtils.setColorRGBA(FluidVariantRendering.getColor((FluidVariant)stack.getType()));
            GuiUtil.renderTiledTextureAtlas(matrices, screen, fluidSprite, x, y, width, height, depth, FluidVariantAttributes.isLighterThanAir((FluidVariant)stack.getType()));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderTiledTextureAtlas(class_4587 matrices, class_465<?> screen, class_1058 sprite, int x, long y, int width, long height, int depth, boolean upsideDown) {
        RenderUtils.bindTexture(sprite.method_45852());
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        float u1 = sprite.method_4594();
        float v1 = sprite.method_4593();
        int spriteHeight = sprite.method_45851().method_45815();
        int spriteWidth = sprite.method_45851().method_45807();
        int startX = x + screen.field_2776;
        long startY = y + (long)screen.field_2800;
        do {
            long renderHeight = Math.min((long)spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.method_4570((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            int x2 = startX;
            int widthLeft = width;
            Matrix4f matrix = matrices.method_23760().method_23761();
            do {
                int renderWidth = Math.min(spriteWidth, widthLeft);
                widthLeft -= renderWidth;
                float u2 = sprite.method_4580((double)(16.0f * (float)renderWidth / (float)spriteWidth));
                if (upsideDown) {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v2, v1);
                } else {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v1, v2);
                }
                x2 += renderWidth;
            } while (widthLeft > 0);
            startY += renderHeight;
        } while (height > 0L);
        RenderSystem.enableDepthTest();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    private static void buildSquare(Matrix4f matrix, class_287 builder, int x1, int x2, long y1, long y2, int z, float u1, float u2, float v1, float v2) {
        builder.method_22918(matrix, (float)x1, (float)y2, (float)z).method_22913(u1, v2).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y2, (float)z).method_22913(u2, v2).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y1, (float)z).method_22913(u2, v1).method_1344();
        builder.method_22918(matrix, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_1344();
    }

    public static void drawProgressUp(class_332 graphics, class_2960 texture, ElementScreen element, int x, int y, float progress) {
        int height = progress > 1.0f ? element.h : (progress < 0.0f ? 0 : (int)((double)(progress * (float)element.h) + 0.5));
        int deltaY = element.h - height;
        graphics.method_25290(texture, x, y + deltaY, (float)element.x, (float)(element.y + deltaY), element.w, height, element.texW, element.texH);
    }

    public static void renderHighlight(class_332 graphics, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        graphics.method_25294(x, y, x + width, y + height, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static void renderPattern(class_332 graphics, Pattern pattern, int x, int y) {
        class_1058 sprite = class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(pattern.getTexture());
        graphics.method_25298(x, y, 100, 16, 16, sprite);
    }

    private GuiUtil() {
    }
}

